/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.log;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventValueDescription;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmlib.log.InvalidValueTypeException;
import com.android.ddmlib.log.LogReceiver;

final class GcEventContainer
extends EventContainer {
    public static final int GC_EVENT_TAG = 20001;
    private String processId;
    private long gcTime;
    private long bytesFreed;
    private long objectsFreed;
    private long actualSize;
    private long allowedSize;
    private long softLimit;
    private long objectsAllocated;
    private long bytesAllocated;
    private long zActualSize;
    private long zAllowedSize;
    private long zObjectsAllocated;
    private long zBytesAllocated;
    private long dlmallocFootprint;
    private long mallinfoTotalAllocatedSpace;
    private long externalLimit;
    private long externalBytesAllocated;

    GcEventContainer(LogReceiver.LogEntry logEntry, int n, Object object) {
        super(logEntry, n, object);
        this.init(object);
    }

    GcEventContainer(int n, int n2, int n3, int n4, int n5, Object object) {
        super(n, n2, n3, n4, n5, object);
        this.init(object);
    }

    private void init(Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Long)) continue;
                this.parseDvmHeapInfo((Long)objectArray[i], i);
            }
        }
    }

    public EventContainer.EventValueType getType() {
        return EventContainer.EventValueType.LIST;
    }

    public boolean testValue(int n, Object object, EventContainer.CompareMethod compareMethod) throws InvalidTypeException {
        if (n == 0 ? !(object instanceof String) : !(object instanceof Long)) {
            throw new InvalidTypeException();
        }
        switch (compareMethod) {
            case EQUAL_TO: {
                if (n == 0) {
                    return this.processId.equals(object);
                }
                return this.getValueAsLong(n) == ((Long)object).longValue();
            }
            case LESSER_THAN: {
                return this.getValueAsLong(n) <= (Long)object;
            }
            case LESSER_THAN_STRICT: {
                return this.getValueAsLong(n) < (Long)object;
            }
            case GREATER_THAN: {
                return this.getValueAsLong(n) >= (Long)object;
            }
            case GREATER_THAN_STRICT: {
                return this.getValueAsLong(n) > (Long)object;
            }
            case BIT_CHECK: {
                return (this.getValueAsLong(n) & (Long)object) != 0L;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Object getValue(int n) {
        if (n == 0) {
            return this.processId;
        }
        try {
            return new Long(this.getValueAsLong(n));
        }
        catch (InvalidTypeException invalidTypeException) {
            return null;
        }
    }

    public double getValueAsDouble(int n) throws InvalidTypeException {
        return this.getValueAsLong(n);
    }

    public String getValueAsString(int n) {
        switch (n) {
            case 0: {
                return this.processId;
            }
        }
        try {
            return Long.toString(this.getValueAsLong(n));
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    static EventValueDescription[] getValueDescriptions() {
        try {
            return new EventValueDescription[]{new EventValueDescription("Process Name", EventContainer.EventValueType.STRING), new EventValueDescription("GC Time", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.MILLISECONDS), new EventValueDescription("Freed Objects", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.OBJECTS), new EventValueDescription("Freed Bytes", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Soft Limit", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Actual Size (aggregate)", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Allowed Size (aggregate)", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Allocated Objects (aggregate)", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.OBJECTS), new EventValueDescription("Allocated Bytes (aggregate)", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Actual Size", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Allowed Size", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Allocated Objects", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.OBJECTS), new EventValueDescription("Allocated Bytes", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Actual Size (zygote)", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Allowed Size (zygote)", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Allocated Objects (zygote)", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.OBJECTS), new EventValueDescription("Allocated Bytes (zygote)", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("External Allocation Limit", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("External Bytes Allocated", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("dlmalloc Footprint", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES), new EventValueDescription("Malloc Info: Total Allocated Space", EventContainer.EventValueType.LONG, EventValueDescription.ValueType.BYTES)};
        }
        catch (InvalidValueTypeException invalidValueTypeException) {
            assert (false);
            return null;
        }
    }

    private void parseDvmHeapInfo(long l, int n) {
        switch (n) {
            case 0: {
                this.gcTime = GcEventContainer.float12ToInt((int)(l >> 12 & 0xFFFL));
                this.bytesFreed = GcEventContainer.float12ToInt((int)(l & 0xFFFL));
                byte[] byArray = new byte[8];
                GcEventContainer.put64bitsToArray(l, byArray, 0);
                this.processId = new String(byArray, 0, 5);
                break;
            }
            case 1: {
                this.objectsFreed = GcEventContainer.float12ToInt((int)(l >> 48 & 0xFFFL));
                this.actualSize = GcEventContainer.float12ToInt((int)(l >> 36 & 0xFFFL));
                this.allowedSize = GcEventContainer.float12ToInt((int)(l >> 24 & 0xFFFL));
                this.objectsAllocated = GcEventContainer.float12ToInt((int)(l >> 12 & 0xFFFL));
                this.bytesAllocated = GcEventContainer.float12ToInt((int)(l & 0xFFFL));
                break;
            }
            case 2: {
                this.softLimit = GcEventContainer.float12ToInt((int)(l >> 48 & 0xFFFL));
                this.zActualSize = GcEventContainer.float12ToInt((int)(l >> 36 & 0xFFFL));
                this.zAllowedSize = GcEventContainer.float12ToInt((int)(l >> 24 & 0xFFFL));
                this.zObjectsAllocated = GcEventContainer.float12ToInt((int)(l >> 12 & 0xFFFL));
                this.zBytesAllocated = GcEventContainer.float12ToInt((int)(l & 0xFFFL));
                break;
            }
            case 3: {
                this.dlmallocFootprint = GcEventContainer.float12ToInt((int)(l >> 36 & 0xFFFL));
                this.mallinfoTotalAllocatedSpace = GcEventContainer.float12ToInt((int)(l >> 24 & 0xFFFL));
                this.externalLimit = GcEventContainer.float12ToInt((int)(l >> 12 & 0xFFFL));
                this.externalBytesAllocated = GcEventContainer.float12ToInt((int)(l & 0xFFFL));
                break;
            }
        }
    }

    private static long float12ToInt(int n) {
        return (n & 0x1FF) << (n >>> 9) * 4;
    }

    private static void put64bitsToArray(long l, byte[] byArray, int n) {
        byArray[n + 7] = (byte)(l & 0xFFL);
        byArray[n + 6] = (byte)((l & 0xFF00L) >> 8);
        byArray[n + 5] = (byte)((l & 0xFF0000L) >> 16);
        byArray[n + 4] = (byte)((l & 0xFF000000L) >> 24);
        byArray[n + 3] = (byte)((l & 0xFF00000000L) >> 32);
        byArray[n + 2] = (byte)((l & 0xFF0000000000L) >> 40);
        byArray[n + 1] = (byte)((l & 0xFF000000000000L) >> 48);
        byArray[n + 0] = (byte)((l & 0xFF00000000000000L) >> 56);
    }

    private final long getValueAsLong(int n) throws InvalidTypeException {
        switch (n) {
            case 0: {
                throw new InvalidTypeException();
            }
            case 1: {
                return this.gcTime;
            }
            case 2: {
                return this.objectsFreed;
            }
            case 3: {
                return this.bytesFreed;
            }
            case 4: {
                return this.softLimit;
            }
            case 5: {
                return this.actualSize;
            }
            case 6: {
                return this.allowedSize;
            }
            case 7: {
                return this.objectsAllocated;
            }
            case 8: {
                return this.bytesAllocated;
            }
            case 9: {
                return this.actualSize - this.zActualSize;
            }
            case 10: {
                return this.allowedSize - this.zAllowedSize;
            }
            case 11: {
                return this.objectsAllocated - this.zObjectsAllocated;
            }
            case 12: {
                return this.bytesAllocated - this.zBytesAllocated;
            }
            case 13: {
                return this.zActualSize;
            }
            case 14: {
                return this.zAllowedSize;
            }
            case 15: {
                return this.zObjectsAllocated;
            }
            case 16: {
                return this.zBytesAllocated;
            }
            case 17: {
                return this.externalLimit;
            }
            case 18: {
                return this.externalBytesAllocated;
            }
            case 19: {
                return this.dlmallocFootprint;
            }
            case 20: {
                return this.mallinfoTotalAllocatedSpace;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

