/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.monkey;

import com.android.cts.monkey.AbstractMonkeyTest;
import java.util.regex.Pattern;

public class PackageTest
extends AbstractMonkeyTest {
    private static final Pattern ALLOW_MONKEY = Pattern.compile("^.*Allowing.*cmp=com\\.android\\.cts\\.monkey/\\.MonkeyActivity.*$", 8);
    private static final Pattern ALLOW_CHIMP = Pattern.compile("^.*Allowing.*cmp=com\\.android\\.cts\\.monkey2/\\.ChimpActivity.*$", 8);

    public void testSinglePackage() throws Exception {
        String string = this.mDevice.executeShellCommand("monkey -v -p " + PKGS[0] + " 5000");
        PackageTest.assertTrue((String)string, (boolean)ALLOW_MONKEY.matcher(string).find());
        PackageTest.assertFalse((String)string, (boolean)ALLOW_CHIMP.matcher(string).find());
        string = this.mDevice.executeShellCommand("monkey -v -p " + PKGS[1] + " 5000");
        PackageTest.assertFalse((String)string, (boolean)ALLOW_MONKEY.matcher(string).find());
        PackageTest.assertTrue((String)string, (boolean)ALLOW_CHIMP.matcher(string).find());
    }

    public void testMultiplePackages() throws Exception {
        String string = this.mDevice.executeShellCommand("monkey -v -p " + PKGS[0] + " -p " + PKGS[1] + " 5000");
        PackageTest.assertTrue((String)string, (boolean)ALLOW_MONKEY.matcher(string).find());
        PackageTest.assertTrue((String)string, (boolean)ALLOW_CHIMP.matcher(string).find());
    }
}

