/*
 * Decompiled with CFR 0.152.
 */
package com.android.hosttest;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.hosttest.DeviceConnector;
import com.android.hosttest.DeviceTest;
import com.android.hosttest.DeviceTestSuite;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.textui.TestRunner;

public class DeviceTestRunner
extends TestRunner {
    private static final String LOG_TAG = "DeviceTestRunner";
    private String mDeviceSerial = null;
    private IDevice mDevice = null;
    private String mTestDataPath = null;

    private DeviceTestRunner() {
    }

    public TestResult start(String[] stringArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-s")) {
                this.mDeviceSerial = this.extractArg(stringArray, ++i);
                continue;
            }
            if (stringArray[i].equals("-p")) {
                this.mTestDataPath = this.extractArg(stringArray, ++i);
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        DeviceConnector deviceConnector = new DeviceConnector();
        this.mDevice = deviceConnector.connectToDevice(this.mDeviceSerial);
        return super.start(arrayList.toArray(new String[arrayList.size()]));
    }

    private String extractArg(String[] stringArray, int n) {
        if (stringArray.length <= n) {
            DeviceTestRunner.printUsage();
            throw new IllegalArgumentException("Error: not enough arguments");
        }
        return stringArray[n];
    }

    public static void main(String[] stringArray) {
        DeviceTestRunner deviceTestRunner = new DeviceTestRunner();
        try {
            TestResult testResult = deviceTestRunner.start(stringArray);
            if (!testResult.wasSuccessful()) {
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(2);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: DeviceTestRunner <test_class> [-s device_serial] [-p test_data_path]");
    }

    public TestResult doRun(Test test, boolean bl) {
        if (test instanceof DeviceTest) {
            DeviceTest deviceTest = (DeviceTest)test;
            deviceTest.setDevice(this.mDevice);
            deviceTest.setTestAppPath(this.mTestDataPath);
        } else {
            Log.w((String)LOG_TAG, (String)String.format("%s test class is not a DeviceTest.", test.getClass().getName()));
        }
        return super.doRun(test, bl);
    }

    protected TestResult runSingleMethod(String string, String string2, boolean bl) throws Exception {
        Class clazz = this.loadSuiteClass(string);
        Test test = DeviceTestSuite.createTest((Class)clazz, (String)string2);
        return this.doRun(test, bl);
    }
}

