/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import java.io.File;
import java.io.IOException;

public class DeviceBuildInfo
extends BuildInfo
implements IDeviceBuildInfo {
    private static final String DEVICE_IMAGE_NAME = "device";
    private static final String USERDATA_IMAGE_NAME = "userdata";
    private static final String TESTDIR_IMAGE_NAME = "testsdir";
    private static final String BASEBAND_IMAGE_NAME = "baseband";
    private static final String BOOTLOADER_IMAGE_NAME = "bootloader";
    private static final String OTA_IMAGE_NAME = "ota";
    private static final String MKBOOTIMG_IMAGE_NAME = "mkbootimg";
    private static final String RAMDISK_IMAGE_NAME = "ramdisk";

    public DeviceBuildInfo() {
    }

    public DeviceBuildInfo(String buildId, String testTag, String buildTargetName) {
        super(buildId, testTag, buildTargetName);
    }

    public DeviceBuildInfo(BuildInfo buildInfo) {
        super(buildInfo);
    }

    public String getDeviceBuildId() {
        String buildId = this.getDeviceImageVersion();
        return buildId == null ? "-1" : buildId;
    }

    public File getDeviceImageFile() {
        return this.getFile(DEVICE_IMAGE_NAME);
    }

    public String getDeviceImageVersion() {
        return this.getVersion(DEVICE_IMAGE_NAME);
    }

    public void setDeviceImageFile(File deviceImageFile, String version) {
        this.setFile(DEVICE_IMAGE_NAME, deviceImageFile, version);
    }

    public File getUserDataImageFile() {
        return this.getFile(USERDATA_IMAGE_NAME);
    }

    public String getUserDataImageVersion() {
        return this.getVersion(USERDATA_IMAGE_NAME);
    }

    public void setUserDataImageFile(File userDataFile, String version) {
        this.setFile(USERDATA_IMAGE_NAME, userDataFile, version);
    }

    public File getTestsDir() {
        return this.getFile(TESTDIR_IMAGE_NAME);
    }

    public String getTestsDirVersion() {
        return this.getVersion(TESTDIR_IMAGE_NAME);
    }

    public void setTestsDir(File testsDir, String version) {
        this.setFile(TESTDIR_IMAGE_NAME, testsDir, version);
    }

    public File getBasebandImageFile() {
        return this.getFile(BASEBAND_IMAGE_NAME);
    }

    public String getBasebandVersion() {
        return this.getVersion(BASEBAND_IMAGE_NAME);
    }

    public void setBasebandImage(File basebandFile, String version) {
        this.setFile(BASEBAND_IMAGE_NAME, basebandFile, version);
    }

    public File getBootloaderImageFile() {
        return this.getFile(BOOTLOADER_IMAGE_NAME);
    }

    public String getBootloaderVersion() {
        return this.getVersion(BOOTLOADER_IMAGE_NAME);
    }

    public void setBootloaderImageFile(File bootloaderImgFile, String version) {
        this.setFile(BOOTLOADER_IMAGE_NAME, bootloaderImgFile, version);
    }

    public File getOtaPackageFile() {
        return this.getFile(OTA_IMAGE_NAME);
    }

    public String getOtaPackageVersion() {
        return this.getVersion(OTA_IMAGE_NAME);
    }

    public void setOtaPackageFile(File otaFile, String version) {
        this.setFile(OTA_IMAGE_NAME, otaFile, version);
    }

    public File getMkbootimgFile() {
        return this.getFile(MKBOOTIMG_IMAGE_NAME);
    }

    public String getMkbootimgVersion() {
        return this.getVersion(MKBOOTIMG_IMAGE_NAME);
    }

    public void setMkbootimgFile(File mkbootimg, String version) {
        this.setFile(MKBOOTIMG_IMAGE_NAME, mkbootimg, version);
    }

    public File getRamdiskFile() {
        return this.getFile(RAMDISK_IMAGE_NAME);
    }

    public String getRamdiskVersion() {
        return this.getVersion(RAMDISK_IMAGE_NAME);
    }

    public void setRamdiskFile(File ramdisk, String version) {
        this.setFile(RAMDISK_IMAGE_NAME, ramdisk, version);
    }

    public IBuildInfo clone() {
        DeviceBuildInfo copy = new DeviceBuildInfo(this.getBuildId(), this.getTestTag(), this.getBuildTargetName());
        copy.addAllBuildAttributes(this);
        try {
            copy.addAllFiles(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        copy.setBuildBranch(this.getBuildBranch());
        copy.setBuildFlavor(this.getBuildFlavor());
        return copy;
    }
}

