/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IFolderBuildInfo;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class FolderBuildInfo
extends BuildInfo
implements IFolderBuildInfo {
    private File mRootDir;

    public FolderBuildInfo(String buildId, String testTarget, String buildName) {
        super(buildId, testTarget, buildName);
    }

    FolderBuildInfo(BuildInfo buildToCopy) {
        super(buildToCopy);
    }

    public File getRootDir() {
        return this.mRootDir;
    }

    public void setRootDir(File rootDir) {
        this.mRootDir = rootDir;
    }

    public void cleanUp() {
        if (this.mRootDir != null) {
            FileUtil.recursiveDelete(this.mRootDir);
        }
        this.mRootDir = null;
    }

    public IBuildInfo clone() {
        FolderBuildInfo copy = new FolderBuildInfo(this.getBuildId(), this.getTestTag(), this.getBuildTargetName());
        copy.addAllBuildAttributes(this);
        try {
            File copyDir = FileUtil.createTempDir("foldercopy");
            FileUtil.recursiveCopy(this.mRootDir, copyDir);
            copy.setRootDir(copyDir);
            return copy;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

