/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IKernelBuildInfo;
import java.io.File;
import java.io.IOException;

public class KernelBuildInfo
extends BuildInfo
implements IKernelBuildInfo {
    private static final String KERNEL_FILE = "kernel";
    private String mSha1 = null;
    private String mShortSha1 = null;
    private long mCommitTime = 0L;

    public KernelBuildInfo() {
    }

    public KernelBuildInfo(String sha1, String shortSha1, long commitTime, String testTarget, String buildName) {
        super(sha1, testTarget, buildName);
        this.mSha1 = sha1;
        this.mShortSha1 = shortSha1;
        this.mCommitTime = commitTime;
    }

    public File getKernelFile() {
        return this.getFile(KERNEL_FILE);
    }

    public String getKernelVersion() {
        return this.getVersion(KERNEL_FILE);
    }

    public void setKernelFile(File kernelFile, String version) {
        this.setFile(KERNEL_FILE, kernelFile, version);
    }

    public String getSha1() {
        return this.mSha1;
    }

    public void setSha1(String sha1) {
        this.mSha1 = sha1;
    }

    public String getShortSha1() {
        return this.mShortSha1;
    }

    public void setShortSha1(String shortSha1) {
        this.mShortSha1 = shortSha1;
    }

    public long getCommitTime() {
        return this.mCommitTime;
    }

    public void setCommitTime(long time) {
        this.mCommitTime = time;
    }

    public IBuildInfo clone() {
        KernelBuildInfo copy = new KernelBuildInfo(this.getSha1(), this.getShortSha1(), this.getCommitTime(), this.getTestTag(), this.getBuildTargetName());
        copy.addAllBuildAttributes(this);
        try {
            copy.addAllFiles(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        copy.setBuildBranch(this.getBuildBranch());
        copy.setBuildFlavor(this.getBuildFlavor());
        return copy;
    }
}

