/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import java.io.File;

@OptionClass(alias="local-build")
public class LocalBuildProvider
extends StubBuildProvider {
    private static final String IMAGE_FILE_OPTION_NAME = "device-image-file";
    private static final String TEST_DIR_OPTION_NAME = "test-dir";
    private static final String DATA_FILE_OPTION_NAME = "user-data-file";
    @Option(name="device-image-file", description="the device image file to use.", importance=Option.Importance.IF_UNSET)
    private File mDeviceImageFile = null;
    @Option(name="test-dir", description="the dir containing the unzipped test files.")
    private File mTestsDir = null;
    @Option(name="user-data-file", description="the user data file to use.")
    private File mUserDataFile = null;

    public IBuildInfo getBuild() throws BuildRetrievalError {
        if (this.mDeviceImageFile == null) {
            throw new IllegalArgumentException(String.format("missing --%s option", IMAGE_FILE_OPTION_NAME));
        }
        if (!this.mDeviceImageFile.exists()) {
            throw new IllegalArgumentException(String.format("Local image path '%s' is invalid. Please provide a valid path via --%s", this.mDeviceImageFile.getAbsolutePath(), IMAGE_FILE_OPTION_NAME));
        }
        BuildInfo stubBuild = (BuildInfo)super.getBuild();
        DeviceBuildInfo buildInfo = new DeviceBuildInfo(stubBuild.getBuildId(), stubBuild.getTestTag(), stubBuild.getBuildTargetName());
        buildInfo.addAllBuildAttributes(stubBuild);
        try {
            buildInfo.setDeviceImageFile(this.mDeviceImageFile, stubBuild.getBuildId());
            if (this.mTestsDir != null) {
                buildInfo.setTestsDir(this.mTestsDir, stubBuild.getBuildId());
            } else {
                LogUtil.CLog.d("Null Test Dir, if you want to pass a test dir, use --%s", TEST_DIR_OPTION_NAME);
            }
            if (this.mUserDataFile != null) {
                buildInfo.setUserDataImageFile(this.mUserDataFile, stubBuild.getBuildId());
            } else {
                LogUtil.CLog.d("Null User Data File, if you want to pass a user data file, use --%s", DATA_FILE_OPTION_NAME);
            }
            return buildInfo;
        }
        catch (RuntimeException e) {
            buildInfo.cleanUp();
            throw e;
        }
    }

    public void buildNotTested(IBuildInfo info) {
    }

    public void cleanUp(IBuildInfo info) {
    }
}

