/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.build.SdkBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;

@OptionClass(alias="local-sdk")
public class LocalSdkBuildProvider
implements IBuildProvider {
    private static final String SDK_OPTION_NAME = "sdk-path";
    @Option(name="sdk-path", description="the local filesystem path to sdk root directory to test.", importance=Option.Importance.IF_UNSET)
    private File mLocalSdkPath = this.getSdkFromBuildEnv();
    @Option(name="adt-path", description="the local filesystem path to a adt directory to test.", importance=Option.Importance.IF_UNSET)
    private File mLocalAdtPath = null;

    public IBuildInfo getBuild() throws BuildRetrievalError {
        SdkBuildInfo sdkBuild = new SdkBuildInfo("0", "local-sdk", "sdk");
        if (this.mLocalSdkPath == null) {
            throw new IllegalArgumentException(String.format("missing --%s option", SDK_OPTION_NAME));
        }
        if (!this.mLocalSdkPath.exists()) {
            throw new IllegalArgumentException(String.format("SDK path '%s' does not exist. Please provide a valid sdk via --%s, or ensure you are running tradefed in a Android build env with a built SDK", this.mLocalSdkPath.getAbsolutePath(), SDK_OPTION_NAME));
        }
        sdkBuild.setSdkDir(this.mLocalSdkPath);
        sdkBuild.setAdtDir(this.mLocalAdtPath);
        return sdkBuild;
    }

    public void buildNotTested(IBuildInfo info) {
    }

    public void cleanUp(IBuildInfo info) {
    }

    private File getSdkFromBuildEnv() {
        String buildRoot = System.getenv("ANDROID_BUILD_TOP");
        if (buildRoot != null) {
            String osName = System.getProperty("os.name");
            String osPath = null;
            if (osName.contains("Mac")) {
                osPath = "darwin-x86";
            } else if (osName.contains("Linux")) {
                osPath = "linux-x86";
            } else {
                LogUtil.CLog.w(String.format("Cannot determine sdk build path due to unrecognized os '%s'", osName));
                return null;
            }
            String userName = System.getProperty("user.name");
            String path = FileUtil.getPath(buildRoot, "out", "host", osPath, "sdk", String.format("android-sdk_eng.%s_%s", userName, osPath));
            return new File(path);
        }
        return null;
    }
}

