/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.ISdkBuildInfo;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;

public class SdkBuildInfo
extends BuildInfo
implements ISdkBuildInfo {
    private File mAdtDir = null;
    private File mSdkDir = null;
    private boolean mDeleteSdkDirParent;
    private static final int ANDROID_TIMEOUT_MS = 15000;

    public SdkBuildInfo() {
    }

    public SdkBuildInfo(String buildId, String testTarget, String buildName) {
        super(buildId, testTarget, buildName);
    }

    public File getSdkDir() {
        return this.mSdkDir;
    }

    public File getAdtDir() {
        return this.mAdtDir;
    }

    public void setAdtDir(File adtDir) {
        this.mAdtDir = adtDir;
    }

    public void setSdkDir(File sdkDir) {
        this.setSdkDir(sdkDir, false);
    }

    public void setSdkDir(File sdkDir, boolean deleteParent) {
        this.mSdkDir = sdkDir;
        this.mDeleteSdkDirParent = deleteParent;
    }

    public void cleanUp() {
        if (this.mSdkDir != null) {
            if (this.mDeleteSdkDirParent) {
                FileUtil.recursiveDelete(this.mSdkDir.getParentFile());
            } else {
                FileUtil.recursiveDelete(this.mSdkDir);
            }
        }
        if (this.mAdtDir != null) {
            FileUtil.recursiveDelete(this.mAdtDir);
        }
        this.mSdkDir = null;
        this.mAdtDir = null;
    }

    public IBuildInfo clone() {
        SdkBuildInfo cloneBuild = new SdkBuildInfo(this.getBuildId(), this.getTestTag(), this.getBuildTargetName());
        cloneBuild.addAllBuildAttributes(this);
        try {
            File cloneAdtDir = null;
            if (this.getAdtDir() != null) {
                cloneAdtDir = FileUtil.createTempDir("cloneAdt");
                FileUtil.recursiveCopy(this.getAdtDir(), cloneAdtDir);
                cloneBuild.setAdtDir(cloneAdtDir);
            }
            File cloneSdkDir = null;
            if (this.getSdkDir() != null) {
                cloneSdkDir = FileUtil.createTempDir("cloneSdk");
                FileUtil.recursiveCopy(this.getSdkDir(), cloneSdkDir);
                cloneBuild.setSdkDir(cloneSdkDir);
            }
            return cloneBuild;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not clone sdk build", e);
        }
    }

    public String getAndroidToolPath() {
        if (this.getSdkDir() == null) {
            throw new IllegalStateException("sdk dir is not set");
        }
        return FileUtil.getPath(this.getSdkDir().getAbsolutePath(), "tools", "android");
    }

    public String[] getSdkTargets() {
        CommandResult result = this.getRunUtil().runTimedCmd(15000L, this.getAndroidToolPath(), "list", "targets", "--compact");
        if (!result.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            LogUtil.CLog.e(String.format("Unable to get list of SDK targets using %s. Result %s, err %s", new Object[]{this.getAndroidToolPath(), result.getStatus(), result.getStderr()}));
            return null;
        }
        return result.getStdout().split("\n");
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public String getEmulatorToolPath() {
        if (this.getSdkDir() == null) {
            throw new IllegalStateException("sdk dir is not set");
        }
        return FileUtil.getPath(this.getSdkDir().getAbsolutePath(), "tools", "emulator");
    }

    public void makeToolsExecutable() {
        File toolsDir = FileUtil.getFileForPath(this.getSdkDir(), "tools");
        this.makeExecutable(toolsDir.listFiles());
        File platformToolsDir = FileUtil.getFileForPath(this.getSdkDir(), "platform-tools");
        this.makeExecutable(platformToolsDir.listFiles());
    }

    private void makeExecutable(File[] files) {
        if (files != null) {
            for (File file : files) {
                file.setExecutable(true, true);
            }
        }
    }
}

