/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import java.util.HashMap;
import java.util.Map;

@OptionClass(alias="stub")
public class StubBuildProvider
implements IBuildProvider {
    @Option(name="build-id", description="build id to supply.")
    private String mBuildId = "0";
    @Option(name="test-tag", description="test tag name to supply.")
    private String mTestTag = "stub";
    @Option(name="build-target", description="build target name to supply.")
    private String mBuildTargetName = "stub";
    @Option(name="branch", description="build branch name to supply.")
    private String mBranch = null;
    @Option(name="build-flavor", description="build flavor name to supply.")
    private String mBuildFlavor = null;
    @Option(name="build-attribute", description="build attributes to supply.")
    private Map<String, String> mBuildAttributes = new HashMap<String, String>();

    public IBuildInfo getBuild() throws BuildRetrievalError {
        Log.d((String)"BuildProvider", (String)"skipping build provider step");
        BuildInfo stubBuild = new BuildInfo(this.mBuildId, this.mTestTag, this.mBuildTargetName);
        stubBuild.setBuildBranch(this.mBranch);
        stubBuild.setBuildFlavor(this.mBuildFlavor);
        for (Map.Entry<String, String> attributeEntry : this.mBuildAttributes.entrySet()) {
            stubBuild.addBuildAttribute(attributeEntry.getKey(), attributeEntry.getValue());
        }
        return stubBuild;
    }

    public void buildNotTested(IBuildInfo info) {
    }

    public void cleanUp(IBuildInfo info) {
    }
}

