/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.Log;
import com.android.tradefed.command.CommandFileParser;
import com.android.tradefed.command.CommandScheduler;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.command.NotifyingCommandListener;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.log.ConsoleReaderOutputStream;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RegexTrie;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import jline.ConsoleReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Console
extends Thread {
    private static final String CONSOLE_PROMPT = "tf >";
    protected static final String HELP_PATTERN = "\\?|h|help";
    protected static final String LIST_PATTERN = "l(?:ist)?";
    protected static final String DUMP_PATTERN = "d(?:ump)?";
    protected static final String RUN_PATTERN = "r(?:un)?";
    protected static final String EXIT_PATTERN = "(?:q|exit)";
    protected static final String SET_PATTERN = "s(?:et)?";
    protected static final String REMOVE_PATTERN = "remove";
    protected static final String DEBUG_PATTERN = "debug";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static ConsoleReaderOutputStream sConsoleStream = null;
    protected ICommandScheduler mScheduler;
    protected ConsoleReader mConsoleReader;
    private RegexTrie<Runnable> mCommandTrie = new RegexTrie();
    private boolean mShouldExit = false;
    private String[] mMainArgs = new String[0];

    RegexTrie<Runnable> getCommandTrie() {
        return this.mCommandTrie;
    }

    protected static ConsoleReader getReader() {
        try {
            if (sConsoleStream == null) {
                ConsoleReader reader = new ConsoleReader();
                sConsoleStream = new ConsoleReaderOutputStream(reader);
                System.setOut(new PrintStream(sConsoleStream));
            }
            return sConsoleStream.getConsoleReader();
        }
        catch (IOException e) {
            System.err.format("Failed to initialize ConsoleReader: %s\n", e.getMessage());
            return null;
        }
    }

    protected Console() {
        this(new CommandScheduler(), Console.getReader());
    }

    Console(ICommandScheduler scheduler, ConsoleReader reader) {
        this.mScheduler = scheduler;
        this.mConsoleReader = reader;
        LinkedList<String> genericHelp = new LinkedList<String>();
        LinkedHashMap<String, String> commandHelp = new LinkedHashMap<String, String>();
        this.addDefaultCommands(this.mCommandTrie, genericHelp, commandHelp);
        this.setCustomCommands(this.mCommandTrie, genericHelp, commandHelp);
        this.generateHelpListings(this.mCommandTrie, genericHelp, commandHelp);
    }

    protected void setCustomCommands(RegexTrie<Runnable> trie, List<String> genericHelp, Map<String, String> commandHelp) {
    }

    void generateHelpListings(RegexTrie<Runnable> trie, List<String> genericHelp, Map<String, String> commandHelp) {
        final String genHelpString = this.getGenericHelpString(genericHelp);
        String helpPattern = HELP_PATTERN;
        final ArgRunnable<CaptureList> genericHelpRunnable = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                Console.this.printLine(genHelpString);
            }
        };
        trie.put((Runnable)genericHelpRunnable, HELP_PATTERN);
        StringBuilder allHelpBuilder = new StringBuilder();
        for (Map.Entry<String, String> helpPair : commandHelp.entrySet()) {
            String key = helpPair.getKey();
            final String helpText = helpPair.getValue();
            trie.put(new Runnable(){

                public void run() {
                    Console.this.printLine(helpText);
                }
            }, HELP_PATTERN, key);
            allHelpBuilder.append(helpText);
            allHelpBuilder.append(LINE_SEPARATOR);
        }
        final String allHelpText = allHelpBuilder.toString();
        trie.put(new Runnable(){

            public void run() {
                Console.this.printLine(allHelpText);
            }
        }, HELP_PATTERN, "all");
        trie.put((Runnable)new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                Console.this.printLine(String.format("No help for '%s'; command is unknown or undocumented", ((List)args.get(1)).get(0)));
                genericHelpRunnable.run(args);
            }
        }, HELP_PATTERN, null);
        trie.put((Runnable)new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                if (args.isEmpty()) {
                    return;
                }
                Console.this.printLine(String.format("Unknown command: '%s'", ((List)args.get(0)).get(0)));
                genericHelpRunnable.run(args);
            }
        }, new Pattern[]{null});
    }

    protected String getGenericHelpString(List<String> genericHelp) {
        return ArrayUtil.join(LINE_SEPARATOR, genericHelp);
    }

    static List<String> getFlatArgs(int argIdx, CaptureList cl) {
        if (argIdx < 0 || argIdx >= cl.size()) {
            throw new IndexOutOfBoundsException(String.format("argIdx is %d, cl size is %d", argIdx, cl.size()));
        }
        ArrayList<String> flat = new ArrayList<String>(cl.size() - argIdx);
        ListIterator iter = cl.listIterator(argIdx);
        while (iter.hasNext()) {
            List single = (List)iter.next();
            int len = single.size();
            if (len != 1) {
                throw new IllegalArgumentException(String.format("Expected a singleton List, but got a List with %d elements: %s", len, single.toString()));
            }
            flat.add((String)single.get(0));
        }
        return flat;
    }

    void addDefaultCommands(RegexTrie<Runnable> trie, List<String> genericHelp, Map<String, String> commandHelp) {
        genericHelp.add("Enter 'q' or 'exit' to exit");
        genericHelp.add("Enter 'kill' to attempt to forcibly exit, by shutting down adb");
        genericHelp.add("");
        genericHelp.add("Enter 'help all' to see all embedded documentation at once.");
        genericHelp.add("");
        genericHelp.add("Enter 'help list'   for help with 'list' commands");
        genericHelp.add("Enter 'help run'    for help with 'run' commands");
        genericHelp.add("Enter 'help dump'   for help with 'dump' commands");
        genericHelp.add("Enter 'help set'    for help with 'set' commands");
        genericHelp.add("Enter 'help remove' for help with 'remove' commands");
        genericHelp.add("Enter 'help debug'  for help with 'debug' commands");
        commandHelp.put(LIST_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\ti[nvocations]  List all invocation threads" + LINE_SEPARATOR + "\td[evices]      List all detected or known devices" + LINE_SEPARATOR + "\tc[ommands]     List all commands currently waiting to be executed" + LINE_SEPARATOR + "\tconfigs        List all known configurations" + LINE_SEPARATOR, LIST_PATTERN));
        commandHelp.put(DUMP_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\ts[tack]            Dump the stack traces of all threads" + LINE_SEPARATOR + "\tl[ogs]             Dump the logs of all invocations to files" + LINE_SEPARATOR + "\tc[onfig] <config>  Dump the content of the specified config" + LINE_SEPARATOR + "\tcommandQueue       Dump the contents of the commmand execution queue" + LINE_SEPARATOR, DUMP_PATTERN));
        commandHelp.put(RUN_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tcommand <config>  [options]       Run the specified command" + LINE_SEPARATOR + "\t<config> [options]                Shortcut for the above: run specified command" + LINE_SEPARATOR + "\tcmdfile <cmdfile.txt>             Run the specified commandfile" + LINE_SEPARATOR + "\tsingleCommand <config> [options]  Run the specified command, and run 'exit' " + "immediately afterward" + LINE_SEPARATOR, RUN_PATTERN));
        commandHelp.put(SET_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tlog-level-display <level>  Sets the global display log level to <level>" + LINE_SEPARATOR + "\tenable-handover-server     Starts a handover server. Used to handover control " + "from another TF process running on same machine." + LINE_SEPARATOR + "\tdisable-handover-server    Force shutdown of the handover server." + LINE_SEPARATOR, SET_PATTERN));
        commandHelp.put(REMOVE_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tremove allCommands  Remove all commands currently waiting to be executed" + LINE_SEPARATOR, REMOVE_PATTERN));
        commandHelp.put(DEBUG_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tgc      Attempt to force a GC" + LINE_SEPARATOR, DEBUG_PATTERN));
        trie.put((Runnable)new QuitRunnable(), EXIT_PATTERN, null);
        trie.put((Runnable)new QuitRunnable(), EXIT_PATTERN);
        trie.put((Runnable)new ForceQuitRunnable(), "kill");
        trie.put(new Runnable(){

            public void run() {
                Console.this.mScheduler.displayInvocationsInfo(new PrintWriter(System.out, true));
            }
        }, LIST_PATTERN, "i(?:nvocations)?");
        trie.put(new Runnable(){

            public void run() {
                IDeviceManager manager = DeviceManager.getInstance();
                manager.displayDevicesInfo(new PrintWriter(System.out, true));
            }
        }, LIST_PATTERN, "d(?:evices)?");
        trie.put(new Runnable(){

            public void run() {
                Console.this.mScheduler.displayCommandsInfo(new PrintWriter(System.out, true));
            }
        }, LIST_PATTERN, "c(?:ommands)?");
        trie.put(new Runnable(){

            public void run() {
                Console.this.getConfigurationFactory().printHelp(System.out);
            }
        }, LIST_PATTERN, "configs");
        trie.put(new Runnable(){

            public void run() {
                Console.this.dumpStacks();
            }
        }, DUMP_PATTERN, "s(?:tacks?)?");
        trie.put(new Runnable(){

            public void run() {
                Console.this.dumpLogs();
            }
        }, DUMP_PATTERN, "l(?:ogs?)?");
        ArgRunnable<CaptureList> dumpConfigRun = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                String configArg = (String)((List)args.get(2)).get(0);
                Console.this.getConfigurationFactory().dumpConfig(configArg, System.out);
            }
        };
        trie.put((Runnable)dumpConfigRun, DUMP_PATTERN, "c(?:onfig?)?", "(.*)");
        trie.put(new Runnable(){

            public void run() {
                Console.this.mScheduler.displayCommandQueue(new PrintWriter(System.out, true));
            }
        }, DUMP_PATTERN, "commandQueue");
        ArgRunnable<CaptureList> runRunCommand = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                int startIdx = 1;
                if (((List)args.get(1)).isEmpty()) {
                    startIdx = 2;
                }
                String[] flatArgs = new String[args.size() - startIdx];
                for (int i = startIdx; i < args.size(); ++i) {
                    flatArgs[i - startIdx] = (String)((List)args.get(i)).get(0);
                }
                Console.this.mScheduler.addCommand(flatArgs);
            }
        };
        trie.put((Runnable)runRunCommand, RUN_PATTERN, "c(?:ommand)?", null);
        trie.put((Runnable)runRunCommand, RUN_PATTERN, null);
        ArgRunnable<CaptureList> runAndExitCommand = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                String[] flatArgs = new String[args.size() - 2];
                for (int i = 2; i < args.size(); ++i) {
                    flatArgs[i - 2] = (String)((List)args.get(i)).get(0);
                }
                NotifyingCommandListener cmdListener = new NotifyingCommandListener();
                cmdListener.setExpectedCalls(1);
                if (Console.this.mScheduler.addCommand(flatArgs, cmdListener)) {
                    try {
                        cmdListener.waitForExpectedCalls();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                Console.this.mScheduler.shutdown();
                Console.this.mShouldExit = true;
            }
        };
        trie.put((Runnable)runAndExitCommand, RUN_PATTERN, "s(?:ingleCommand)?", null);
        ArgRunnable<CaptureList> runRunCmdfile = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                int startIdx = 2;
                List<String> flatArgs = Console.getFlatArgs(startIdx, args);
                String file = flatArgs.get(0);
                List<String> extraArgs = flatArgs.subList(1, flatArgs.size());
                Console.this.printLine(String.format("Attempting to run cmdfile %s with args %s", file, extraArgs.toString()));
                try {
                    Console.this.createCommandFileParser().parseFile(new File(file), Console.this.mScheduler, extraArgs);
                }
                catch (IOException e) {
                    Console.this.printLine(String.format("Failed to run %s: %s", file, e));
                }
                catch (ConfigurationException e) {
                    Console.this.printLine(String.format("Failed to run %s: %s", file, e));
                }
            }
        };
        trie.put((Runnable)runRunCmdfile, RUN_PATTERN, "cmdfile", "(.*)");
        trie.put((Runnable)runRunCmdfile, RUN_PATTERN, "cmdfile", "(.*)", null);
        ArgRunnable<CaptureList> runSetLog = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                String logLevelStr = (String)((List)args.get(2)).get(0);
                Log.LogLevel newLogLevel = Log.LogLevel.getByString((String)logLevelStr);
                Log.LogLevel currentLogLevel = LogRegistry.getLogRegistry().getGlobalLogDisplayLevel();
                if (newLogLevel != null) {
                    LogRegistry.getLogRegistry().setGlobalLogDisplayLevel(newLogLevel);
                    currentLogLevel = LogRegistry.getLogRegistry().getGlobalLogDisplayLevel();
                    if (currentLogLevel != null) {
                        Console.this.printLine(String.format("Log level now set to '%s'.", currentLogLevel));
                    }
                } else if (currentLogLevel == null) {
                    Console.this.printLine(String.format("Invalid log level '%s'.", newLogLevel));
                } else {
                    Console.this.printLine(String.format("Invalid log level '%s'; log level remains at '%s'.", newLogLevel, currentLogLevel));
                }
            }
        };
        trie.put((Runnable)runSetLog, SET_PATTERN, "log-level-display", "(.*)");
        trie.put(new Runnable(){

            public void run() {
                Console.this.startRemoteManager();
            }
        }, SET_PATTERN, "enable-handover-server");
        trie.put(new Runnable(){

            public void run() {
                Console.this.mScheduler.stopRemoteManager();
            }
        }, SET_PATTERN, "disable-handover-server");
        trie.put(new Runnable(){

            public void run() {
                System.gc();
            }
        }, DEBUG_PATTERN, "gc");
        trie.put(new Runnable(){

            public void run() {
                Console.this.mScheduler.removeAllCommands();
            }
        }, REMOVE_PATTERN, "allCommands");
    }

    private String getConsoleInput() throws IOException {
        if (this.mConsoleReader != null) {
            if (sConsoleStream != null) {
                sConsoleStream.setAsyncMode();
            }
            String input = this.mConsoleReader.readLine(this.getConsolePrompt());
            if (sConsoleStream != null) {
                sConsoleStream.setSyncMode();
            }
            return input;
        }
        return null;
    }

    protected String getConsolePrompt() {
        return CONSOLE_PROMPT;
    }

    protected void printLine(String output) {
        System.out.print(output);
        System.out.println();
    }

    void executeCmdRunnable(Runnable command, CaptureList groups) {
        if (command instanceof ArgRunnable) {
            ((ArgRunnable)command).run(groups);
        } else {
            command.run();
        }
    }

    boolean isConsoleFunctional() {
        return System.console() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<String> arrrgs = Arrays.asList(this.mMainArgs);
        try {
            if (!this.isConsoleFunctional()) {
                if (arrrgs.isEmpty()) {
                    this.printLine("No commands for non-interactive mode; exiting.");
                    this.mScheduler.start();
                    this.mScheduler.await();
                    return;
                }
                this.printLine("Non-interactive mode: Running initial command then exiting.");
                this.mShouldExit = true;
            }
            this.mScheduler.start();
            this.mScheduler.await();
            String input = "";
            CaptureList groups = new CaptureList();
            do {
                Runnable command;
                String[] tokens;
                if (arrrgs.isEmpty()) {
                    input = this.getConsoleInput();
                    if (input == null) {
                        this.printLine("");
                        this.printLine("Received EOF; quitting...");
                        this.mShouldExit = true;
                        break;
                    }
                    tokens = null;
                    try {
                        tokens = QuotationAwareTokenizer.tokenizeLine(input);
                    }
                    catch (IllegalArgumentException e) {
                        this.printLine(String.format("Invalid input: %s.", input));
                        continue;
                    }
                    if (tokens == null || tokens.length == 0) {
                        continue;
                    }
                } else {
                    this.printLine(String.format("Using commandline arguments as starting command: %s", arrrgs));
                    if (this.mConsoleReader != null) {
                        String cmd = ArrayUtil.join(" ", arrrgs);
                        this.mConsoleReader.getHistory().addToHistory(cmd);
                    }
                    tokens = arrrgs.toArray(new String[0]);
                    arrrgs = Collections.emptyList();
                }
                if ((command = this.mCommandTrie.retrieve(groups, tokens)) != null) {
                    this.executeCmdRunnable(command, groups);
                } else {
                    this.printLine(String.format("Unable to handle command '%s'.  Enter 'help' for help.", tokens[0]));
                }
                RunUtil.getDefault().sleep(100L);
            } while (!this.mShouldExit);
        }
        catch (Exception e) {
            this.printLine("Console received an unexpected exception (shown below); shutting down TF.");
            e.printStackTrace();
        }
        finally {
            this.mScheduler.shutdown();
            System.err.flush();
            System.out.flush();
        }
    }

    void awaitScheduler() throws InterruptedException {
        this.mScheduler.await();
    }

    CommandFileParser createCommandFileParser() {
        return new CommandFileParser();
    }

    IConfigurationFactory getConfigurationFactory() {
        return ConfigurationFactory.getInstance();
    }

    private void dumpStacks() {
        Map<Thread, StackTraceElement[]> threadMap = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> threadEntry : threadMap.entrySet()) {
            this.dumpThreadStack(threadEntry.getKey(), threadEntry.getValue());
        }
    }

    private void dumpThreadStack(Thread thread, StackTraceElement[] trace) {
        this.printLine(String.format("%s", thread));
        for (int i = 0; i < trace.length; ++i) {
            this.printLine(String.format("\t%s", trace[i]));
        }
        this.printLine("");
    }

    private void dumpLogs() {
        LogRegistry.getLogRegistry().dumpLogs();
    }

    private void startRemoteManager() {
        int port = this.mScheduler.startRemoteManager();
        if (port != -1) {
            this.printLine(String.format("Started remote manager on port %d.", port));
            this.printLine(String.format("Provide this port to other tradefed host via 'exit --handover-port %d' to initiate handover.", port));
        } else {
            this.printLine("Failed to start remote manager to handle handover");
        }
    }

    public void setArgs(String[] mainArgs) {
        this.mMainArgs = mainArgs;
    }

    public static void main(String[] mainArgs) throws InterruptedException {
        Console console = new Console();
        Console.startConsole(console, mainArgs);
    }

    public static void startConsole(Console console, String[] args) throws InterruptedException {
        console.setArgs(args);
        console.setDaemon(true);
        console.start();
        console.awaitScheduler();
    }

    private class ForceQuitRunnable
    extends QuitRunnable {
        private ForceQuitRunnable() {
        }

        public void run(CaptureList args) {
            super.run(args);
            Console.this.mScheduler.shutdownHard();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QuitRunnable
    extends ArgRunnable<CaptureList> {
        @Option(name="handover-port", description="Used to indicate that currently managed devices should be 'handed over' to new tradefed process, which is listening on specified port")
        private Integer mHandoverPort = null;

        private QuitRunnable() {
        }

        @Override
        public void run(CaptureList args) {
            try {
                if (args.size() >= 2 && !((List)args.get(1)).isEmpty()) {
                    List<String> optionArgs = Console.getFlatArgs(1, args);
                    ArgsOptionParser parser = new ArgsOptionParser(this);
                    parser.parse(optionArgs);
                }
                if (this.mHandoverPort == null) {
                    Console.this.mScheduler.shutdown();
                } else if (!Console.this.mScheduler.handoverShutdown(this.mHandoverPort)) {
                    return;
                }
                Console.this.printLine("Signalling command scheduler for shutdown.");
                Console.this.printLine("TF will exit without warning when remaining invocations complete.");
            }
            catch (ConfigurationException e) {
                Console.this.printLine(e.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ArgRunnable<T>
    implements Runnable {
        protected ArgRunnable() {
        }

        @Override
        public void run() {
            this.run(null);
        }

        public abstract void run(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CaptureList
    extends LinkedList<List<String>> {
        CaptureList() {
        }

        CaptureList(Collection<? extends List<String>> c) {
            super(c);
        }
    }
}

