/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.tradefed.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class RemoteClient {
    private final Socket mSocket;
    private final PrintWriter mWriter;
    private final BufferedReader mReader;

    RemoteClient(int port) throws UnknownHostException, IOException {
        String hostName = InetAddress.getLocalHost().getHostName();
        this.mSocket = new Socket(hostName, port);
        this.mWriter = new PrintWriter(this.mSocket.getOutputStream(), true);
        this.mReader = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream()));
    }

    private synchronized boolean sendCommand(String ... cmd) throws IOException {
        this.mWriter.println(ArrayUtil.join(";", cmd));
        String response = this.mReader.readLine();
        return response != null && Boolean.parseBoolean(response);
    }

    public static RemoteClient connect(int port) throws UnknownHostException, IOException {
        return new RemoteClient(port);
    }

    public boolean sendFilterDevice(String serial) throws IOException {
        return this.sendCommand("filter", serial);
    }

    public boolean sendUnfilterDevice(String serial) throws IOException {
        return this.sendCommand("unfilter", serial);
    }

    public boolean sendUnfilterAll() throws IOException {
        return this.sendCommand("unfilter", "*");
    }

    public boolean sendAddCommand(long totalTime, String ... commandArgs) throws IOException {
        String[] fullList = ArrayUtil.buildArray({"add_command", Long.toString(totalTime)}, commandArgs);
        return this.sendCommand(fullList);
    }

    public boolean sendClose() throws IOException {
        return this.sendCommand("close");
    }

    public synchronized void close() {
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mWriter != null) {
            this.mWriter.close();
        }
    }
}

