/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.Log;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;

public class RemoteManager
extends Thread {
    static final String DELIM = ";";
    static final String FILTER = "filter";
    static final String UNFILTER = "unfilter";
    static final String ALL_DEVICES = "*";
    static final String CLOSE = "close";
    static final String ADD_COMMAND = "add_command";
    private ServerSocket mServerSocket = null;
    private boolean mCancel = false;
    private final IDeviceManager mDeviceManager;
    private final ICommandScheduler mScheduler;
    private Map<String, ITestDevice> mFilteredDeviceMap = new Hashtable<String, ITestDevice>();

    public RemoteManager(IDeviceManager manager, ICommandScheduler scheduler) {
        this.mDeviceManager = manager;
        this.mScheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RemoteManager remoteManager = this;
        synchronized (remoteManager) {
            try {
                this.mServerSocket = new ServerSocket(0);
            }
            catch (IOException e) {
                LogUtil.CLog.e("Failed to open server socket: %s", e);
                return;
            }
            finally {
                this.notifyAll();
            }
        }
        try {
            this.processClientConnections(this.mServerSocket);
        }
        finally {
            this.freeAllDevices();
            this.closeSocket(this.mServerSocket);
        }
    }

    public synchronized int getPort() {
        if (this.mServerSocket == null) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.mServerSocket == null) {
            return -1;
        }
        return this.mServerSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClientConnections(ServerSocket serverSocket) {
        while (!this.mCancel) {
            Socket clientSocket = null;
            BufferedReader in = null;
            PrintWriter out = null;
            try {
                clientSocket = serverSocket.accept();
                in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                out = new PrintWriter(clientSocket.getOutputStream(), true);
                this.processClientCommands(in, out);
                this.closeReader(in);
                this.closeWriter(out);
                this.closeSocket(clientSocket);
            }
            catch (IOException e) {
                try {
                    LogUtil.CLog.e("Failed to accept connection: %s", e);
                    this.closeReader(in);
                    this.closeWriter(out);
                    this.closeSocket(clientSocket);
                }
                catch (Throwable throwable) {
                    this.closeReader(in);
                    this.closeWriter(out);
                    this.closeSocket(clientSocket);
                    throw throwable;
                }
            }
        }
    }

    private void processClientCommands(BufferedReader in, PrintWriter out) throws IOException {
        String line = null;
        while ((line = in.readLine()) != null && !this.mCancel) {
            boolean result = false;
            String[] commandSegments = line.split(DELIM);
            String cmdType = commandSegments[0];
            if (FILTER.equals(cmdType)) {
                result = this.processFilterCommand(commandSegments);
            } else if (UNFILTER.equals(cmdType)) {
                result = this.processUnfilterCommand(commandSegments);
            } else if (CLOSE.equals(cmdType)) {
                this.cancel();
                result = true;
            } else if (ADD_COMMAND.equals(cmdType)) {
                result = this.processAddCommand(commandSegments);
            }
            this.sendAck(result, out);
        }
    }

    private boolean processFilterCommand(String[] commandSegments) {
        if (commandSegments.length < 2) {
            LogUtil.CLog.e("Invalid command received: %s", ArrayUtil.join(" ", commandSegments));
            return false;
        }
        String serial = commandSegments[1];
        ITestDevice allocatedDevice = this.mDeviceManager.forceAllocateDevice(serial);
        if (allocatedDevice != null) {
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"RemoteManager", (String)String.format("Allocating device %s that is still in use by remote tradefed", serial));
            this.mFilteredDeviceMap.put(serial, allocatedDevice);
            return true;
        }
        LogUtil.CLog.e("Failed to allocate remote device %s", serial);
        return false;
    }

    private boolean processUnfilterCommand(String[] commandSegments) {
        if (commandSegments.length < 2) {
            LogUtil.CLog.e("Invalid command received: %s", ArrayUtil.join(" ", commandSegments));
            return false;
        }
        String serial = commandSegments[1];
        if (ALL_DEVICES.equals(serial)) {
            this.freeAllDevices();
            return true;
        }
        ITestDevice d = this.mFilteredDeviceMap.remove(serial);
        if (d != null) {
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"RemoteManager", (String)String.format("Freeing device %s no longer in use by remote tradefed", serial));
            this.mDeviceManager.freeDevice(d, IDeviceManager.FreeDeviceState.AVAILABLE);
            return true;
        }
        LogUtil.CLog.w("Could not find device to free %s", serial);
        return false;
    }

    private boolean processAddCommand(String[] commandSegments) {
        if (commandSegments.length < 3) {
            LogUtil.CLog.e("Invalid command received: %s", ArrayUtil.join(" ", commandSegments));
            return false;
        }
        long totalTime = Long.parseLong(commandSegments[1]);
        String[] cmdArgs = Arrays.copyOfRange(commandSegments, 2, commandSegments.length);
        Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"RemoteManager", (String)String.format("Adding command '%s'", ArrayUtil.join(" ", cmdArgs)));
        return this.mScheduler.addCommand(cmdArgs, null, totalTime);
    }

    private void freeAllDevices() {
        for (ITestDevice d : this.mFilteredDeviceMap.values()) {
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"RemoteManager", (String)String.format("Freeing device %s no longer in use by remote tradefed", d.getSerialNumber()));
            this.mDeviceManager.freeDevice(d, IDeviceManager.FreeDeviceState.AVAILABLE);
        }
        this.mFilteredDeviceMap.clear();
    }

    private void sendAck(boolean result, PrintWriter out) {
        out.println(result);
    }

    public synchronized void cancel() {
        if (!this.mCancel) {
            this.mCancel = true;
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"RemoteManager", (String)"Closing remote manager");
        }
    }

    private void closeSocket(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeSocket(Socket clientSocket) {
        if (clientSocket != null) {
            try {
                clientSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void closeReader(BufferedReader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeWriter(PrintWriter out) {
        if (out != null) {
            out.close();
        }
    }

    public boolean isCanceled() {
        return this.mCancel;
    }
}

