/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.ddmlib.Log;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.util.ArrayUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsOptionParser
extends OptionSetter {
    private static final String LOG_TAG = "ArgsOptionParser";
    static final String SHORT_NAME_PREFIX = "-";
    static final String OPTION_NAME_PREFIX = "--";
    private static final int OPTION_DESCRIPTION_INDENT = 25;

    public ArgsOptionParser(Collection<Object> optionSources) throws ConfigurationException {
        super(optionSources);
    }

    public ArgsOptionParser(Object ... optionSources) throws ConfigurationException {
        super(optionSources);
    }

    public List<String> parse(String ... args) throws ConfigurationException {
        return this.parse(Arrays.asList(args));
    }

    public List<String> parse(List<String> args) throws ConfigurationException {
        return this.parseOptions(args.listIterator());
    }

    private List<String> parseOptions(ListIterator<String> args) throws ConfigurationException {
        ArrayList<String> missingOptions;
        String arg;
        ArrayList<String> leftovers = new ArrayList<String>();
        while (args.hasNext() && !(arg = args.next()).equals(OPTION_NAME_PREFIX)) {
            if (arg.startsWith(OPTION_NAME_PREFIX)) {
                this.parseLongOption(arg, args);
                continue;
            }
            if (arg.startsWith(SHORT_NAME_PREFIX)) {
                this.parseGroupedShortOptions(arg, args);
                continue;
            }
            leftovers.add(arg);
            break;
        }
        if (!(missingOptions = new ArrayList<String>(this.getUnsetMandatoryOptions())).isEmpty()) {
            throw new ConfigurationException(String.format("Found missing mandatory options: %s", ArrayUtil.join(", ", missingOptions)));
        }
        while (args.hasNext()) {
            leftovers.add(args.next());
        }
        return leftovers;
    }

    private void parseLongOption(String arg, ListIterator<String> args) throws ConfigurationException {
        String name = arg.replaceFirst("^--", "");
        String key = null;
        String value = null;
        int equalsIndex = name.indexOf(61);
        if (equalsIndex != -1) {
            value = name.substring(equalsIndex + 1);
            name = name.substring(0, equalsIndex);
        }
        if (value == null) {
            if (this.isBooleanOption(name)) {
                value = name.startsWith("no-") ? "false" : "true";
            } else if (this.isMapOption(name)) {
                key = this.grabNextValue(args, name, "for its key");
                value = this.grabNextValue(args, name, "for its value");
            } else {
                value = this.grabNextValue(args, name);
            }
        }
        if (this.isMapOption(name)) {
            this.setOptionMapValue(name, key, value);
        } else {
            this.setOptionValue(name, value);
        }
    }

    private void parseGroupedShortOptions(String arg, ListIterator<String> args) throws ConfigurationException {
        for (int i = 1; i < arg.length(); ++i) {
            String value;
            String name = String.valueOf(arg.charAt(i));
            if (this.isBooleanOption(name)) {
                value = "true";
            } else if (i + 1 < arg.length()) {
                value = arg.substring(i + 1);
                i = arg.length() - 1;
            } else {
                value = this.grabNextValue(args, name);
            }
            this.setOptionValue(name, value);
        }
    }

    private String grabNextValue(ListIterator<String> args, String name) throws ConfigurationException {
        return this.grabNextValue(args, name, "");
    }

    private String grabNextValue(ListIterator<String> args, String name, String detail) throws ConfigurationException {
        if (!args.hasNext()) {
            String type = this.getTypeForOption(name);
            throw new ConfigurationException(String.format("option '%s' requires a '%s' argument%s", name, type, detail));
        }
        return args.next();
    }

    public static String getOptionHelp(boolean importantOnly, Object optionObject) {
        StringBuilder out = new StringBuilder();
        Collection<Field> optionFields = OptionSetter.getOptionFieldsForClass(optionObject.getClass());
        String eol = System.getProperty("line.separator");
        for (Field field : optionFields) {
            Option option = field.getAnnotation(Option.class);
            String defaultValue = OptionSetter.getFieldValueAsString(field, optionObject);
            String optionNameHelp = ArgsOptionParser.buildOptionNameHelp(field, option);
            if (!ArgsOptionParser.shouldOutputHelpForOption(importantOnly, option, defaultValue)) continue;
            out.append(optionNameHelp);
            int wsChars = 0;
            if (optionNameHelp.length() >= 25) {
                out.append(eol);
                wsChars = 25;
            } else {
                wsChars = 25 - optionNameHelp.length();
            }
            for (int i = 0; i < wsChars; ++i) {
                out.append(' ');
            }
            out.append(option.description());
            out.append(ArgsOptionParser.getDefaultValueHelp(defaultValue));
            out.append(OptionSetter.getEnumFieldValuesAsString(field));
            out.append(eol);
        }
        return out.toString();
    }

    private static boolean shouldOutputHelpForOption(boolean importantOnly, Option option, String defaultValue) {
        if (!importantOnly) {
            return true;
        }
        switch (option.importance()) {
            case NEVER: {
                return false;
            }
            case IF_UNSET: {
                return defaultValue == null;
            }
            case ALWAYS: {
                return true;
            }
        }
        Log.e((String)LOG_TAG, (String)String.format("Unrecognized importance setting '%s'", option.importance().toString()));
        return false;
    }

    private static String buildOptionNameHelp(Field field, Option option) {
        StringBuilder optionNameBuilder = new StringBuilder();
        optionNameBuilder.append("    ");
        if (option.shortName() != '0') {
            optionNameBuilder.append(SHORT_NAME_PREFIX);
            optionNameBuilder.append(option.shortName());
            optionNameBuilder.append(", ");
        }
        optionNameBuilder.append(OPTION_NAME_PREFIX);
        try {
            if (OptionSetter.isBooleanField(field)) {
                optionNameBuilder.append("[no-]");
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        optionNameBuilder.append(option.name());
        return optionNameBuilder.toString();
    }

    private static String getDefaultValueHelp(String defaultValue) {
        if (defaultValue == null) {
            return "";
        }
        return String.format(" Default: %s.", defaultValue);
    }
}

