/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.command.CommandOptions;
import com.android.tradefed.command.ICommandOptions;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.WaitDeviceRecovery;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.StdoutLogger;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TextResultReporter;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.StubTargetPreparer;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.StubTest;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements IConfiguration {
    public static final String BUILD_PROVIDER_TYPE_NAME = "build_provider";
    public static final String TARGET_PREPARER_TYPE_NAME = "target_preparer";
    public static final String TEST_TYPE_NAME = "test";
    public static final String DEVICE_RECOVERY_TYPE_NAME = "device_recovery";
    public static final String LOGGER_TYPE_NAME = "logger";
    public static final String RESULT_REPORTER_TYPE_NAME = "result_reporter";
    public static final String CMD_OPTIONS_TYPE_NAME = "cmd_options";
    public static final String DEVICE_REQUIREMENTS_TYPE_NAME = "device_requirements";
    public static final String DEVICE_OPTIONS_TYPE_NAME = "device_options";
    private static Map<String, ObjTypeInfo> sObjTypeMap = null;
    private Map<String, List<Object>> mConfigMap;
    private final String mName;
    private final String mDescription;

    static boolean isBuiltInObjType(String typeName) {
        return Configuration.getObjTypeMap().containsKey(typeName);
    }

    private static synchronized Map<String, ObjTypeInfo> getObjTypeMap() {
        if (sObjTypeMap == null) {
            sObjTypeMap = new HashMap<String, ObjTypeInfo>();
            sObjTypeMap.put(BUILD_PROVIDER_TYPE_NAME, new ObjTypeInfo(IBuildProvider.class, false));
            sObjTypeMap.put(TARGET_PREPARER_TYPE_NAME, new ObjTypeInfo(ITargetPreparer.class, true));
            sObjTypeMap.put(TEST_TYPE_NAME, new ObjTypeInfo(IRemoteTest.class, true));
            sObjTypeMap.put(DEVICE_RECOVERY_TYPE_NAME, new ObjTypeInfo(IDeviceRecovery.class, false));
            sObjTypeMap.put(LOGGER_TYPE_NAME, new ObjTypeInfo(ILeveledLogOutput.class, false));
            sObjTypeMap.put(RESULT_REPORTER_TYPE_NAME, new ObjTypeInfo(ITestInvocationListener.class, true));
            sObjTypeMap.put(CMD_OPTIONS_TYPE_NAME, new ObjTypeInfo(ICommandOptions.class, false));
            sObjTypeMap.put(DEVICE_REQUIREMENTS_TYPE_NAME, new ObjTypeInfo(IDeviceSelection.class, false));
            sObjTypeMap.put(DEVICE_OPTIONS_TYPE_NAME, new ObjTypeInfo(TestDeviceOptions.class, false));
        }
        return sObjTypeMap;
    }

    public Configuration(String name, String description) {
        this.mName = name;
        this.mDescription = description;
        this.mConfigMap = new LinkedHashMap<String, List<Object>>();
        this.setCommandOptions(new CommandOptions());
        this.setDeviceRequirements(new DeviceSelectionOptions());
        this.setDeviceOptions(new TestDeviceOptions());
        this.setBuildProvider(new StubBuildProvider());
        this.setTargetPreparer(new StubTargetPreparer());
        this.setTest(new StubTest());
        this.setDeviceRecovery(new WaitDeviceRecovery());
        this.setLogOutput(new StdoutLogger());
        this.setTestInvocationListener(new TextResultReporter());
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public IBuildProvider getBuildProvider() {
        return (IBuildProvider)this.getConfigurationObject(BUILD_PROVIDER_TYPE_NAME);
    }

    @Override
    public List<ITargetPreparer> getTargetPreparers() {
        return this.getConfigurationObjectList(TARGET_PREPARER_TYPE_NAME);
    }

    @Override
    public List<IRemoteTest> getTests() {
        return this.getConfigurationObjectList(TEST_TYPE_NAME);
    }

    @Override
    public IDeviceRecovery getDeviceRecovery() {
        return (IDeviceRecovery)this.getConfigurationObject(DEVICE_RECOVERY_TYPE_NAME);
    }

    @Override
    public ILeveledLogOutput getLogOutput() {
        return (ILeveledLogOutput)this.getConfigurationObject(LOGGER_TYPE_NAME);
    }

    @Override
    public List<ITestInvocationListener> getTestInvocationListeners() {
        return this.getConfigurationObjectList(RESULT_REPORTER_TYPE_NAME);
    }

    @Override
    public ICommandOptions getCommandOptions() {
        return (ICommandOptions)this.getConfigurationObject(CMD_OPTIONS_TYPE_NAME);
    }

    @Override
    public IDeviceSelection getDeviceRequirements() {
        return (IDeviceSelection)this.getConfigurationObject(DEVICE_REQUIREMENTS_TYPE_NAME);
    }

    @Override
    public TestDeviceOptions getDeviceOptions() {
        return (TestDeviceOptions)this.getConfigurationObject(DEVICE_OPTIONS_TYPE_NAME);
    }

    @Override
    public List<?> getConfigurationObjectList(String typeName) {
        return this.mConfigMap.get(typeName);
    }

    @Override
    public Object getConfigurationObject(String typeName) {
        List<?> configObjects = this.getConfigurationObjectList(typeName);
        if (configObjects == null) {
            return null;
        }
        ObjTypeInfo typeInfo = Configuration.getObjTypeMap().get(typeName);
        if (typeInfo != null && typeInfo.mIsListSupported) {
            throw new IllegalStateException(String.format("Wrong method call. Used getConfigurationObject() for a config object that is stored as a list", typeName));
        }
        if (configObjects.size() != 1) {
            throw new IllegalStateException(String.format("Attempted to retrieve single object for %s, but %d are present", typeName, configObjects.size()));
        }
        return configObjects.get(0);
    }

    private Collection<Object> getAllConfigurationObjects() {
        ArrayList<Object> objectsCopy = new ArrayList<Object>();
        for (List<Object> objectList : this.mConfigMap.values()) {
            objectsCopy.addAll(objectList);
        }
        return objectsCopy;
    }

    @Override
    public void injectOptionValue(String optionName, String optionValue) throws ConfigurationException {
        OptionSetter optionSetter = new OptionSetter(this.getAllConfigurationObjects());
        optionSetter.setOptionValue(optionName, optionValue);
    }

    @Override
    public void injectOptionValue(String optionName, String optionKey, String optionValue) throws ConfigurationException {
        OptionSetter optionSetter = new OptionSetter(this.getAllConfigurationObjects());
        optionSetter.setOptionMapValue(optionName, optionKey, optionValue);
    }

    @Override
    public Configuration clone() {
        Configuration clone = new Configuration(this.getName(), this.getDescription());
        for (Map.Entry<String, List<Object>> entry : this.mConfigMap.entrySet()) {
            clone.setConfigurationObjectListNoThrow(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    @Override
    public void setBuildProvider(IBuildProvider provider) {
        this.setConfigurationObjectNoThrow(BUILD_PROVIDER_TYPE_NAME, provider);
    }

    @Override
    public void setTestInvocationListeners(List<ITestInvocationListener> listeners) {
        this.setConfigurationObjectListNoThrow(RESULT_REPORTER_TYPE_NAME, listeners);
    }

    @Override
    public void setTestInvocationListener(ITestInvocationListener listener) {
        this.setConfigurationObjectNoThrow(RESULT_REPORTER_TYPE_NAME, listener);
    }

    @Override
    public void setTest(IRemoteTest test) {
        this.setConfigurationObjectNoThrow(TEST_TYPE_NAME, test);
    }

    @Override
    public void setTests(List<IRemoteTest> tests) {
        this.setConfigurationObjectListNoThrow(TEST_TYPE_NAME, tests);
    }

    @Override
    public void setLogOutput(ILeveledLogOutput logger) {
        this.setConfigurationObjectNoThrow(LOGGER_TYPE_NAME, logger);
    }

    @Override
    public void setDeviceRecovery(IDeviceRecovery recovery) {
        this.setConfigurationObjectNoThrow(DEVICE_RECOVERY_TYPE_NAME, recovery);
    }

    @Override
    public void setTargetPreparer(ITargetPreparer preparer) {
        this.setConfigurationObjectNoThrow(TARGET_PREPARER_TYPE_NAME, preparer);
    }

    @Override
    public void setCommandOptions(ICommandOptions cmdOptions) {
        this.setConfigurationObjectNoThrow(CMD_OPTIONS_TYPE_NAME, cmdOptions);
    }

    @Override
    public void setDeviceRequirements(IDeviceSelection devRequirements) {
        this.setConfigurationObjectNoThrow(DEVICE_REQUIREMENTS_TYPE_NAME, devRequirements);
    }

    @Override
    public void setDeviceOptions(TestDeviceOptions devOptions) {
        this.setConfigurationObjectNoThrow(DEVICE_OPTIONS_TYPE_NAME, devOptions);
    }

    @Override
    public void setConfigurationObject(String typeName, Object configObject) throws ConfigurationException {
        if (configObject == null) {
            throw new IllegalArgumentException("configObject cannot be null");
        }
        this.mConfigMap.remove(typeName);
        this.addObject(typeName, configObject);
    }

    @Override
    public void setConfigurationObjectList(String typeName, List<?> configList) throws ConfigurationException {
        if (configList == null) {
            throw new IllegalArgumentException("configList cannot be null");
        }
        this.mConfigMap.remove(typeName);
        for (Object configObject : configList) {
            this.addObject(typeName, configObject);
        }
    }

    private void addObject(String typeName, Object configObject) throws ConfigurationException {
        ObjTypeInfo typeInfo;
        List<Object> objList = this.mConfigMap.get(typeName);
        if (objList == null) {
            objList = new ArrayList<Object>(1);
            this.mConfigMap.put(typeName, objList);
        }
        if ((typeInfo = Configuration.getObjTypeMap().get(typeName)) != null && !typeInfo.mExpectedType.isInstance(configObject)) {
            throw new ConfigurationException(String.format("The config object %s is not the correct type. Expected %s, received %s", typeName, typeInfo.mExpectedType.getCanonicalName(), configObject.getClass().getCanonicalName()));
        }
        if (typeInfo != null && !typeInfo.mIsListSupported && objList.size() > 0) {
            throw new ConfigurationException(String.format("Only one config object allowed for %s, but multiple were specified.", typeName));
        }
        objList.add(configObject);
        if (configObject instanceof IConfigurationReceiver) {
            ((IConfigurationReceiver)configObject).setConfiguration(this);
        }
    }

    private void setConfigurationObjectNoThrow(String typeName, Object configObject) {
        try {
            this.setConfigurationObject(typeName, configObject);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void setConfigurationObjectListNoThrow(String typeName, List<?> configList) {
        try {
            this.setConfigurationObjectList(typeName, configList);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void setOptionsFromCommandLineArgs(List<String> listArgs) throws ConfigurationException {
        ArgsOptionParser parser = new ArgsOptionParser(this.getAllConfigurationObjects());
        List<String> unprocessedArgs = parser.parse(listArgs);
        if (unprocessedArgs.size() > 0) {
            throw new ConfigurationException(String.format("Invalid arguments provided. Unprocessed arguments: %s", unprocessedArgs));
        }
    }

    @Override
    public void printCommandUsage(boolean importantOnly, PrintStream out) throws ConfigurationException {
        out.println(String.format("'%s' configuration: %s", this.getName(), this.getDescription()));
        out.println();
        if (importantOnly) {
            out.println("Printing help for only the important options. To see help for all options, use the --help-all flag");
            out.println();
        }
        for (Map.Entry<String, List<Object>> configObjectsEntry : this.mConfigMap.entrySet()) {
            for (Object configObject : configObjectsEntry.getValue()) {
                String optionHelp = this.printOptionsForObject(importantOnly, configObjectsEntry.getKey(), configObject);
                if (optionHelp.length() <= 0) continue;
                String classAlias = "";
                if (configObject.getClass().isAnnotationPresent(OptionClass.class)) {
                    OptionClass classAnnotation = configObject.getClass().getAnnotation(OptionClass.class);
                    classAlias = String.format("'%s' ", classAnnotation.alias());
                }
                out.printf("  %s%s options:", classAlias, configObjectsEntry.getKey());
                out.println();
                out.print(optionHelp);
                out.println();
            }
        }
    }

    private String printOptionsForObject(boolean importantOnly, String objectTypeName, Object configObject) throws ConfigurationException {
        return ArgsOptionParser.getOptionHelp(importantOnly, configObject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjTypeInfo {
        final Class<?> mExpectedType;
        final boolean mIsListSupported;

        ObjTypeInfo(Class<?> expectedType, boolean isList) {
            this.mExpectedType = expectedType;
            this.mIsListSupported = isList;
        }
    }
}

