/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationDef {
    private final Map<String, List<String>> mObjectClassMap;
    private final List<OptionDef> mOptionList;
    private final Map<String, Integer> mClassFrequency;
    private final String mName;
    private String mDescription = "";

    public ConfigurationDef(String name) {
        this.mName = name;
        this.mObjectClassMap = new LinkedHashMap<String, List<String>>();
        this.mOptionList = new ArrayList<OptionDef>();
        this.mClassFrequency = new HashMap<String, Integer>();
    }

    public String getDescription() {
        return this.mDescription;
    }

    void setDescription(String description) {
        this.mDescription = description;
    }

    int addConfigObjectDef(String typeName, String className) {
        List<String> classList = this.mObjectClassMap.get(typeName);
        if (classList == null) {
            classList = new ArrayList<String>();
            this.mObjectClassMap.put(typeName, classList);
        }
        classList.add(className);
        Integer freq = this.mClassFrequency.get(className);
        freq = freq == null ? 1 : freq + 1;
        this.mClassFrequency.put(className, freq);
        return freq;
    }

    void addOptionDef(String optionName, String optionKey, String optionValue) {
        if (optionKey == null) {
            this.mOptionList.add(new OptionDef(optionName, optionValue));
        } else {
            this.mOptionList.add(new OptionDef(optionName, optionKey, optionValue));
        }
    }

    Map<String, List<String>> getObjectClassMap() {
        return this.mObjectClassMap;
    }

    List<OptionDef> getOptionList() {
        return this.mOptionList;
    }

    IConfiguration createConfiguration() throws ConfigurationException {
        Configuration config = new Configuration(this.getName(), this.getDescription());
        for (Map.Entry<String, List<String>> objClassEntry : this.mObjectClassMap.entrySet()) {
            ArrayList<Object> objectList = new ArrayList<Object>(objClassEntry.getValue().size());
            for (String className : objClassEntry.getValue()) {
                Object configObject = this.createObject(objClassEntry.getKey(), className);
                objectList.add(configObject);
            }
            config.setConfigurationObjectList(objClassEntry.getKey(), objectList);
        }
        for (OptionDef optionEntry : this.mOptionList) {
            if (optionEntry.key == null) {
                config.injectOptionValue(optionEntry.name, optionEntry.value);
                continue;
            }
            config.injectOptionValue(optionEntry.name, optionEntry.key, optionEntry.value);
        }
        return config;
    }

    public String getName() {
        return this.mName;
    }

    private Object createObject(String objectTypeName, String className) throws ConfigurationException {
        try {
            Class<?> objectClass = this.getClassForObject(objectTypeName, className);
            Object configObject = objectClass.newInstance();
            return configObject;
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(String.format("Could not instantiate class %s for config object type %s", className, objectTypeName), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("Could not access class %s for config object type %s", className, objectTypeName), e);
        }
    }

    private Class<?> getClassForObject(String objectTypeName, String className) throws ConfigurationException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(String.format("Could not find class %s for config object type %s", className, objectTypeName), e);
        }
    }

    void includeConfigDef(ConfigurationDef includedDef) {
        for (Map.Entry<String, List<String>> mapEntry : includedDef.getObjectClassMap().entrySet()) {
            for (String configClass : mapEntry.getValue()) {
                this.addConfigObjectDef(mapEntry.getKey(), configClass);
            }
        }
        this.mOptionList.addAll(includedDef.getOptionList());
    }

    static class OptionDef {
        final String name;
        final String key;
        final String value;

        OptionDef(String optionName, String optionValue) {
            this(optionName, null, optionValue);
        }

        OptionDef(String optionName, String optionKey, String optionValue) {
            this.name = optionName;
            this.key = optionKey;
            this.value = optionValue;
        }
    }
}

