/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionUpdateRule;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.ArrayUtil;
import com.google.common.base.Objects;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionSetter {
    static final String BOOL_FALSE_PREFIX = "no-";
    private static final HashMap<Class<?>, Handler> handlers = new HashMap();
    static final char NAMESPACE_SEPARATOR = ':';
    private final Collection<Object> mOptionSources;
    private final Map<String, OptionFieldsForName> mOptionMap;

    private static Handler getHandler(Type type) throws ConfigurationException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawClass = (Class)parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom(rawClass)) {
                Type actualType = parameterizedType.getActualTypeArguments()[0];
                if (!(actualType instanceof Class)) {
                    throw new ConfigurationException("cannot handle nested parameterized type " + type);
                }
                return OptionSetter.getHandler(actualType);
            }
            if (Map.class.isAssignableFrom(rawClass)) {
                Type keyType = parameterizedType.getActualTypeArguments()[0];
                Type valueType = parameterizedType.getActualTypeArguments()[1];
                if (!(keyType instanceof Class)) {
                    throw new ConfigurationException("cannot handle nested parameterized type " + keyType);
                }
                if (!(valueType instanceof Class)) {
                    throw new ConfigurationException("cannot handle nested parameterized type " + valueType);
                }
                return new MapHandler(OptionSetter.getHandler(keyType), OptionSetter.getHandler(valueType));
            }
            throw new ConfigurationException(String.format("can't handle parameterized type %s; only Collection and Map are supported", type));
        }
        if (type instanceof Class) {
            Class cType = (Class)type;
            if (cType.isEnum()) {
                return new EnumHandler(cType);
            }
            if (Collection.class.isAssignableFrom(cType)) {
                throw new ConfigurationException(String.format("Cannot handle non-parameterized collection %s.  Use a generic Collection to specify a desired element type.", type));
            }
            if (Map.class.isAssignableFrom(cType)) {
                throw new ConfigurationException(String.format("Cannot handle non-parameterized map %s.  Use a generic Map to specify desired element types.", type));
            }
            return handlers.get(cType);
        }
        throw new ConfigurationException(String.format("cannot handle unknown field type %s", type));
    }

    public OptionSetter(Object ... optionSources) throws ConfigurationException {
        this(Arrays.asList(optionSources));
    }

    public OptionSetter(Collection<Object> optionSources) throws ConfigurationException {
        this.mOptionSources = optionSources;
        this.mOptionMap = this.makeOptionMap();
    }

    private OptionFieldsForName fieldsForArg(String name) throws ConfigurationException {
        OptionFieldsForName fields = this.mOptionMap.get(name);
        if (fields == null || fields.size() == 0) {
            throw new ConfigurationException(String.format("Could not find option with name %s", name));
        }
        return fields;
    }

    public String getTypeForOption(String name) throws ConfigurationException {
        return this.fieldsForArg(name).getFirstField().getType().getSimpleName().toLowerCase();
    }

    public void setOptionValue(String optionName, String valueText) throws ConfigurationException {
        OptionFieldsForName optionFields = this.fieldsForArg(optionName);
        for (Map.Entry<Object, Field> fieldEntry : optionFields) {
            Object optionSource = fieldEntry.getKey();
            Field field = fieldEntry.getValue();
            Handler handler = OptionSetter.getHandler(field.getGenericType());
            Object value = handler.translate(valueText);
            if (value == null) {
                String type = field.getType().getSimpleName();
                throw new ConfigurationException(String.format("Couldn't convert '%s' to a %s for option '%s'", valueText, type, optionName));
            }
            OptionSetter.setFieldValue(optionName, optionSource, field, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void setFieldValue(String optionName, Object optionSource, Field field, Object value) throws ConfigurationException {
        try {
            field.setAccessible(true);
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection collection = (Collection)field.get(optionSource);
                if (collection == null) {
                    throw new ConfigurationException(String.format("internal error: no storage allocated for field '%s' (used for option '%s') in class '%s'", field.getName(), optionName, optionSource.getClass().getName()));
                }
                if (value instanceof Collection) {
                    collection.addAll((Collection)value);
                    return;
                } else {
                    collection.add(value);
                }
                return;
            } else if (Map.class.isAssignableFrom(field.getType())) {
                Map map = (Map)field.get(optionSource);
                if (map == null) {
                    throw new ConfigurationException(String.format("internal error: no storage allocated for field '%s' (used for option '%s') in class '%s'", field.getName(), optionName, optionSource.getClass().getName()));
                }
                if (!(value instanceof Map)) throw new ConfigurationException(String.format("internal error: value provided for field '%s' is not a map (used for option '%s') in class '%s'", field.getName(), optionName, optionSource.getClass().getName()));
                map.putAll((Map)value);
                return;
            } else {
                Option option = field.getAnnotation(Option.class);
                if (option == null) {
                    throw new ConfigurationException(String.format("internal error: @Option annotation for field %s in class %s was unexpectedly null", field.getName(), optionSource.getClass().getName()));
                }
                OptionUpdateRule rule = option.updateRule();
                field.set(optionSource, rule.update(optionName, optionSource, field, value));
            }
            return;
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("internal error when setting option '%s'", optionName), e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("internal error when setting option '%s'", optionName), e);
        }
    }

    public void setOptionMapValue(String optionName, String keyText, String valueText) throws ConfigurationException {
        OptionFieldsForName optionFields = this.fieldsForArg(optionName);
        for (Map.Entry<Object, Field> fieldEntry : optionFields) {
            Object optionSource = fieldEntry.getKey();
            Field field = fieldEntry.getValue();
            Handler handler = OptionSetter.getHandler(field.getGenericType());
            if (handler == null || !(handler instanceof MapHandler)) {
                throw new ConfigurationException("Not a map!");
            }
            MapEntry pair = null;
            try {
                pair = ((MapHandler)handler).translate(keyText, valueText);
                if (pair == null) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException e) {
                ParameterizedType pType = (ParameterizedType)field.getGenericType();
                Type keyType = pType.getActualTypeArguments()[0];
                Type valueType = pType.getActualTypeArguments()[1];
                String keyTypeName = ((Class)keyType).getSimpleName().toLowerCase();
                String valueTypeName = ((Class)valueType).getSimpleName().toLowerCase();
                String message = "";
                message = e.getMessage().contains("key") ? String.format("Couldn't convert '%s' to a %s for the key of mapoption '%s'", keyText, keyTypeName, optionName) : (e.getMessage().contains("value") ? String.format("Couldn't convert '%s' to a %s for the value of mapoption '%s'", valueText, valueTypeName, optionName) : String.format("Failed to convert key '%s' to type %s and/or value '%s' to type %s for mapoption '%s'", keyText, keyTypeName, valueText, valueTypeName, optionName));
                throw new ConfigurationException(message);
            }
            try {
                field.setAccessible(true);
                if (!Map.class.isAssignableFrom(field.getType())) {
                    throw new ConfigurationException(String.format("internal error: not a map field!", new Object[0]));
                }
                Map map = (Map)field.get(optionSource);
                if (map == null) {
                    throw new ConfigurationException(String.format("internal error: no storage allocated for field '%s' (used for option '%s') in class '%s'", field.getName(), optionName, optionSource.getClass().getName()));
                }
                map.put(pair.mKey, pair.mValue);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(String.format("internal error when setting option '%s'", optionName), e);
            }
        }
    }

    private Map<String, OptionFieldsForName> makeOptionMap() throws ConfigurationException {
        HashMap<String, Integer> freqMap = new HashMap<String, Integer>(this.mOptionSources.size());
        HashMap<String, OptionFieldsForName> optionMap = new HashMap<String, OptionFieldsForName>();
        for (Object objectSource : this.mOptionSources) {
            String className = objectSource.getClass().getName();
            Integer index = (Integer)freqMap.get(className);
            index = index == null ? 1 : index + 1;
            freqMap.put(className, index);
            this.addOptionsForObject(objectSource, optionMap, index);
        }
        return optionMap;
    }

    private void addOptionsForObject(Object optionSource, Map<String, OptionFieldsForName> optionMap, Integer index) throws ConfigurationException {
        Collection<Field> optionFields = OptionSetter.getOptionFieldsForClass(optionSource.getClass());
        for (Field field : optionFields) {
            Class cType;
            Option option = field.getAnnotation(Option.class);
            if (option.name().indexOf(58) != -1) {
                throw new ConfigurationException(String.format("Option name '%s' in class '%s' is invalid. Option names cannot contain the namespace separator character '%c'", option.name(), optionSource.getClass().getName(), Character.valueOf(':')));
            }
            Type type = field.getGenericType();
            if (!(!(type instanceof Class) || type instanceof ParameterizedType || option.updateRule() != OptionUpdateRule.GREATEST && option.updateRule() != OptionUpdateRule.LEAST || Comparable.class.isAssignableFrom(cType = (Class)type))) {
                throw new ConfigurationException(String.format("Option '%s' in class '%s' attempts to use updateRule %s with non-Comparable type '%s'.", new Object[]{option.name(), optionSource.getClass().getName(), option.updateRule(), field.getGenericType()}));
            }
            this.addNameToMap(optionMap, optionSource, option.name(), field);
            this.addNamespacedOptionToMap(optionMap, optionSource, option.name(), field, index);
            if (option.shortName() != '0') {
                this.addNameToMap(optionMap, optionSource, String.valueOf(option.shortName()), field);
                this.addNamespacedOptionToMap(optionMap, optionSource, String.valueOf(option.shortName()), field, index);
            }
            if (!OptionSetter.isBooleanField(field)) continue;
            this.addNameToMap(optionMap, optionSource, BOOL_FALSE_PREFIX + option.name(), field);
            this.addNamespacedOptionToMap(optionMap, optionSource, BOOL_FALSE_PREFIX + option.name(), field, index);
        }
    }

    protected Collection<String> getUnsetMandatoryOptions() throws ConfigurationException {
        HashSet<String> unsetOptions = new HashSet<String>();
        for (Map.Entry<String, OptionFieldsForName> optionPair : this.mOptionMap.entrySet()) {
            String optName = optionPair.getKey();
            OptionFieldsForName optionFields = optionPair.getValue();
            if (optName.indexOf(58) >= 0) continue;
            for (Map.Entry<Object, Field> fieldEntry : optionFields) {
                Map m;
                Object value;
                Object obj = fieldEntry.getKey();
                Field field = fieldEntry.getValue();
                Option option = field.getAnnotation(Option.class);
                if (option == null || !option.mandatory()) continue;
                field.setAccessible(true);
                try {
                    value = field.get(obj);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException(String.format("internal error: %s", e.getMessage()));
                }
                String realOptName = String.format("--%s", option.name());
                if (value == null) {
                    unsetOptions.add(realOptName);
                    continue;
                }
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    if (!c.isEmpty()) continue;
                    unsetOptions.add(realOptName);
                    continue;
                }
                if (!(value instanceof Map) || !(m = (Map)value).isEmpty()) continue;
                unsetOptions.add(realOptName);
            }
        }
        return unsetOptions;
    }

    static Collection<Field> getOptionFieldsForClass(Class<?> optionClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        OptionSetter.buildOptionFieldsForClass(optionClass, fieldList);
        return fieldList;
    }

    private static void buildOptionFieldsForClass(Class<?> optionClass, Collection<Field> optionFields) {
        for (Field field : optionClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Option.class)) continue;
            optionFields.add(field);
        }
        Class<?> superClass = optionClass.getSuperclass();
        if (superClass != null) {
            OptionSetter.buildOptionFieldsForClass(superClass, optionFields);
        }
    }

    static String getFieldValueAsString(Field field, Object optionObject) {
        Map map;
        Collection collection;
        Object fieldValue = OptionSetter.getFieldValue(field, optionObject);
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof Collection ? (collection = (Collection)fieldValue).isEmpty() : fieldValue instanceof Map && (map = (Map)fieldValue).isEmpty()) {
            return null;
        }
        return fieldValue.toString();
    }

    static Object getFieldValue(Field field, Object optionObject) {
        try {
            field.setAccessible(true);
            return field.get(optionObject);
        }
        catch (IllegalArgumentException e) {
            LogUtil.CLog.w("Could not read value for field %s in class %s. Reason: %s", field.getName(), optionObject.getClass().getName(), e);
            return null;
        }
        catch (IllegalAccessException e) {
            LogUtil.CLog.w("Could not read value for field %s in class %s. Reason: %s", field.getName(), optionObject.getClass().getName(), e);
            return null;
        }
    }

    static String getEnumFieldValuesAsString(Field field) {
        Class<?> type = field.getType();
        Object[] vals = type.getEnumConstants();
        if (vals == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" Valid values: [");
        sb.append(ArrayUtil.join(", ", vals));
        sb.append("]");
        return sb.toString();
    }

    public boolean isBooleanOption(String name) throws ConfigurationException {
        Field field = this.fieldsForArg(name).getFirstField();
        return OptionSetter.isBooleanField(field);
    }

    static boolean isBooleanField(Field field) throws ConfigurationException {
        return OptionSetter.getHandler(field.getGenericType()).isBoolean();
    }

    public boolean isMapOption(String name) throws ConfigurationException {
        Field field = this.fieldsForArg(name).getFirstField();
        return OptionSetter.isMapField(field);
    }

    static boolean isMapField(Field field) throws ConfigurationException {
        return OptionSetter.getHandler(field.getGenericType()).isMap();
    }

    private void addNameToMap(Map<String, OptionFieldsForName> optionMap, Object optionSource, String name, Field field) throws ConfigurationException {
        OptionFieldsForName fields = optionMap.get(name);
        if (fields == null) {
            fields = new OptionFieldsForName();
            optionMap.put(name, fields);
        }
        fields.addField(name, optionSource, field);
        if (OptionSetter.getHandler(field.getGenericType()) == null) {
            throw new ConfigurationException(String.format("Option name '%s' in class '%s' is invalid. Unsupported @Option field type '%s'", name, optionSource.getClass().getName(), field.getType()));
        }
    }

    private void addNamespacedOptionToMap(Map<String, OptionFieldsForName> optionMap, Object optionSource, String name, Field field, int index) throws ConfigurationException {
        String className = optionSource.getClass().getName();
        if (optionSource.getClass().isAnnotationPresent(OptionClass.class)) {
            OptionClass classAnnotation = optionSource.getClass().getAnnotation(OptionClass.class);
            this.addNameToMap(optionMap, optionSource, String.format("%s%c%s", classAnnotation.alias(), Character.valueOf(':'), name), field);
        }
        this.addNameToMap(optionMap, optionSource, String.format("%s%c%s", className, Character.valueOf(':'), name), field);
        this.addNameToMap(optionMap, optionSource, String.format("%s%c%d%c%s", className, Character.valueOf(':'), index, Character.valueOf(':'), name), field);
    }

    static {
        handlers.put(Boolean.TYPE, new BooleanHandler());
        handlers.put(Boolean.class, new BooleanHandler());
        handlers.put(Byte.TYPE, new ByteHandler());
        handlers.put(Byte.class, new ByteHandler());
        handlers.put(Short.TYPE, new ShortHandler());
        handlers.put(Short.class, new ShortHandler());
        handlers.put(Integer.TYPE, new IntegerHandler());
        handlers.put(Integer.class, new IntegerHandler());
        handlers.put(Long.TYPE, new LongHandler());
        handlers.put(Long.class, new LongHandler());
        handlers.put(Float.TYPE, new FloatHandler());
        handlers.put(Float.class, new FloatHandler());
        handlers.put(Double.TYPE, new DoubleHandler());
        handlers.put(Double.class, new DoubleHandler());
        handlers.put(String.class, new StringHandler());
        handlers.put(File.class, new FileHandler());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumHandler
    extends Handler {
        private final Class mEnumType;

        EnumHandler(Class<?> enumType) {
            this.mEnumType = enumType;
        }

        Class<?> getEnumType() {
            return this.mEnumType;
        }

        public int hashCode() {
            return Objects.hashCode(EnumHandler.class, this.mEnumType);
        }

        public boolean equals(Object otherObj) {
            if (otherObj != null && otherObj instanceof EnumHandler) {
                EnumHandler other = (EnumHandler)otherObj;
                Class<?> otherType = other.getEnumType();
                return this.mEnumType.isAssignableFrom(otherType) && otherType.isAssignableFrom(this.mEnumType);
            }
            return false;
        }

        @Override
        Object translate(String valueText) {
            return this.translate(valueText, true);
        }

        Object translate(String valueText, boolean shouldTryUpperCase) {
            try {
                return Enum.valueOf(this.mEnumType, valueText);
            }
            catch (IllegalArgumentException e) {
                if (shouldTryUpperCase) {
                    return this.translate(valueText.toUpperCase(Locale.ENGLISH), false);
                }
                return null;
            }
        }
    }

    private static class MapHandler
    extends Handler {
        private Handler mKeyHandler;
        private Handler mValueHandler;

        MapHandler(Handler keyHandler, Handler valueHandler) {
            if (keyHandler == null || valueHandler == null) {
                throw new NullPointerException();
            }
            this.mKeyHandler = keyHandler;
            this.mValueHandler = valueHandler;
        }

        Handler getKeyHandler() {
            return this.mKeyHandler;
        }

        Handler getValueHandler() {
            return this.mValueHandler;
        }

        boolean isMap() {
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(MapHandler.class, this.mKeyHandler, this.mValueHandler);
        }

        public boolean equals(Object otherObj) {
            if (otherObj != null && otherObj instanceof MapHandler) {
                MapHandler other = (MapHandler)otherObj;
                Handler otherKeyHandler = other.getKeyHandler();
                Handler otherValueHandler = other.getValueHandler();
                return this.mKeyHandler.equals(otherKeyHandler) && this.mValueHandler.equals(otherValueHandler);
            }
            return false;
        }

        Object translate(String valueText) {
            return null;
        }

        MapEntry translate(String keyText, String valueText) {
            Object key = this.mKeyHandler.translate(keyText);
            Object value = this.mValueHandler.translate(valueText);
            if (key == null) {
                throw new IllegalArgumentException("Failed to parse key");
            }
            if (value == null) {
                throw new IllegalArgumentException("Failed to parse value");
            }
            return new MapEntry(key, value);
        }
    }

    private static class MapEntry {
        public Object mKey = null;
        public Object mValue = null;

        MapEntry(Object key, Object value) {
            this.mKey = key;
            this.mValue = value;
        }
    }

    private static class FileHandler
    extends Handler {
        private FileHandler() {
        }

        Object translate(String valueText) {
            return new File(valueText);
        }
    }

    private static class StringHandler
    extends Handler {
        private StringHandler() {
        }

        Object translate(String valueText) {
            return valueText;
        }
    }

    private static class DoubleHandler
    extends Handler {
        private DoubleHandler() {
        }

        Object translate(String valueText) {
            try {
                return Double.parseDouble(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class FloatHandler
    extends Handler {
        private FloatHandler() {
        }

        Object translate(String valueText) {
            try {
                return Float.valueOf(Float.parseFloat(valueText));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class LongHandler
    extends Handler {
        private LongHandler() {
        }

        Object translate(String valueText) {
            try {
                return Long.parseLong(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class IntegerHandler
    extends Handler {
        private IntegerHandler() {
        }

        Object translate(String valueText) {
            try {
                return Integer.parseInt(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class ShortHandler
    extends Handler {
        private ShortHandler() {
        }

        Object translate(String valueText) {
            try {
                return Short.parseShort(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class ByteHandler
    extends Handler {
        private ByteHandler() {
        }

        Object translate(String valueText) {
            try {
                return Byte.parseByte(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class BooleanHandler
    extends Handler {
        private BooleanHandler() {
        }

        boolean isBoolean() {
            return true;
        }

        Object translate(String valueText) {
            if (valueText.equalsIgnoreCase("true") || valueText.equalsIgnoreCase("yes")) {
                return Boolean.TRUE;
            }
            if (valueText.equalsIgnoreCase("false") || valueText.equalsIgnoreCase("no")) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        boolean isBoolean() {
            return false;
        }

        boolean isMap() {
            return false;
        }

        abstract Object translate(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OptionFieldsForName
    implements Iterable<Map.Entry<Object, Field>> {
        private Map<Object, Field> mSourceFieldMap = new HashMap<Object, Field>();

        private OptionFieldsForName() {
        }

        void addField(String name, Object source, Field field) throws ConfigurationException {
            Handler newFieldHandler;
            Handler existingFieldHandler;
            if (this.size() > 0 && !(existingFieldHandler = OptionSetter.getHandler(this.getFirstField().getGenericType())).equals(newFieldHandler = OptionSetter.getHandler(field.getGenericType()))) {
                throw new ConfigurationException(String.format("@Option field with name '%s' in class '%s' is defined with a different type than same option in class '%s'", name, source.getClass().getName(), this.getFirstObject().getClass().getName()));
            }
            if (this.mSourceFieldMap.put(source, field) != null) {
                throw new ConfigurationException(String.format("@Option field with name '%s' is defined more than once in class '%s'", name, source.getClass().getName()));
            }
        }

        public int size() {
            return this.mSourceFieldMap.size();
        }

        public Field getFirstField() throws ConfigurationException {
            if (this.size() <= 0) {
                throw new ConfigurationException("no option fields found");
            }
            return this.mSourceFieldMap.values().iterator().next();
        }

        public Object getFirstObject() throws ConfigurationException {
            if (this.size() <= 0) {
                throw new ConfigurationException("no option fields found");
            }
            return this.mSourceFieldMap.keySet().iterator().next();
        }

        @Override
        public Iterator<Map.Entry<Object, Field>> iterator() {
            return this.mSourceFieldMap.entrySet().iterator();
        }
    }
}

