/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.log.LogUtil;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OptionUpdateRule {
    FIRST{

        Object update(String optionName, Object current, Object update) throws ConfigurationException {
            if (current == null) {
                return update;
            }
            LogUtil.CLog.d("Ignoring update for option %s", optionName);
            return current;
        }
    }
    ,
    LAST{

        Object update(String optionName, Object current, Object update) throws ConfigurationException {
            return update;
        }
    }
    ,
    GREATEST{

        Object update(String optionName, Object current, Object update) throws ConfigurationException {
            if (current == null) {
                return update;
            }
            if (OptionUpdateRule.compare(optionName, current, update) < 0) {
                return update;
            }
            return current;
        }
    }
    ,
    LEAST{

        Object update(String optionName, Object current, Object update) throws ConfigurationException {
            if (current == null) {
                return update;
            }
            if (OptionUpdateRule.compare(optionName, current, update) > 0) {
                return update;
            }
            return current;
        }
    }
    ,
    IMMUTABLE{

        Object update(String optionName, Object current, Object update) throws ConfigurationException {
            if (current == null) {
                return update;
            }
            throw new ConfigurationException(String.format("Attempted to update immutable value (%s) for option \"%s\"", optionName, optionName));
        }
    };


    abstract Object update(String var1, Object var2, Object var3) throws ConfigurationException;

    public Object update(String optionName, Object optionSource, Field field, Object update) throws ConfigurationException {
        Object current;
        try {
            current = field.get(optionSource);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("internal error when setting option '%s'", optionName), e);
        }
        return this.update(optionName, current, update);
    }

    private static int compare(String optionName, Object current, Object update) throws ConfigurationException {
        if (!(current instanceof Comparable)) {
            throw new ConfigurationException(String.format("internal error: Class %s for option %s was used with GREATEST or LEAST updateRule, but does not implement Comparable.", current.getClass().getSimpleName(), optionName));
        }
        Comparable compCurrent = (Comparable)current;
        try {
            return compCurrent.compareTo(update);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException(String.format("internal error: Failed to compare %s (%s) and %s (%s)", current.getClass().getName(), current, update.getClass().getName(), update), e);
        }
    }
}

