/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LargeOutputReceiver;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.IOException;

public class BackgroundDeviceAction
extends Thread {
    private IShellOutputReceiver mReceiver;
    private ITestDevice mTestDevice;
    private String mCommand;
    private String mSerialNumber;
    private String mDescriptor;
    private boolean mIsCancelled;
    private int mLogStartDelay;

    public BackgroundDeviceAction(String command, String descriptor, ITestDevice device, IShellOutputReceiver receiver, int startDelay) {
        this.mCommand = command;
        this.mDescriptor = descriptor;
        this.mSerialNumber = device.getSerialNumber();
        this.mTestDevice = device;
        this.mReceiver = receiver;
        this.mLogStartDelay = startDelay;
        this.setDaemon(true);
    }

    public void run() {
        while (!this.isCancelled()) {
            if (this.mLogStartDelay > 0) {
                LogUtil.CLog.d("Sleep for %d before starting %s for %s.", this.mLogStartDelay, this.mDescriptor, this.mSerialNumber);
                this.getRunUtil().sleep(this.mLogStartDelay);
            }
            LogUtil.CLog.d("Starting %s for %s.", this.mDescriptor, this.mSerialNumber);
            try {
                this.mTestDevice.getIDevice().executeShellCommand(this.mCommand, this.mReceiver, 0);
            }
            catch (TimeoutException e) {
                this.recoverDevice(((Object)((Object)e)).getClass().getName());
            }
            catch (AdbCommandRejectedException e) {
                this.recoverDevice(((Object)((Object)e)).getClass().getName());
            }
            catch (ShellCommandUnresponsiveException e) {
                this.recoverDevice(((Object)((Object)e)).getClass().getName());
            }
            catch (IOException e) {
                this.recoverDevice(e.getClass().getName());
            }
        }
    }

    private void recoverDevice(String exceptionType) {
        LogUtil.CLog.d("%s while running %s on %s. May see duplicated content in log.", exceptionType, this.mDescriptor, this.mSerialNumber);
        if (this.mReceiver instanceof LargeOutputReceiver) {
            ((LargeOutputReceiver)this.mReceiver).appendLogMsg(String.format("%s interrupted. May see duplicated content in log.", this.mDescriptor));
        }
        if (this.isCancelled()) {
            return;
        }
        this.getRunUtil().sleep(5000L);
        try {
            this.mTestDevice.waitForDeviceOnline(600000L);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.w("Device %s not online", this.mSerialNumber);
        }
    }

    public synchronized void cancel() {
        this.mIsCancelled = true;
        this.interrupt();
    }

    public synchronized boolean isCancelled() {
        return this.mIsCancelled;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }
}

