/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tradefed.device.AndroidDebugBridgeWrapper;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.DeviceStateMonitor;
import com.android.tradefed.device.IAndroidDebugBridge;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.TestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.WaitDeviceRecovery;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.ConditionPriorityBlockingQueue;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.TableFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManager
implements IDeviceManager {
    private static final long FASTBOOT_CMD_TIMEOUT = 60000L;
    private static final long FASTBOOT_POLL_WAIT_TIME = 5000L;
    private static final int CHECK_WAIT_DEVICE_AVAIL_MS = 30000;
    private static final IDeviceSelection ANY_DEVICE_OPTIONS = new DeviceSelectionOptions();
    private static DeviceManager sInstance;
    private boolean mIsInitialized = false;
    private Map<String, IManagedTestDevice> mAllocatedDeviceMap;
    private ConditionPriorityBlockingQueue<IDevice> mAvailableDeviceQueue;
    private IAndroidDebugBridge mAdbBridge;
    private ManagedDeviceListener mManagedDeviceListener;
    private boolean mFastbootEnabled;
    private Set<IDeviceManager.IFastbootListener> mFastbootListeners;
    private FastbootMonitor mFastbootMonitor;
    private Map<String, IDeviceStateMonitor> mCheckDeviceMap;
    private boolean mEnableLogcat = true;
    private boolean mIsTerminated = false;
    private IDeviceSelection mGlobalDeviceFilter;
    private int mNumEmulatorSupported = 1;
    private int mNumNullDevicesSupported = 1;
    private boolean mSynchronousMode = false;

    DeviceManager() {
    }

    @Override
    public void init() {
        this.init(ANY_DEVICE_OPTIONS);
    }

    @Override
    public synchronized void init(IDeviceSelection globalDeviceFilter) {
        if (this.mIsInitialized) {
            throw new IllegalStateException("already initialized");
        }
        this.mIsInitialized = true;
        this.mGlobalDeviceFilter = globalDeviceFilter;
        this.mAllocatedDeviceMap = new Hashtable<String, IManagedTestDevice>();
        this.mAvailableDeviceQueue = new ConditionPriorityBlockingQueue();
        this.mCheckDeviceMap = new Hashtable<String, IDeviceStateMonitor>();
        if (this.isFastbootAvailable()) {
            this.mFastbootListeners = Collections.synchronizedSet(new HashSet());
            this.mFastbootMonitor = new FastbootMonitor();
            this.startFastbootMonitor();
            this.mFastbootEnabled = true;
            this.addFastbootDevices();
        } else {
            LogUtil.CLog.w("Fastboot is not available.");
            this.mFastbootListeners = null;
            this.mFastbootMonitor = null;
            this.mFastbootEnabled = false;
        }
        DdmPreferences.setTimeOut((int)30000);
        this.mAdbBridge = this.createAdbBridge();
        this.mManagedDeviceListener = new ManagedDeviceListener();
        this.mAdbBridge.addDeviceChangeListener(this.mManagedDeviceListener);
        this.mAdbBridge.init(false, "adb");
        this.addEmulators();
        this.addNullDevices();
    }

    void setSynchronousMode(boolean syncMode) {
        this.mSynchronousMode = syncMode;
    }

    private void checkInit() {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("DeviceManager has not been initialized");
        }
    }

    private boolean isFastbootAvailable() {
        CommandResult fastbootResult = this.getRunUtil().runTimedCmdSilently(5000L, "fastboot", "help");
        if (fastbootResult.getStatus() == CommandStatus.SUCCESS) {
            return true;
        }
        if (fastbootResult.getStderr() != null && fastbootResult.getStderr().indexOf("usage: fastboot") >= 0) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.WARN, "You are running an older version of fastboot, please update it.", new Object[0]);
            return true;
        }
        return false;
    }

    void startFastbootMonitor() {
        this.mFastbootMonitor.start();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public void setEnableLogcat(boolean enableLogcat) {
        this.mEnableLogcat = enableLogcat;
    }

    private void checkAndAddAvailableDevice(final IDevice device) {
        if (this.mCheckDeviceMap.containsKey(device.getSerialNumber())) {
            LogUtil.CLog.d("Already checking new device %s, ignoring", device.getSerialNumber());
            return;
        }
        if (!this.mGlobalDeviceFilter.matches(device)) {
            LogUtil.CLog.v("New device %s doesn't match global filter, ignoring", device.getSerialNumber());
            return;
        }
        final IDeviceStateMonitor monitor = this.createStateMonitor(device);
        this.mCheckDeviceMap.put(device.getSerialNumber(), monitor);
        String threadName = String.format("Check device %s", device.getSerialNumber());
        Runnable checkRunnable = new Runnable(){

            public void run() {
                LogUtil.CLog.d("checking new device %s responsiveness", device.getSerialNumber());
                if (monitor.waitForDeviceShell(30000L)) {
                    LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Detected new device %s", device.getSerialNumber());
                    DeviceManager.this.addAvailableDevice(device);
                } else {
                    LogUtil.CLog.e("Device %s is not responsive to adb shell command , skip adding to available pool", device.getSerialNumber());
                }
                DeviceManager.this.mCheckDeviceMap.remove(device.getSerialNumber());
            }
        };
        if (this.mSynchronousMode) {
            checkRunnable.run();
        } else {
            Thread checkThread = new Thread(checkRunnable, threadName);
            checkThread.setDaemon(true);
            checkThread.start();
        }
    }

    private void addNullDevices() {
        for (int i = 0; i < this.mNumNullDevicesSupported; ++i) {
            this.addAvailableDevice(new NullDevice(String.format("null-device-%d", i)));
        }
    }

    private void addEmulators() {
        int port = 5554;
        for (int i = 0; i < this.mNumEmulatorSupported; ++i) {
            this.addAvailableDevice(new StubDevice(String.format("emulator-%d", port), true));
            port += 2;
        }
    }

    private void addFastbootDevices() {
        Set<String> serials = this.getDevicesOnFastboot();
        if (serials != null) {
            for (String serial : serials) {
                this.addAvailableDevice(new FastbootDevice(serial));
            }
        }
    }

    IDeviceStateMonitor createStateMonitor(IDevice device) {
        return new DeviceStateMonitor(this, device, this.mFastbootEnabled);
    }

    private void addAvailableDevice(final IDevice device) {
        ConditionPriorityBlockingQueue.IMatcher<IDevice> deviceSerialMatcher = new ConditionPriorityBlockingQueue.IMatcher<IDevice>(){

            @Override
            public boolean matches(IDevice element) {
                return element.getSerialNumber().equals(device.getSerialNumber());
            }
        };
        IDevice existingObject = this.mAvailableDeviceQueue.addUnique(deviceSerialMatcher, device);
        if (existingObject != null) {
            LogUtil.CLog.w("Found existing device for available device %s", device.getSerialNumber());
        }
    }

    ConditionPriorityBlockingQueue<IDevice> getAvailableDeviceQueue() {
        return this.mAvailableDeviceQueue;
    }

    public static synchronized IDeviceManager getInstance() {
        if (sInstance == null) {
            sInstance = new DeviceManager();
        }
        return sInstance;
    }

    @Override
    public ITestDevice allocateDevice() {
        this.checkInit();
        IDevice allocatedDevice = this.takeAvailableDevice();
        if (allocatedDevice == null) {
            return null;
        }
        return this.createAllocatedDevice(allocatedDevice);
    }

    @Override
    public ITestDevice forceAllocateDevice(String serial) {
        this.checkInit();
        if (this.mAllocatedDeviceMap.containsKey(serial)) {
            LogUtil.CLog.w("Device %s is already allocated", serial);
            return null;
        }
        DeviceSelectionOptions options = new DeviceSelectionOptions();
        options.addSerial(serial);
        IDevice allocatedDevice = this.pollAvailableDevice(1L, options);
        if (allocatedDevice == null) {
            allocatedDevice = new StubDevice(serial, false);
        }
        return this.createAllocatedDevice(allocatedDevice);
    }

    private IDevice takeAvailableDevice() {
        try {
            return this.mAvailableDeviceQueue.take(ANY_DEVICE_OPTIONS);
        }
        catch (InterruptedException e) {
            LogUtil.CLog.w("interrupted while taking device");
            return null;
        }
    }

    @Override
    public ITestDevice allocateDevice(long timeout) {
        this.checkInit();
        IDevice allocatedDevice = this.pollAvailableDevice(timeout, ANY_DEVICE_OPTIONS);
        if (allocatedDevice == null) {
            return null;
        }
        return this.createAllocatedDevice(allocatedDevice);
    }

    @Override
    public ITestDevice allocateDevice(long timeout, IDeviceSelection options) {
        this.checkInit();
        IDevice allocatedDevice = this.pollAvailableDevice(timeout, options);
        if (allocatedDevice == null) {
            return null;
        }
        return this.createAllocatedDevice(allocatedDevice);
    }

    private IDevice pollAvailableDevice(long timeout, IDeviceSelection options) {
        try {
            return this.mAvailableDeviceQueue.poll(timeout, TimeUnit.MILLISECONDS, options);
        }
        catch (InterruptedException e) {
            LogUtil.CLog.w("interrupted while polling for device");
            return null;
        }
    }

    private ITestDevice createAllocatedDevice(IDevice allocatedDevice) {
        IManagedTestDevice testDevice = this.createTestDevice(allocatedDevice, this.createStateMonitor(allocatedDevice));
        if (this.mEnableLogcat && !(allocatedDevice instanceof StubDevice)) {
            testDevice.startLogcat();
        }
        this.mAllocatedDeviceMap.put(allocatedDevice.getSerialNumber(), testDevice);
        LogUtil.CLog.i("Allocated device %s", testDevice.getSerialNumber());
        return testDevice;
    }

    IManagedTestDevice createTestDevice(IDevice allocatedDevice, IDeviceStateMonitor monitor) {
        TestDevice testDevice = new TestDevice(allocatedDevice, monitor);
        testDevice.setFastbootEnabled(this.mFastbootEnabled);
        if (allocatedDevice instanceof FastbootDevice) {
            testDevice.setDeviceState(TestDeviceState.FASTBOOT);
        } else if (allocatedDevice instanceof StubDevice) {
            testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
        }
        return testDevice;
    }

    synchronized IAndroidDebugBridge createAdbBridge() {
        return new AndroidDebugBridgeWrapper();
    }

    @Override
    public void freeDevice(ITestDevice device, IDeviceManager.FreeDeviceState deviceState) {
        this.checkInit();
        IManagedTestDevice managedDevice = (IManagedTestDevice)device;
        managedDevice.stopLogcat();
        IDevice ideviceToReturn = device.getIDevice();
        if (ideviceToReturn.isEmulator() && managedDevice.getEmulatorProcess() != null) {
            try {
                this.killEmulator(device);
                ideviceToReturn = new StubDevice(ideviceToReturn.getSerialNumber(), true);
                deviceState = IDeviceManager.FreeDeviceState.AVAILABLE;
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e(e);
                deviceState = IDeviceManager.FreeDeviceState.UNAVAILABLE;
            }
        }
        if (this.mAllocatedDeviceMap.remove(device.getSerialNumber()) == null) {
            LogUtil.CLog.e("freeDevice called with unallocated device %s", device.getSerialNumber());
        } else if (deviceState == IDeviceManager.FreeDeviceState.UNRESPONSIVE) {
            this.addAvailableDevice(ideviceToReturn);
        } else if (deviceState == IDeviceManager.FreeDeviceState.AVAILABLE) {
            this.addAvailableDevice(ideviceToReturn);
        } else if (deviceState == IDeviceManager.FreeDeviceState.UNAVAILABLE) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.WARN, "Freed device %s is unavailable. Removing from use.", device.getSerialNumber());
        }
    }

    @Override
    public void launchEmulator(ITestDevice device, long bootTimeout, IRunUtil runUtil, List<String> emulatorArgs) throws DeviceNotAvailableException {
        if (!device.getIDevice().isEmulator()) {
            throw new IllegalStateException(String.format("Device %s is not an emulator", device.getSerialNumber()));
        }
        if (!device.getDeviceState().equals((Object)TestDeviceState.NOT_AVAILABLE)) {
            throw new IllegalStateException(String.format("Emulator device %s is in state %s. Expected: %s", new Object[]{device.getSerialNumber(), device.getDeviceState(), TestDeviceState.NOT_AVAILABLE}));
        }
        Integer port = EmulatorConsole.getEmulatorPort((String)device.getSerialNumber());
        if (port == null) {
            throw new IllegalArgumentException(String.format("Failed to determine emulator port for %s", device.getSerialNumber()));
        }
        ArrayList<String> fullArgs = new ArrayList<String>(emulatorArgs);
        fullArgs.add("-port");
        fullArgs.add(port.toString());
        try {
            Process p = runUtil.runCmdInBackground(fullArgs);
            this.getRunUtil().sleep(500L);
            this.checkProcessDied(p);
            IManagedTestDevice managedDevice = (IManagedTestDevice)device;
            managedDevice.setEmulatorProcess(p);
            managedDevice.startLogcat();
        }
        catch (IOException e) {
            throw new DeviceNotAvailableException("Failed to start emulator process", e);
        }
        device.waitForDeviceAvailable(bootTimeout);
    }

    private void checkProcessDied(Process p) throws DeviceNotAvailableException {
        try {
            int exitValue = p.exitValue();
            LogUtil.CLog.e("Emulator process has died with exit value %d. stdout: '%s', stderr: '%s'", exitValue, StreamUtil.getStringFromStream(p.getInputStream()), StreamUtil.getStringFromStream(p.getErrorStream()));
        }
        catch (IllegalThreadStateException e) {
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new DeviceNotAvailableException("Emulator process has died unexpectedly");
    }

    @Override
    public void killEmulator(ITestDevice device) throws DeviceNotAvailableException {
        EmulatorConsole console = EmulatorConsole.getConsole((IDevice)device.getIDevice());
        if (console != null) {
            console.kill();
        } else {
            LogUtil.CLog.w("Could not get emulator console for %s", device.getSerialNumber());
        }
        Process emulatorProcess = ((IManagedTestDevice)device).getEmulatorProcess();
        if (emulatorProcess != null) {
            emulatorProcess.destroy();
        }
        if (!device.waitForDeviceNotAvailable(20000L)) {
            throw new DeviceNotAvailableException(String.format("Failed to kill emulator %s", device.getSerialNumber()));
        }
    }

    @Override
    public ITestDevice connectToTcpDevice(String ipAndPort) {
        if (this.mAllocatedDeviceMap.containsKey(ipAndPort)) {
            LogUtil.CLog.w("Device with tcp serial %s is already allocated", ipAndPort);
            return null;
        }
        ITestDevice tcpDevice = this.createAllocatedDevice(new StubDevice(ipAndPort));
        if (this.doAdbConnect(ipAndPort)) {
            try {
                tcpDevice.setRecovery(new WaitDeviceRecovery());
                tcpDevice.waitForDeviceOnline();
                return tcpDevice;
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.w("Device with tcp serial %s did not come online", ipAndPort);
            }
        }
        this.freeDevice(tcpDevice, IDeviceManager.FreeDeviceState.IGNORE);
        return null;
    }

    @Override
    public ITestDevice reconnectDeviceToTcp(ITestDevice usbDevice) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Reconnecting device %s to adb over tcpip", usbDevice.getSerialNumber());
        ITestDevice tcpDevice = null;
        if (usbDevice instanceof IManagedTestDevice) {
            IManagedTestDevice managedUsbDevice = (IManagedTestDevice)usbDevice;
            String ipAndPort = managedUsbDevice.switchToAdbTcp();
            if (ipAndPort != null) {
                LogUtil.CLog.d("Device %s was switched to adb tcp on %s", usbDevice.getSerialNumber(), ipAndPort);
                tcpDevice = this.connectToTcpDevice(ipAndPort);
                if (tcpDevice == null) {
                    managedUsbDevice.recoverDevice();
                }
            }
        } else {
            LogUtil.CLog.e("reconnectDeviceToTcp: unrecognized device type.");
        }
        return tcpDevice;
    }

    @Override
    public boolean disconnectFromTcpDevice(ITestDevice tcpDevice) {
        LogUtil.CLog.i("Disconnecting and freeing tcp device %s", tcpDevice.getSerialNumber());
        boolean result = false;
        try {
            result = tcpDevice.switchToAdbUsb();
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.w("Failed to switch device %s to usb mode: %s", tcpDevice.getSerialNumber(), e.getMessage());
        }
        this.freeDevice(tcpDevice, IDeviceManager.FreeDeviceState.IGNORE);
        return result;
    }

    private boolean doAdbConnect(String ipAndPort) {
        String resultSuccess = String.format("connected to %s", ipAndPort);
        for (int i = 1; i <= 3; ++i) {
            String adbConnectResult = this.executeGlobalAdbCommand("connect", ipAndPort);
            if (adbConnectResult.startsWith(resultSuccess)) {
                return true;
            }
            LogUtil.CLog.w("Failed to connect to device on %s, attempt %d of 3. Response: %s.", ipAndPort, i, adbConnectResult);
            this.getRunUtil().sleep(5000L);
        }
        return false;
    }

    public String executeGlobalAdbCommand(String ... cmdArgs) {
        String[] fullCmd = ArrayUtil.buildArray({"adb"}, cmdArgs);
        CommandResult result = this.getRunUtil().runTimedCmd(60000L, fullCmd);
        if (CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            return result.getStdout();
        }
        LogUtil.CLog.w("adb %s failed", cmdArgs[0]);
        return null;
    }

    @Override
    public synchronized void terminate() {
        this.checkInit();
        if (!this.mIsTerminated) {
            this.mIsTerminated = true;
            this.mAdbBridge.removeDeviceChangeListener(this.mManagedDeviceListener);
            this.mAdbBridge.terminate();
            if (this.mFastbootMonitor != null) {
                this.mFastbootMonitor.terminate();
            }
        }
    }

    @Override
    public synchronized void terminateHard() {
        this.checkInit();
        if (!this.mIsTerminated) {
            for (IManagedTestDevice device : this.mAllocatedDeviceMap.values()) {
                device.setRecovery(new AbortRecovery());
            }
            this.mAdbBridge.disconnectBridge();
            this.terminate();
        }
    }

    @Override
    public synchronized Collection<String> getAllocatedDevices() {
        this.checkInit();
        ArrayList<String> allocatedDeviceSerials = new ArrayList<String>(this.mAllocatedDeviceMap.size());
        allocatedDeviceSerials.addAll(this.mAllocatedDeviceMap.keySet());
        return allocatedDeviceSerials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<String> getAvailableDevices() {
        this.checkInit();
        ArrayList<String> availableDeviceSerials = new ArrayList<String>(this.mAvailableDeviceQueue.size());
        ConditionPriorityBlockingQueue<IDevice> conditionPriorityBlockingQueue = this.mAvailableDeviceQueue;
        synchronized (conditionPriorityBlockingQueue) {
            for (IDevice device : this.mAvailableDeviceQueue) {
                if (device instanceof StubDevice) continue;
                availableDeviceSerials.add(device.getSerialNumber());
            }
        }
        return availableDeviceSerials;
    }

    @Override
    public synchronized Collection<String> getUnavailableDevices() {
        this.checkInit();
        IDevice[] visibleDevices = this.mAdbBridge.getDevices();
        ArrayList<String> unavailableSerials = new ArrayList<String>(visibleDevices.length);
        Collection<String> availSerials = this.getAvailableDevices();
        Collection<String> allocatedSerials = this.getAllocatedDevices();
        for (IDevice device : visibleDevices) {
            if (availSerials.contains(device.getSerialNumber()) || allocatedSerials.contains(device.getSerialNumber())) continue;
            unavailableSerials.add(device.getSerialNumber());
        }
        return unavailableSerials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void displayDevicesInfo(PrintWriter stream) {
        LinkedHashMap<IDevice, String> deviceMap = new LinkedHashMap<IDevice, String>();
        ArrayList<List<String>> displayRows = new ArrayList<List<String>>();
        displayRows.add(Arrays.asList("Serial", "State", "Product", "Variant", "Build", "Battery"));
        DeviceManager deviceManager = this;
        synchronized (deviceManager) {
            this.checkInit();
            HashSet visibleDeviceSet = new HashSet();
            Collections.addAll(visibleDeviceSet, this.mAdbBridge.getDevices());
            for (IManagedTestDevice iManagedTestDevice : this.mAllocatedDeviceMap.values()) {
                deviceMap.put(iManagedTestDevice.getIDevice(), "Allocated");
                visibleDeviceSet.remove(iManagedTestDevice.getIDevice());
            }
            for (IDevice iDevice : this.mAvailableDeviceQueue) {
                if (iDevice instanceof StubDevice) continue;
                deviceMap.put(iDevice, "Available");
                visibleDeviceSet.remove(iDevice);
            }
            for (IDevice iDevice : visibleDeviceSet) {
                deviceMap.put(iDevice, "Unavailable");
            }
        }
        IDeviceSelection selector = this.getDeviceSelectionOptions();
        this.addDevicesInfo(selector, displayRows, deviceMap);
        new TableFormatter().displayTable(displayRows, stream);
    }

    IDeviceSelection getDeviceSelectionOptions() {
        return new DeviceSelectionOptions();
    }

    private void addDevicesInfo(IDeviceSelection selector, List<List<String>> displayRows, Map<IDevice, String> deviceStateMap) {
        for (Map.Entry<IDevice, String> deviceEntry : deviceStateMap.entrySet()) {
            IDevice device = deviceEntry.getKey();
            String deviceState = deviceEntry.getValue();
            displayRows.add(Arrays.asList(device.getSerialNumber(), deviceState, this.getDisplay(selector.getDeviceProductType(device)), this.getDisplay(selector.getDeviceProductVariant(device)), this.getDisplay(device.getProperty("ro.build.id")), this.getDisplay(selector.getBatteryLevel(device))));
        }
    }

    private String getDisplay(Object o) {
        return o == null ? "unknown" : o.toString();
    }

    @Override
    public void addFastbootListener(IDeviceManager.IFastbootListener listener) {
        this.checkInit();
        if (!this.mFastbootEnabled) {
            throw new UnsupportedOperationException("fastboot is not enabled");
        }
        this.mFastbootListeners.add(listener);
    }

    @Override
    public void removeFastbootListener(IDeviceManager.IFastbootListener listener) {
        this.checkInit();
        if (this.mFastbootEnabled) {
            this.mFastbootListeners.remove(listener);
        }
    }

    private Set<String> getDevicesOnFastboot() {
        CommandResult fastbootResult = this.getRunUtil().runTimedCmd(60000L, "fastboot", "devices");
        if (fastbootResult.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            LogUtil.CLog.v("fastboot devices returned\n %s", fastbootResult.getStdout());
            return DeviceManager.parseDevicesOnFastboot(fastbootResult.getStdout());
        }
        LogUtil.CLog.w("'fastboot devices' failed. Result: %s, stderr: %s", new Object[]{fastbootResult.getStatus(), fastbootResult.getStderr()});
        return null;
    }

    static Set<String> parseDevicesOnFastboot(String fastbootOutput) {
        HashSet<String> serials = new HashSet<String>();
        Pattern fastbootPattern = Pattern.compile("([\\w\\d]+)\\s+fastboot\\s*");
        Matcher fastbootMatcher = fastbootPattern.matcher(fastbootOutput);
        while (fastbootMatcher.find()) {
            serials.add(fastbootMatcher.group(1));
        }
        return serials;
    }

    private class FastbootMonitor
    extends Thread {
        private boolean mQuit;

        FastbootMonitor() {
            super("FastbootMonitor");
            this.mQuit = false;
        }

        public void terminate() {
            this.mQuit = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.mQuit) {
                Set serials;
                if (!DeviceManager.this.mFastbootListeners.isEmpty() && (serials = DeviceManager.this.getDevicesOnFastboot()) != null) {
                    for (String serial : serials) {
                        IManagedTestDevice testDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(serial);
                        if (testDevice == null || testDevice.getDeviceState().equals((Object)TestDeviceState.FASTBOOT)) continue;
                        testDevice.setDeviceState(TestDeviceState.FASTBOOT);
                    }
                    Map i$ = DeviceManager.this.mAllocatedDeviceMap;
                    synchronized (i$) {
                        for (IManagedTestDevice testDevice : DeviceManager.this.mAllocatedDeviceMap.values()) {
                            if (serials.contains(testDevice.getSerialNumber()) || !testDevice.getDeviceState().equals((Object)TestDeviceState.FASTBOOT)) continue;
                            testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
                        }
                    }
                    ArrayList listenersCopy = new ArrayList(DeviceManager.this.mFastbootListeners.size());
                    listenersCopy.addAll(DeviceManager.this.mFastbootListeners);
                    for (IDeviceManager.IFastbootListener listener : listenersCopy) {
                        listener.stateUpdated();
                    }
                }
                DeviceManager.this.getRunUtil().sleep(5000L);
            }
        }
    }

    private class ManagedDeviceListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private ManagedDeviceListener() {
        }

        public void deviceChanged(IDevice device, int changeMask) {
            IManagedTestDevice testDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(device.getSerialNumber());
            if ((changeMask & 1) != 0) {
                if (testDevice != null) {
                    TestDeviceState newState = TestDeviceState.getStateByDdms(device.getState());
                    testDevice.setDeviceState(newState);
                } else if (DeviceManager.this.mCheckDeviceMap.containsKey(device.getSerialNumber())) {
                    IDeviceStateMonitor monitor = (IDeviceStateMonitor)DeviceManager.this.mCheckDeviceMap.get(device.getSerialNumber());
                    monitor.setState(TestDeviceState.getStateByDdms(device.getState()));
                } else if (!DeviceManager.this.mAvailableDeviceQueue.contains(device) && device.getState() == IDevice.DeviceState.ONLINE) {
                    DeviceManager.this.checkAndAddAvailableDevice(device);
                }
            }
        }

        public void deviceConnected(IDevice device) {
            LogUtil.CLog.d("Detected device connect %s, id %d", device.getSerialNumber(), device.hashCode());
            IManagedTestDevice testDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(device.getSerialNumber());
            if (testDevice == null) {
                if (this.isValidDeviceSerial(device.getSerialNumber()) && device.getState() == IDevice.DeviceState.ONLINE) {
                    DeviceManager.this.checkAndAddAvailableDevice(device);
                } else if (DeviceManager.this.mCheckDeviceMap.containsKey(device.getSerialNumber())) {
                    IDeviceStateMonitor monitor = (IDeviceStateMonitor)DeviceManager.this.mCheckDeviceMap.get(device.getSerialNumber());
                    monitor.setState(TestDeviceState.getStateByDdms(device.getState()));
                }
            } else {
                LogUtil.CLog.d("Updating IDevice for device %s", device.getSerialNumber());
                testDevice.setIDevice(device);
                TestDeviceState newState = TestDeviceState.getStateByDdms(device.getState());
                testDevice.setDeviceState(newState);
            }
        }

        private boolean isValidDeviceSerial(String serial) {
            return serial.length() > 1 && !serial.contains("?");
        }

        public void deviceDisconnected(IDevice disconnectedDevice) {
            IManagedTestDevice testDevice;
            if (DeviceManager.this.mAvailableDeviceQueue.remove(disconnectedDevice)) {
                LogUtil.CLog.i("Removed disconnected device %s from available queue", disconnectedDevice.getSerialNumber());
            }
            if ((testDevice = (IManagedTestDevice)DeviceManager.this.mAllocatedDeviceMap.get(disconnectedDevice.getSerialNumber())) != null) {
                testDevice.setDeviceState(TestDeviceState.NOT_AVAILABLE);
            } else if (DeviceManager.this.mCheckDeviceMap.containsKey(disconnectedDevice.getSerialNumber())) {
                IDeviceStateMonitor monitor = (IDeviceStateMonitor)DeviceManager.this.mCheckDeviceMap.get(disconnectedDevice.getSerialNumber());
                monitor.setState(TestDeviceState.NOT_AVAILABLE);
            }
        }
    }

    private static class AbortRecovery
    implements IDeviceRecovery {
        private AbortRecovery() {
        }

        public void recoverDevice(IDeviceStateMonitor monitor, boolean recoverUntilOnline) throws DeviceNotAvailableException {
            throw new DeviceNotAvailableException("aborted test session");
        }

        public void recoverDeviceBootloader(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
            throw new DeviceNotAvailableException("aborted test session");
        }

        public void recoverDeviceRecovery(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
            throw new DeviceNotAvailableException("aborted test session");
        }
    }

    private static class FastbootDevice
    extends StubDevice {
        FastbootDevice(String serial) {
            super(serial, false);
        }
    }
}

