/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceSelectionOptions
implements IDeviceSelection {
    private static final String LOG_TAG = "DeviceSelectionOptions";
    @Option(name="serial", shortName=115, description="run this test on a specific device with given serial number(s).")
    private Collection<String> mSerials = new ArrayList<String>();
    @Option(name="exclude-serial", description="run this test on any device except those with this serial number(s).")
    private Collection<String> mExcludeSerials = new ArrayList<String>();
    @Option(name="product-type", description="run this test on device with this product type(s).  May also filter by variant using product:variant.")
    private Collection<String> mProductTypes = new ArrayList<String>();
    @Option(name="property", description="run this test on device with this property value. Expected format <propertyname>=<propertyvalue>.")
    private Collection<String> mPropertyStrings = new ArrayList<String>();
    @Option(name="emulator", shortName=101, description="force this test to run on emulator.")
    private boolean mEmulatorRequested = false;
    @Option(name="device", shortName=100, description="force this test to run on a physical device, not an emulator.")
    private boolean mDeviceRequested = false;
    @Option(name="new-emulator", description="allocate a placeholder emulator. Should be used when config intends to launch an emulator")
    private boolean mStubEmulatorRequested = false;
    @Option(name="null-device", shortName=110, description="do not allocate a device for this test.")
    private boolean mNullDeviceRequested = false;
    @Option(name="min-battery", description="only run this test on a device whose battery level is at least the given amount. Scale: 0-100")
    private Integer mMinBattery = null;
    @Option(name="max-battery", description="only run this test on a device whose battery level is strictly less than the given amount. Scale: 0-100")
    private Integer mMaxBattery = null;
    @Option(name="require-battery-check", description="_If_ --min-battery and/or --max-battery is specified, skip devices that have an unknown battery level.  Note that this may leave restart-looping devices in limbo indefinitely without manual intervention.")
    private boolean mRequireBatteryCheck = false;
    private boolean mFetchedEnvVariable = false;
    private static final String VARIANT_SEPARATOR = ":";

    public void addSerial(String serialNumber) {
        this.mSerials.add(serialNumber);
    }

    public void addExcludeSerial(String serialNumber) {
        this.mExcludeSerials.add(serialNumber);
    }

    public void addProductType(String productType) {
        this.mProductTypes.add(productType);
    }

    public void addProperty(String propertyKeyValue) {
        this.mPropertyStrings.add(propertyKeyValue);
    }

    @Override
    public Collection<String> getSerials() {
        if (this.mSerials.isEmpty() && !this.mFetchedEnvVariable) {
            String env_serial = this.fetchEnvironmentVariable("ANDROID_SERIAL");
            if (env_serial != null) {
                this.mSerials.add(env_serial);
            }
            this.mFetchedEnvVariable = true;
        }
        return this.copyCollection(this.mSerials);
    }

    @Override
    public Collection<String> getExcludeSerials() {
        return this.copyCollection(this.mExcludeSerials);
    }

    @Override
    public Collection<String> getProductTypes() {
        return this.copyCollection(this.mProductTypes);
    }

    @Override
    public boolean deviceRequested() {
        return this.mDeviceRequested;
    }

    @Override
    public boolean emulatorRequested() {
        return this.mEmulatorRequested;
    }

    @Override
    public boolean stubEmulatorRequested() {
        return this.mStubEmulatorRequested;
    }

    @Override
    public boolean nullDeviceRequested() {
        return this.mNullDeviceRequested;
    }

    public void setEmulatorRequested(boolean emulatorRequested) {
        this.mEmulatorRequested = emulatorRequested;
    }

    public void setStubEmulatorRequested(boolean stubEmulatorRequested) {
        this.mStubEmulatorRequested = stubEmulatorRequested;
    }

    public void setDeviceRequested(boolean deviceRequested) {
        this.mDeviceRequested = deviceRequested;
    }

    public void setNullDeviceRequested(boolean nullDeviceRequested) {
        this.mNullDeviceRequested = nullDeviceRequested;
    }

    public void setMinBatteryLevel(Integer minBattery) {
        this.mMinBattery = minBattery;
    }

    public Integer getMinBatteryLevel() {
        return this.mMinBattery;
    }

    public void setMaxBatteryLevel(Integer maxBattery) {
        this.mMaxBattery = maxBattery;
    }

    public Integer getMaxBatteryLevel() {
        return this.mMaxBattery;
    }

    public void setRequireBatteryCheck(boolean requireCheck) {
        this.mRequireBatteryCheck = requireCheck;
    }

    public boolean getRequireBatteryCheck() {
        return this.mRequireBatteryCheck;
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> propertyMap = new HashMap<String, String>(this.mPropertyStrings.size());
        for (String propertyKeyValue : this.mPropertyStrings) {
            String[] keyValuePair = propertyKeyValue.split("=");
            if (keyValuePair.length == 2) {
                propertyMap.put(keyValuePair[0], keyValuePair[1]);
                continue;
            }
            Log.e((String)LOG_TAG, (String)String.format("Unrecognized property key value pair: '%s'", propertyKeyValue));
        }
        return propertyMap;
    }

    private Collection<String> copyCollection(Collection<String> original) {
        ArrayList<String> listCopy = new ArrayList<String>(original.size());
        listCopy.addAll(original);
        return listCopy;
    }

    String fetchEnvironmentVariable(String name) {
        return System.getenv(name);
    }

    @Override
    public boolean matches(IDevice device) {
        Collection<String> serials = this.getSerials();
        Collection<String> excludeSerials = this.getExcludeSerials();
        Map<String, Collection<String>> productVariants = this.splitOnVariant(this.getProductTypes());
        Set<String> productTypes = productVariants.keySet();
        Map<String, String> properties = this.getProperties();
        if (!serials.isEmpty() && !serials.contains(device.getSerialNumber())) {
            return false;
        }
        if (excludeSerials.contains(device.getSerialNumber())) {
            return false;
        }
        if (!productTypes.isEmpty()) {
            String productType = this.getDeviceProductType(device);
            if (productTypes.contains(productType)) {
                String productVariant = this.getDeviceProductVariant(device);
                Collection<String> variants = productVariants.get(productType);
                if (variants != null && !variants.contains(productVariant)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        for (Map.Entry<String, String> propEntry : properties.entrySet()) {
            if (propEntry.getValue().equals(device.getProperty(propEntry.getKey()))) continue;
            return false;
        }
        if ((this.emulatorRequested() || this.stubEmulatorRequested()) && !device.isEmulator()) {
            return false;
        }
        if (this.deviceRequested() && device.isEmulator()) {
            return false;
        }
        if (device.isEmulator() && device instanceof StubDevice && !this.stubEmulatorRequested()) {
            return false;
        }
        if (this.nullDeviceRequested() != device instanceof NullDevice) {
            return false;
        }
        if (this.mMinBattery != null || this.mMaxBattery != null) {
            Integer deviceBattery = this.getBatteryLevel(device);
            if (this.mRequireBatteryCheck && deviceBattery == null) {
                return false;
            }
            if (DeviceSelectionOptions.isLessAndNotNull(deviceBattery, this.mMinBattery)) {
                return false;
            }
            if (DeviceSelectionOptions.isLessEqAndNotNull(this.mMaxBattery, deviceBattery)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isLessAndNotNull(Integer x, Integer y) {
        if (x == null || y == null) {
            return false;
        }
        return x < y;
    }

    private static boolean isLessEqAndNotNull(Integer x, Integer y) {
        if (x == null || y == null) {
            return false;
        }
        return x <= y;
    }

    private Map<String, Collection<String>> splitOnVariant(Collection<String> products) {
        HashMap<String, Collection<String>> splitProducts = new HashMap<String, Collection<String>>(products.size());
        for (String prod : products) {
            String[] parts = prod.split(VARIANT_SEPARATOR);
            if (parts.length == 1) {
                splitProducts.put(parts[0], null);
                continue;
            }
            if (parts.length == 2) {
                HashSet<String> variants = (HashSet<String>)splitProducts.get(parts[0]);
                if (variants == null) {
                    variants = new HashSet<String>();
                    splitProducts.put(parts[0], variants);
                }
                variants.add(parts[1]);
                continue;
            }
            throw new IllegalArgumentException(String.format("The product type filter \"%s\" is invalid.  It must contain 0 or 1 '%s' characters, not %d.", prod, VARIANT_SEPARATOR, parts.length));
        }
        return splitProducts;
    }

    @Override
    public String getDeviceProductType(IDevice device) {
        return this.getProperty(device, "ro.hardware");
    }

    private String getProperty(IDevice device, String propName) {
        try {
            return device.getPropertyCacheOrSync(propName);
        }
        catch (TimeoutException e) {
            this.handlePropException(device, (Exception)((Object)e));
        }
        catch (AdbCommandRejectedException e) {
            this.handlePropException(device, (Exception)((Object)e));
        }
        catch (IOException e) {
            this.handlePropException(device, e);
        }
        catch (ShellCommandUnresponsiveException e) {
            this.handlePropException(device, (Exception)((Object)e));
        }
        return null;
    }

    private void handlePropException(IDevice device, Exception e) {
        LogUtil.CLog.w("Failed to query device property for %s: %s", device.getSerialNumber(), e.toString());
    }

    @Override
    public String getDeviceProductVariant(IDevice device) {
        return this.getProperty(device, "ro.product.device");
    }

    @Override
    public Integer getBatteryLevel(IDevice device) {
        try {
            return device.getBatteryLevel();
        }
        catch (TimeoutException e) {
            this.handleBatteryException(device, (Exception)((Object)e));
        }
        catch (AdbCommandRejectedException e) {
            this.handleBatteryException(device, (Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleBatteryException(device, e);
        }
        catch (ShellCommandUnresponsiveException e) {
            this.handleBatteryException(device, (Exception)((Object)e));
        }
        return null;
    }

    private void handleBatteryException(IDevice device, Exception e) {
        LogUtil.CLog.w("Failed to query battery level for %s: %s", device.getSerialNumber(), e.toString());
    }
}

