/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SequenceInputStream;

public class LargeOutputReceiver
implements IShellOutputReceiver {
    public static final int BUFF_SIZE = 32768;
    private String mSerialNumber;
    private String mDescriptor;
    private long mMaxFileSize;
    private boolean mIsCancelled = false;
    private OutputStream mOutStream;
    private File mPreviousTmpFile = null;
    private File mTmpFile = null;
    private long mTmpBytesStored = 0L;

    public LargeOutputReceiver(String descriptor, String serialNumber, long maxFileSize) {
        this.mDescriptor = descriptor;
        this.mSerialNumber = serialNumber;
        this.mMaxFileSize = maxFileSize;
        try {
            this.createTmpFile();
        }
        catch (IOException e) {
            LogUtil.CLog.w("failed to create %s file for %s.", this.mDescriptor, this.mSerialNumber);
        }
    }

    public synchronized void addOutput(byte[] data, int offset, int length) {
        if (this.mIsCancelled || this.mOutStream == null) {
            return;
        }
        try {
            this.mOutStream.write(data, offset, length);
            this.mTmpBytesStored += (long)length;
            if (this.mTmpBytesStored > this.mMaxFileSize) {
                LogUtil.CLog.i("Max tmp %s file size reached for %s, swapping", this.mDescriptor, this.mSerialNumber);
                this.createTmpFile();
                this.mTmpBytesStored = 0L;
            }
        }
        catch (IOException e) {
            LogUtil.CLog.w("failed to write %s data for %s.", this.mDescriptor, this.mSerialNumber);
        }
    }

    public synchronized InputStreamSource getData() {
        if (this.mTmpFile != null) {
            this.flush();
            try {
                FileInputStream fileStream = new FileInputStream(this.mTmpFile);
                if (this.mPreviousTmpFile != null) {
                    SequenceInputStream stream = new SequenceInputStream(new FileInputStream(this.mPreviousTmpFile), fileStream);
                    return new SnapshotInputStreamSource(stream);
                }
                return new SnapshotInputStreamSource(fileStream);
            }
            catch (IOException e) {
                LogUtil.CLog.e("failed to get %s data for %s.", this.mDescriptor, this.mSerialNumber);
                LogUtil.CLog.e(e);
            }
        }
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    public synchronized void flush() {
        if (this.mOutStream == null) {
            return;
        }
        try {
            this.mOutStream.flush();
        }
        catch (IOException e) {
            LogUtil.CLog.w("failed to flush %s data for %s.", this.mDescriptor, this.mSerialNumber);
        }
    }

    public synchronized void clear() {
        this.delete();
        try {
            this.createTmpFile();
        }
        catch (IOException e) {
            LogUtil.CLog.w("failed to create %s file for %s.", this.mDescriptor, this.mSerialNumber);
        }
    }

    public synchronized void cancel() {
        this.mIsCancelled = true;
    }

    public void delete() {
        this.flush();
        this.closeLogStream();
        FileUtil.deleteFile(this.mTmpFile);
        this.mTmpFile = null;
        FileUtil.deleteFile(this.mPreviousTmpFile);
        this.mPreviousTmpFile = null;
        this.mTmpBytesStored = 0L;
    }

    private void closeLogStream() {
        try {
            if (this.mOutStream != null) {
                this.mOutStream.flush();
                this.mOutStream.close();
                this.mOutStream = null;
            }
        }
        catch (IOException e) {
            LogUtil.CLog.w("failed to close %s stream for %s.", this.mDescriptor, this.mSerialNumber);
        }
    }

    public synchronized boolean isCancelled() {
        return this.mIsCancelled;
    }

    synchronized void createTmpFile() throws IOException, FileNotFoundException {
        if (this.mIsCancelled) {
            LogUtil.CLog.w("Attempted to createTmpFile() after cancel() for device %s, ignoring.", this.mSerialNumber);
            return;
        }
        this.closeLogStream();
        if (this.mPreviousTmpFile != null) {
            this.mPreviousTmpFile.delete();
        }
        this.mPreviousTmpFile = this.mTmpFile;
        this.mTmpFile = FileUtil.createTempFile(String.format("%s_%s_", this.mDescriptor, this.mSerialNumber), ".txt");
        LogUtil.CLog.i("Created tmp %s file %s", this.mDescriptor, this.mTmpFile.getAbsolutePath());
        this.mOutStream = new BufferedOutputStream(new FileOutputStream(this.mTmpFile), 32768);
        if (this.mPreviousTmpFile == null) {
            this.appendLogMsg(String.format("%s for device %s", this.mDescriptor, this.mSerialNumber));
        } else {
            this.appendLogMsg(String.format("Continuing %s capture for device %s. Previous content may have been truncated.", this.mDescriptor, this.mSerialNumber));
        }
    }

    protected synchronized void appendLogMsg(String msg) {
        if (this.mOutStream == null || msg == null) {
            return;
        }
        try {
            this.mOutStream.write("\n*******************\n".getBytes());
            this.mOutStream.write(msg.getBytes());
            this.mOutStream.write("\n*******************\n".getBytes());
        }
        catch (IOException e) {
            LogUtil.CLog.w("failed to write %s data for %s.", this.mDescriptor, this.mSerialNumber);
        }
    }

    String getDescriptor() {
        return this.mDescriptor;
    }
}

