/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;

public class ReconnectingRecovery
implements IDeviceRecovery {
    private static final int ADB_TIMEOUT = 120000;
    private static final int CONNECTION_ATTEMPTS = 5;

    public void recoverDevice(IDeviceStateMonitor monitor, boolean recoverUntilOnline) throws DeviceNotAvailableException {
        String serial = monitor.getSerialNumber();
        this.getRunUtil().runTimedCmd(120000L, "adb", "disconnect", serial);
        int attempt = 1;
        do {
            LogUtil.CLog.i("Trying to reconnect with device " + serial + " / attempt " + attempt);
            this.getRunUtil().runTimedCmd(120000L, "adb", "connect", serial);
        } while (monitor.waitForDeviceOnline() == null && ++attempt <= 5);
        String errMsg = "Could not recover device " + serial + " after " + --attempt + " attempts";
        if (!monitor.waitForDeviceShell(10000L)) {
            throw new DeviceUnresponsiveException(errMsg);
        }
        if (!recoverUntilOnline && monitor.waitForDeviceAvailable() == null) {
            throw new DeviceUnresponsiveException(errMsg);
        }
        LogUtil.CLog.v("Successfully reconnected with device " + serial);
    }

    public void recoverDeviceBootloader(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException("This implementation can't recover a device in bootloader mode.");
    }

    public void recoverDeviceRecovery(IDeviceStateMonitor monitor) throws DeviceNotAvailableException {
        this.recoverDevice(monitor, false);
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }
}

