/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.device.CollectingByteOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.FileEntryWrapper;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.IWifiHelper;
import com.android.tradefed.device.LogcatReceiver;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.WaitDeviceRecovery;
import com.android.tradefed.device.WifiHelper;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.StubTestRunListener;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestDevice
implements IManagedTestDevice {
    static final int MAX_RETRY_ATTEMPTS = 2;
    private static final String BUGREPORT_CMD = "bugreport";
    private static final String LIST_PACKAGES_CMD = "pm list packages";
    private static final Pattern PACKAGE_REGEX = Pattern.compile("package:(.*)");
    private static final int BUGREPORT_TIMEOUT = 120000;
    private static final String ENCRYPTION_PASSWORD = "android";
    private static final int ENCRYPTION_INPLACE_TIMEOUT = 0x6DDD00;
    private static final int ENCRYPTION_WIPE_TIMEOUT = 300000;
    private static final String ENCRYPTION_SUPPORTED_CODE = "500";
    private static final String ENCRYPTION_SUPPORTED_USAGE = "Usage: ";
    private int mLogStartDelay = 5000;
    private static final int DEFAULT_UNAVAILABLE_TIMEOUT = 20000;
    static final int NONE_RECOVERY_MODE_DELAY = 1000;
    private static final int NUM_CLEAR_ATTEMPTS = 5;
    static final String DISMISS_DIALOG_CMD = "input keyevent 23";
    private static final String BUILD_ID_PROP = "ro.build.version.incremental";
    private int mCmdTimeout = 120000;
    private long mLongCmdTimeout = 720000L;
    private IDevice mIDevice;
    private IDeviceRecovery mRecovery = new WaitDeviceRecovery();
    private final IDeviceStateMonitor mMonitor;
    private TestDeviceState mState = TestDeviceState.ONLINE;
    private final ReentrantLock mFastbootLock = new ReentrantLock();
    private LogcatReceiver mLogcatReceiver;
    private IFileEntry mRootFile = null;
    private boolean mFastbootEnabled = true;
    private TestDeviceOptions mOptions = new TestDeviceOptions();
    private Process mEmulatorProcess;
    private ITestDevice.RecoveryMode mRecoveryMode = ITestDevice.RecoveryMode.AVAILABLE;
    private Boolean mIsEncryptionSupported = null;

    TestDevice(IDevice device, IDeviceStateMonitor monitor) {
        this.throwIfNull(device);
        this.throwIfNull(monitor);
        this.mIDevice = device;
        this.mMonitor = monitor;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    @Override
    public void setOptions(TestDeviceOptions options) {
        this.throwIfNull(options);
        this.mOptions = options;
        this.mMonitor.setDefaultOnlineTimeout(options.getOnlineTimeout());
        this.mMonitor.setDefaultAvailableTimeout(options.getAvailableTimeout());
    }

    void setTmpLogcatSize(long size) {
        this.mOptions.setMaxLogcatFileSize(size);
    }

    void setLogStartDelay(int delay) {
        this.mLogStartDelay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDevice getIDevice() {
        IDevice iDevice = this.mIDevice;
        synchronized (iDevice) {
            return this.mIDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIDevice(IDevice newDevice) {
        this.throwIfNull(newDevice);
        IDevice currentDevice = this.mIDevice;
        if (!this.getIDevice().equals(newDevice)) {
            IDevice iDevice = currentDevice;
            synchronized (iDevice) {
                this.mIDevice = newDevice;
            }
            this.mMonitor.setIDevice(this.mIDevice);
        }
    }

    @Override
    public String getSerialNumber() {
        return this.getIDevice().getSerialNumber();
    }

    private boolean nullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private String internalGetProperty(String prop, String fastbootVar, String description) throws DeviceNotAvailableException, UnsupportedOperationException {
        if (this.getIDevice().arePropertiesSet()) {
            return this.getIDevice().getProperty(prop);
        }
        if (TestDeviceState.FASTBOOT.equals((Object)this.getDeviceState()) && fastbootVar != null) {
            LogUtil.CLog.i("%s for device %s is null, re-querying in fastboot", description, this.getSerialNumber());
            return this.getFastbootVariable(fastbootVar);
        }
        LogUtil.CLog.d("property collection for device %s is null, re-querying for prop %s", this.getSerialNumber(), description);
        return this.getProperty(prop);
    }

    @Override
    public String getProperty(final String name) throws DeviceNotAvailableException {
        final String[] result = new String[1];
        DeviceAction propAction = new DeviceAction(){

            public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException {
                result[0] = TestDevice.this.getIDevice().getPropertyCacheOrSync(name);
                return true;
            }
        };
        this.performDeviceAction("getprop", propAction, 2);
        return result[0];
    }

    @Override
    public String getPropertySync(final String name) throws DeviceNotAvailableException {
        final String[] result = new String[1];
        DeviceAction propAction = new DeviceAction(){

            public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException {
                result[0] = TestDevice.this.getIDevice().getPropertySync(name);
                return true;
            }
        };
        this.performDeviceAction("getprop", propAction, 2);
        return result[0];
    }

    @Override
    public String getBootloaderVersion() throws UnsupportedOperationException, DeviceNotAvailableException {
        return this.internalGetProperty("ro.bootloader", "version-bootloader", "Bootloader");
    }

    @Override
    public String getProductType() throws DeviceNotAvailableException {
        return this.internalGetProductType(2);
    }

    private String internalGetProductType(int retryAttempts) throws DeviceNotAvailableException {
        String productType = this.internalGetProperty("ro.hardware", "product", "Product type");
        if (this.nullOrEmpty(productType)) {
            if (retryAttempts > 0) {
                this.recoverDevice();
                productType = this.internalGetProductType(retryAttempts - 1);
            }
            if (this.nullOrEmpty(productType)) {
                throw new DeviceNotAvailableException(String.format("Could not determine product type for device %s.", this.getSerialNumber()));
            }
        }
        return productType;
    }

    @Override
    public String getFastbootProductType() throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.getFastbootVariable("product");
    }

    @Override
    public String getProductVariant() throws DeviceNotAvailableException {
        return this.internalGetProperty("ro.product.device", "variant", "Product variant");
    }

    @Override
    public String getFastbootProductVariant() throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.getFastbootVariable("variant");
    }

    private String getFastbootVariable(String variableName) throws DeviceNotAvailableException, UnsupportedOperationException {
        CommandResult result = this.executeFastbootCommand("getvar", variableName);
        if (result.getStatus() == CommandStatus.SUCCESS) {
            Matcher matcher;
            Pattern fastbootProductPattern = Pattern.compile(variableName + ":\\s(.*)\\s");
            String resultText = result.getStdout();
            if (resultText == null || resultText.length() < 1) {
                resultText = result.getStderr();
            }
            if ((matcher = fastbootProductPattern.matcher(resultText)).find()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    @Override
    public String getBuildId() {
        String bid = this.getIDevice().getProperty(BUILD_ID_PROP);
        if (bid == null) {
            LogUtil.CLog.w("Could not get device %s build id.", this.getSerialNumber());
            return "-1";
        }
        return bid;
    }

    @Override
    public void executeShellCommand(final String command, final IShellOutputReceiver receiver) throws DeviceNotAvailableException {
        DeviceAction action = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
                TestDevice.this.getIDevice().executeShellCommand(command, receiver, TestDevice.this.mCmdTimeout);
                return true;
            }
        };
        this.performDeviceAction(String.format("shell %s", command), action, 2);
    }

    @Override
    public void executeShellCommand(final String command, final IShellOutputReceiver receiver, final int maxTimeToOutputShellResponse, int retryAttempts) throws DeviceNotAvailableException {
        DeviceAction action = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
                TestDevice.this.getIDevice().executeShellCommand(command, receiver, maxTimeToOutputShellResponse);
                return true;
            }
        };
        this.performDeviceAction(String.format("shell %s", command), action, retryAttempts);
    }

    @Override
    public String executeShellCommand(String command) throws DeviceNotAvailableException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        this.executeShellCommand(command, (IShellOutputReceiver)receiver);
        String output = receiver.getOutput();
        LogUtil.CLog.v("%s on %s returned %s", command, this.getSerialNumber(), output);
        return output;
    }

    @Override
    public boolean runInstrumentationTests(final IRemoteAndroidTestRunner runner, final Collection<ITestRunListener> listeners) throws DeviceNotAvailableException {
        RunFailureListener failureListener = new RunFailureListener();
        listeners.add(failureListener);
        DeviceAction runTestsAction = new DeviceAction(){

            public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException {
                runner.run(listeners);
                return true;
            }
        };
        boolean result = this.performDeviceAction(String.format("run %s instrumentation tests", runner.getPackageName()), runTestsAction, 0);
        if (failureListener.isRunFailure() && this.mMonitor.waitForDeviceAvailable(5000L) == null) {
            this.recoverDevice();
        }
        return result;
    }

    @Override
    public boolean runInstrumentationTests(IRemoteAndroidTestRunner runner, ITestRunListener ... listeners) throws DeviceNotAvailableException {
        ArrayList<ITestRunListener> listenerList = new ArrayList<ITestRunListener>();
        listenerList.addAll(Arrays.asList(listeners));
        return this.runInstrumentationTests(runner, listenerList);
    }

    @Override
    public String installPackage(final File packageFile, final boolean reinstall, final String ... extraArgs) throws DeviceNotAvailableException {
        final String[] response = new String[1];
        DeviceAction installAction = new DeviceAction(){

            public boolean run() throws InstallException {
                String result;
                response[0] = result = TestDevice.this.getIDevice().installPackage(packageFile.getAbsolutePath(), reinstall, extraArgs);
                return result == null;
            }
        };
        this.performDeviceAction(String.format("install %s", packageFile.getAbsolutePath()), installAction, 2);
        return response[0];
    }

    public String installPackage(final File packageFile, final File certFile, final boolean reinstall, final String ... extraArgs) throws DeviceNotAvailableException {
        final String[] response = new String[1];
        DeviceAction installAction = new DeviceAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run() throws InstallException, SyncException, IOException, TimeoutException, AdbCommandRejectedException {
                String remotePackagePath = TestDevice.this.getIDevice().syncPackageToDevice(packageFile.getAbsolutePath());
                String remoteCertPath = TestDevice.this.getIDevice().syncPackageToDevice(certFile.getAbsolutePath());
                String[] newExtraArgs = new String[extraArgs.length + 1];
                System.arraycopy(extraArgs, 0, newExtraArgs, 0, extraArgs.length);
                newExtraArgs[newExtraArgs.length - 1] = String.format("\"%s\"", remotePackagePath);
                try {
                    response[0] = TestDevice.this.getIDevice().installRemotePackage(remoteCertPath, reinstall, newExtraArgs);
                }
                finally {
                    TestDevice.this.getIDevice().removeRemotePackage(remotePackagePath);
                    TestDevice.this.getIDevice().removeRemotePackage(remoteCertPath);
                }
                return true;
            }
        };
        this.performDeviceAction(String.format("install %s", packageFile.getAbsolutePath()), installAction, 2);
        return response[0];
    }

    @Override
    public String uninstallPackage(final String packageName) throws DeviceNotAvailableException {
        final String[] response = new String[1];
        DeviceAction uninstallAction = new DeviceAction(){

            public boolean run() throws InstallException {
                String result;
                response[0] = result = TestDevice.this.getIDevice().uninstallPackage(packageName);
                return result == null;
            }
        };
        this.performDeviceAction(String.format("uninstall %s", packageName), uninstallAction, 2);
        return response[0];
    }

    @Override
    public boolean pullFile(final String remoteFilePath, final File localFile) throws DeviceNotAvailableException {
        DeviceAction pullAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                SyncService syncService = null;
                boolean status = false;
                try {
                    syncService = TestDevice.this.getIDevice().getSyncService();
                    syncService.pullFile(remoteFilePath, localFile.getAbsolutePath(), SyncService.getNullProgressMonitor());
                    status = true;
                }
                catch (SyncException e) {
                    LogUtil.CLog.w("Failed to pull %s from %s to %s. Message %s", remoteFilePath, TestDevice.this.getSerialNumber(), localFile.getAbsolutePath(), e.getMessage());
                    throw e;
                }
                finally {
                    if (syncService != null) {
                        syncService.close();
                    }
                }
                return status;
            }
        };
        return this.performDeviceAction(String.format("pull %s to %s", remoteFilePath, localFile.getAbsolutePath()), pullAction, 2);
    }

    @Override
    public File pullFile(String remoteFilePath) throws DeviceNotAvailableException {
        try {
            File localFile = FileUtil.createTempFileForRemote(remoteFilePath, null);
            if (this.pullFile(remoteFilePath, localFile)) {
                return localFile;
            }
        }
        catch (IOException e) {
            LogUtil.CLog.w("Encountered IOException while trying to pull '%s': %s", remoteFilePath, e);
        }
        return null;
    }

    @Override
    public File pullFileFromExternal(String remoteFilePath) throws DeviceNotAvailableException {
        String externalPath = this.getMountPoint("EXTERNAL_STORAGE");
        String fullPath = new File(externalPath, remoteFilePath).getPath();
        return this.pullFile(fullPath);
    }

    @Override
    public boolean pushFile(final File localFile, final String remoteFilePath) throws DeviceNotAvailableException {
        DeviceAction pushAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                SyncService syncService = null;
                boolean status = false;
                try {
                    syncService = TestDevice.this.getIDevice().getSyncService();
                    syncService.pushFile(localFile.getAbsolutePath(), remoteFilePath, SyncService.getNullProgressMonitor());
                    status = true;
                }
                catch (SyncException e) {
                    LogUtil.CLog.w("Failed to push %s to %s on device %s. Message %s", localFile.getAbsolutePath(), remoteFilePath, TestDevice.this.getSerialNumber(), e.getMessage());
                    throw e;
                }
                finally {
                    if (syncService != null) {
                        syncService.close();
                    }
                }
                return status;
            }
        };
        return this.performDeviceAction(String.format("push %s to %s", localFile.getAbsolutePath(), remoteFilePath), pushAction, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushString(String contents, String remoteFilePath) throws DeviceNotAvailableException {
        File tmpFile = null;
        try {
            tmpFile = FileUtil.createTempFile("temp", ".txt");
            FileUtil.writeToFile(contents, tmpFile);
            boolean bl = this.pushFile(tmpFile, remoteFilePath);
            return bl;
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    @Override
    public boolean doesFileExist(String destPath) throws DeviceNotAvailableException {
        String lsGrep = this.executeShellCommand(String.format("ls \"%s\"", destPath));
        return !lsGrep.contains("No such file or directory");
    }

    @Override
    public long getExternalStoreFreeSpace() throws DeviceNotAvailableException {
        LogUtil.CLog.i("Checking free space for %s", this.getSerialNumber());
        String externalStorePath = this.getMountPoint("EXTERNAL_STORAGE");
        String output = this.executeShellCommand(String.format("df %s", externalStorePath));
        Long available = this.parseFreeSpaceFromAvailable(output);
        if (available != null) {
            return available;
        }
        available = this.parseFreeSpaceFromFree(externalStorePath, output);
        if (available != null) {
            return available;
        }
        LogUtil.CLog.e("free space command output \"%s\" did not match expected patterns", output);
        return 0L;
    }

    private Long parseFreeSpaceFromAvailable(String dfOutput) {
        Pattern freeSpacePattern = Pattern.compile("(\\d+)K available");
        Matcher patternMatcher = freeSpacePattern.matcher(dfOutput);
        if (patternMatcher.find()) {
            String freeSpaceString = patternMatcher.group(1);
            try {
                return Long.parseLong(freeSpaceString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    private Long parseFreeSpaceFromFree(String externalStorePath, String dfOutput) {
        Long freeSpace = null;
        Pattern freeSpaceTablePattern = Pattern.compile(String.format("%s\\s+[\\w\\d]+\\s+[\\w\\d]+\\s+(\\d+)(\\w)", externalStorePath));
        Matcher tablePatternMatcher = freeSpaceTablePattern.matcher(dfOutput);
        if (tablePatternMatcher.find()) {
            String numericValueString = tablePatternMatcher.group(1);
            String unitType = tablePatternMatcher.group(2);
            try {
                freeSpace = Long.parseLong(numericValueString);
                if (unitType.equals("M")) {
                    freeSpace = freeSpace * 1024L;
                } else if (unitType.equals("G")) {
                    freeSpace = freeSpace * 1024L * 1024L;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return freeSpace;
    }

    @Override
    public String getMountPoint(String mountName) {
        return this.mMonitor.getMountPoint(mountName);
    }

    @Override
    public List<ITestDevice.MountPointInfo> getMountPointInfo() throws DeviceNotAvailableException {
        String mountInfo = this.executeShellCommand("cat /proc/mounts");
        String[] mountInfoLines = mountInfo.split("\r\n");
        ArrayList<ITestDevice.MountPointInfo> list = new ArrayList<ITestDevice.MountPointInfo>(mountInfoLines.length);
        for (String line : mountInfoLines) {
            String[] parts = line.split("\\s+", 5);
            list.add(new ITestDevice.MountPointInfo(parts[0], parts[1], parts[2], parts[3]));
        }
        return list;
    }

    @Override
    public ITestDevice.MountPointInfo getMountPointInfo(String mountpoint) throws DeviceNotAvailableException {
        List<ITestDevice.MountPointInfo> mountpoints = this.getMountPointInfo();
        for (ITestDevice.MountPointInfo info : mountpoints) {
            if (!mountpoint.equals(info.mountpoint)) continue;
            return info;
        }
        return null;
    }

    @Override
    public IFileEntry getFileEntry(String path) throws DeviceNotAvailableException {
        String[] pathComponents = path.split("/");
        if (this.mRootFile == null) {
            FileListingService service = this.getFileListingService();
            this.mRootFile = new FileEntryWrapper(this, service.getRoot());
        }
        return FileEntryWrapper.getDescendant(this.mRootFile, Arrays.asList(pathComponents));
    }

    private FileListingService getFileListingService() throws DeviceNotAvailableException {
        final FileListingService[] service = new FileListingService[1];
        DeviceAction serviceAction = new DeviceAction(){

            public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException {
                service[0] = TestDevice.this.getIDevice().getFileListingService();
                if (service[0] == null) {
                    throw new IOException("Could not get file listing service");
                }
                return true;
            }
        };
        this.performDeviceAction("getFileListingService", serviceAction, 2);
        return service[0];
    }

    @Override
    public boolean pushDir(File localFileDir, String deviceFilePath) throws DeviceNotAvailableException {
        if (!localFileDir.isDirectory()) {
            LogUtil.CLog.e("file %s is not a directory", localFileDir.getAbsolutePath());
            return false;
        }
        File[] childFiles = localFileDir.listFiles();
        if (childFiles == null) {
            LogUtil.CLog.e("Could not read files in %s", localFileDir.getAbsolutePath());
            return false;
        }
        for (File childFile : childFiles) {
            String remotePath = String.format("%s/%s", deviceFilePath, childFile.getName());
            if (childFile.isDirectory()) {
                this.executeShellCommand(String.format("mkdir %s", remotePath));
                if (this.pushDir(childFile, remotePath)) continue;
                return false;
            }
            if (!childFile.isFile() || this.pushFile(childFile, remotePath)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean syncFiles(File localFileDir, String deviceFilePath) throws DeviceNotAvailableException {
        IFileEntry remoteFileEntry;
        LogUtil.CLog.i("Syncing %s to %s on device %s", localFileDir.getAbsolutePath(), deviceFilePath, this.getSerialNumber());
        if (!localFileDir.isDirectory()) {
            LogUtil.CLog.e("file %s is not a directory", localFileDir.getAbsolutePath());
            return false;
        }
        if (!this.doesFileExist(deviceFilePath = String.format("%s/%s", deviceFilePath, localFileDir.getName()))) {
            this.executeShellCommand(String.format("mkdir %s", deviceFilePath));
        }
        if ((remoteFileEntry = this.getFileEntry(deviceFilePath)) == null) {
            LogUtil.CLog.e("Could not find remote file entry %s ", deviceFilePath);
            return false;
        }
        return this.syncFiles(localFileDir, remoteFileEntry);
    }

    private boolean syncFiles(File localFileDir, final IFileEntry remoteFileEntry) throws DeviceNotAvailableException {
        LogUtil.CLog.d("Syncing %s to %s on %s", localFileDir.getAbsolutePath(), remoteFileEntry.getFullPath(), this.getSerialNumber());
        File[] localFiles = localFileDir.listFiles(new NoHiddenFilesFilter());
        ArrayList<String> filePathsToSync = new ArrayList<String>();
        for (File localFile : localFiles) {
            IFileEntry entry = remoteFileEntry.findChild(localFile.getName());
            if (entry == null) {
                LogUtil.CLog.d("Detected missing file path %s", localFile.getAbsolutePath());
                filePathsToSync.add(localFile.getAbsolutePath());
                continue;
            }
            if (localFile.isDirectory()) {
                if (this.syncFiles(localFile, entry)) continue;
                return false;
            }
            if (!this.isNewer(localFile, entry)) continue;
            LogUtil.CLog.d("Detected newer file %s", localFile.getAbsolutePath());
            filePathsToSync.add(localFile.getAbsolutePath());
        }
        if (filePathsToSync.size() == 0) {
            LogUtil.CLog.d("No files to sync");
            return true;
        }
        final String[] files = filePathsToSync.toArray(new String[filePathsToSync.size()]);
        DeviceAction syncAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                SyncService syncService = null;
                boolean status = false;
                try {
                    syncService = TestDevice.this.getIDevice().getSyncService();
                    syncService.push(files, remoteFileEntry.getFileEntry(), SyncService.getNullProgressMonitor());
                    status = true;
                }
                catch (SyncException e) {
                    LogUtil.CLog.w("Failed to sync files to %s on device %s. Message %s", remoteFileEntry.getFullPath(), TestDevice.this.getSerialNumber(), e.getMessage());
                    throw e;
                }
                finally {
                    if (syncService != null) {
                        syncService.close();
                    }
                }
                return status;
            }
        };
        return this.performDeviceAction(String.format("sync files %s", remoteFileEntry.getFullPath()), syncAction, 2);
    }

    FileListingService.FileEntry[] getFileChildren(FileListingService.FileEntry remoteFileEntry) throws DeviceNotAvailableException {
        FileQueryAction action = new FileQueryAction(remoteFileEntry, this.getIDevice().getFileListingService());
        this.performDeviceAction("buildFileCache", action, 2);
        return action.mFileContents;
    }

    private boolean isNewer(File localFile, IFileEntry entry) {
        String entryTimeString = String.format("%s %s GMT", entry.getDate(), entry.getTime());
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm zzz");
            Date remoteDate = format.parse(entryTimeString);
            return localFile.lastModified() > remoteDate.getTime() - 60000L;
        }
        catch (ParseException e) {
            LogUtil.CLog.e("Error converting remote time stamp %s for %s on device %s", entryTimeString, entry.getFullPath(), this.getSerialNumber());
            return true;
        }
    }

    @Override
    public String executeAdbCommand(String ... cmdArgs) throws DeviceNotAvailableException {
        String[] fullCmd = this.buildAdbCommand(cmdArgs);
        AdbAction adbAction = new AdbAction(fullCmd);
        this.performDeviceAction(String.format("adb %s", cmdArgs[0]), adbAction, 2);
        return adbAction.mOutput;
    }

    @Override
    public CommandResult executeFastbootCommand(String ... cmdArgs) throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.doFastbootCommand(this.getCommandTimeout(), cmdArgs);
    }

    @Override
    public CommandResult executeLongFastbootCommand(String ... cmdArgs) throws DeviceNotAvailableException, UnsupportedOperationException {
        return this.doFastbootCommand(this.getLongCommandTimeout(), cmdArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult doFastbootCommand(long timeout, String ... cmdArgs) throws DeviceNotAvailableException, UnsupportedOperationException {
        if (!this.mFastbootEnabled) {
            throw new UnsupportedOperationException(String.format("Attempted to fastboot on device %s , but fastboot is not available. Aborting.", this.getSerialNumber()));
        }
        String[] fullCmd = this.buildFastbootCommand(cmdArgs);
        for (int i = 0; i < 2; ++i) {
            CommandResult result = new CommandResult(CommandStatus.EXCEPTION);
            this.mFastbootLock.lock();
            try {
                result = this.getRunUtil().runTimedCmd(timeout, fullCmd);
            }
            finally {
                this.mFastbootLock.unlock();
            }
            if (!this.isRecoveryNeeded(result)) {
                return result;
            }
            this.recoverDeviceFromBootloader();
        }
        throw new DeviceUnresponsiveException(String.format("Attempted fastboot %s multiple times on device %s without communication success. Aborting.", cmdArgs[0], this.getSerialNumber()));
    }

    @Override
    public boolean getUseFastbootErase() {
        return this.mOptions.getUseFastbootErase();
    }

    @Override
    public void setUseFastbootErase(boolean useFastbootErase) {
        this.mOptions.setUseFastbootErase(useFastbootErase);
    }

    @Override
    public CommandResult fastbootWipePartition(String partition) throws DeviceNotAvailableException {
        if (this.mOptions.getUseFastbootErase()) {
            return this.executeLongFastbootCommand("erase", partition);
        }
        return this.executeLongFastbootCommand("format", partition);
    }

    private boolean isRecoveryNeeded(CommandResult fastbootResult) {
        if (fastbootResult.getStatus().equals((Object)CommandStatus.TIMED_OUT)) {
            return true;
        }
        if (fastbootResult.getStderr() == null || fastbootResult.getStderr().contains("data transfer failure (Protocol error)") || fastbootResult.getStderr().contains("status read failed (No such device)")) {
            LogUtil.CLog.w("Bad fastboot response from device %s. stderr: %s. Entering recovery", this.getSerialNumber(), fastbootResult.getStderr());
            return true;
        }
        return false;
    }

    int getCommandTimeout() {
        return this.mCmdTimeout;
    }

    void setLongCommandTimeout(long timeout) {
        this.mLongCmdTimeout = timeout;
    }

    long getLongCommandTimeout() {
        return this.mLongCmdTimeout;
    }

    void setCommandTimeout(int timeout) {
        this.mCmdTimeout = timeout;
    }

    private String[] buildAdbCommand(String ... commandArgs) {
        return ArrayUtil.buildArray({"adb", "-s", this.getSerialNumber()}, commandArgs);
    }

    private String[] buildFastbootCommand(String ... commandArgs) {
        return ArrayUtil.buildArray({"fastboot", "-s", this.getSerialNumber()}, commandArgs);
    }

    private boolean performDeviceAction(String actionDescription, DeviceAction action, int retryAttempts) throws DeviceNotAvailableException {
        for (int i = 0; i < retryAttempts + 1; ++i) {
            try {
                return action.run();
            }
            catch (TimeoutException e) {
                this.logDeviceActionException(actionDescription, (Exception)((Object)e));
            }
            catch (IOException e) {
                this.logDeviceActionException(actionDescription, e);
            }
            catch (InstallException e) {
                this.logDeviceActionException(actionDescription, (Exception)((Object)e));
            }
            catch (SyncException e) {
                this.logDeviceActionException(actionDescription, (Exception)((Object)e));
                if (!e.getErrorCode().equals((Object)SyncException.SyncError.BUFFER_OVERRUN) && !e.getErrorCode().equals((Object)SyncException.SyncError.TRANSFER_PROTOCOL_ERROR)) {
                    return false;
                }
            }
            catch (AdbCommandRejectedException e) {
                this.logDeviceActionException(actionDescription, (Exception)((Object)e));
            }
            catch (ShellCommandUnresponsiveException e) {
                LogUtil.CLog.w("Device %s stopped responding when attempting %s", this.getSerialNumber(), actionDescription);
            }
            this.recoverDevice();
        }
        if (retryAttempts > 0) {
            throw new DeviceUnresponsiveException(String.format("Attempted %s multiple times on device %s without communication success. Aborting.", actionDescription, this.getSerialNumber()));
        }
        return false;
    }

    private void logDeviceActionException(String actionDescription, Exception e) {
        LogUtil.CLog.w("%s (%s) when attempting %s on device %s", e.getClass().getSimpleName(), this.getExceptionMessage(e), actionDescription, this.getSerialNumber());
    }

    private String getExceptionMessage(Exception e) {
        StringBuilder msgBuilder = new StringBuilder();
        if (e.getMessage() != null) {
            msgBuilder.append(e.getMessage());
        }
        if (e.getCause() != null) {
            msgBuilder.append(" cause: ");
            msgBuilder.append(e.getCause().getClass().getSimpleName());
            if (e.getCause().getMessage() != null) {
                msgBuilder.append(" (");
                msgBuilder.append(e.getCause().getMessage());
                msgBuilder.append(")");
            }
        }
        return msgBuilder.toString();
    }

    @Override
    public void recoverDevice() throws DeviceNotAvailableException {
        if (this.mRecoveryMode.equals((Object)ITestDevice.RecoveryMode.NONE)) {
            LogUtil.CLog.i("Skipping recovery on %s", this.getSerialNumber());
            this.getRunUtil().sleep(1000L);
            return;
        }
        LogUtil.CLog.i("Attempting recovery on %s", this.getSerialNumber());
        this.mRecovery.recoverDevice(this.mMonitor, this.mRecoveryMode.equals((Object)ITestDevice.RecoveryMode.ONLINE));
        if (this.mRecoveryMode.equals((Object)ITestDevice.RecoveryMode.AVAILABLE)) {
            this.mRecoveryMode = ITestDevice.RecoveryMode.NONE;
            if (this.isEncryptionSupported() && this.isDeviceEncrypted()) {
                this.unlockDevice();
            }
            this.postBootSetup();
            this.mRecoveryMode = ITestDevice.RecoveryMode.AVAILABLE;
        } else if (this.mRecoveryMode.equals((Object)ITestDevice.RecoveryMode.ONLINE)) {
            this.mRecoveryMode = ITestDevice.RecoveryMode.NONE;
            this.postOnlineSetup();
            this.mRecoveryMode = ITestDevice.RecoveryMode.ONLINE;
        }
        LogUtil.CLog.i("Recovery successful for %s", this.getSerialNumber());
    }

    private void recoverDeviceFromBootloader() throws DeviceNotAvailableException {
        LogUtil.CLog.i("Attempting recovery on %s in bootloader", this.getSerialNumber());
        this.mRecovery.recoverDeviceBootloader(this.mMonitor);
        LogUtil.CLog.i("Bootloader recovery successful for %s", this.getSerialNumber());
    }

    private void recoverDeviceInRecovery() throws DeviceNotAvailableException {
        LogUtil.CLog.i("Attempting recovery on %s in recovery", this.getSerialNumber());
        this.mRecovery.recoverDeviceRecovery(this.mMonitor);
        LogUtil.CLog.i("Recovery mode recovery successful for %s", this.getSerialNumber());
    }

    @Override
    public void startLogcat() {
        if (this.mLogcatReceiver != null) {
            LogUtil.CLog.d("Already capturing logcat for %s, ignoring", this.getSerialNumber());
            return;
        }
        this.mLogcatReceiver = this.createLogcatReceiver();
        this.mLogcatReceiver.start();
    }

    @Override
    public void clearLogcat() {
        if (this.mLogcatReceiver != null) {
            this.mLogcatReceiver.clear();
        }
    }

    @Override
    public InputStreamSource getLogcat() {
        if (this.mLogcatReceiver == null) {
            LogUtil.CLog.w("Not capturing logcat for %s in background, returning a logcat dump", this.getSerialNumber());
            return this.getLogcatDump();
        }
        return this.mLogcatReceiver.getLogcatData();
    }

    private InputStreamSource getLogcatDump() {
        byte[] output = new byte[]{};
        try {
            CollectingByteOutputReceiver receiver = new CollectingByteOutputReceiver();
            this.getIDevice().executeShellCommand("logcat -v threadtime -d", (IShellOutputReceiver)receiver);
            output = receiver.getOutput();
        }
        catch (IOException e) {
            LogUtil.CLog.w("Failed to get logcat dump from %s: ", this.getSerialNumber(), e.getMessage());
        }
        catch (TimeoutException e) {
            LogUtil.CLog.w("Failed to get logcat dump from %s: timeout", this.getSerialNumber());
        }
        catch (AdbCommandRejectedException e) {
            LogUtil.CLog.w("Failed to get logcat dump from %s: ", this.getSerialNumber(), e.getMessage());
        }
        catch (ShellCommandUnresponsiveException e) {
            LogUtil.CLog.w("Failed to get logcat dump from %s: ", this.getSerialNumber(), e.getMessage());
        }
        return new ByteArrayInputStreamSource(output);
    }

    @Override
    public void stopLogcat() {
        if (this.mLogcatReceiver != null) {
            this.mLogcatReceiver.stop();
            this.mLogcatReceiver = null;
        } else {
            LogUtil.CLog.w("Attempting to stop logcat when not capturing for %s", this.getSerialNumber());
        }
    }

    LogcatReceiver createLogcatReceiver() {
        return new LogcatReceiver(this, this.mOptions.getMaxLogcatFileSize(), this.mLogStartDelay);
    }

    @Override
    public InputStreamSource getBugreport() {
        CollectingByteOutputReceiver receiver = new CollectingByteOutputReceiver();
        try {
            this.executeShellCommand(BUGREPORT_CMD, receiver, 120000, 0);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Device %s became unresponsive while retrieving bugreport", this.getSerialNumber());
        }
        return new ByteArrayInputStreamSource(receiver.getOutput());
    }

    @Override
    public InputStreamSource getScreenshot() throws DeviceNotAvailableException {
        byte[] pngData;
        ScreenshotAction action = new ScreenshotAction();
        if (this.performDeviceAction("screenshot", action, 2) && (pngData = this.compressRawImageAsPng(action.mRawScreenshot)) != null) {
            return new ByteArrayInputStreamSource(pngData);
        }
        return null;
    }

    private byte[] compressRawImageAsPng(RawImage rawImage) {
        BufferedImage image = new BufferedImage(rawImage.width, rawImage.height, 2);
        int index = 0;
        int IndexInc = rawImage.bpp >> 3;
        for (int y = 0; y < rawImage.height; ++y) {
            for (int x = 0; x < rawImage.width; ++x) {
                int value = rawImage.getARGB(index);
                index += IndexInc;
                image.setRGB(x, y, value);
            }
        }
        byte[] pngData = null;
        ByteArrayOutputStream imageOut = new ByteArrayOutputStream(131072);
        try {
            if (ImageIO.write((RenderedImage)image, "png", imageOut)) {
                pngData = imageOut.toByteArray();
            } else {
                LogUtil.CLog.e("Failed to compress screenshot to png");
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to compress screenshot to png");
            LogUtil.CLog.e(e);
        }
        StreamUtil.closeStream(imageOut);
        return pngData;
    }

    @Override
    public boolean connectToWifiNetwork(String wifiSsid, String wifiPsk) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Connecting to wifi network %s on %s", wifiSsid, this.getSerialNumber());
        try {
            IWifiHelper wifi = this.createWifiHelper();
            wifi.enableWifi();
            wifi.waitForWifiState(WifiHelper.WifiState.SCANNING, WifiHelper.WifiState.COMPLETED);
            boolean added = false;
            added = wifiPsk != null ? wifi.addWpaPskNetwork(wifiSsid, wifiPsk) : wifi.addOpenNetwork(wifiSsid);
            if (!added) {
                LogUtil.CLog.e("Failed to add wifi network %s on %s", wifiSsid, this.getSerialNumber());
                return false;
            }
            if (!wifi.waitForWifiState(WifiHelper.WifiState.COMPLETED)) {
                LogUtil.CLog.e("wifi network %s failed to associate on %s", wifiSsid, this.getSerialNumber());
                return false;
            }
            if (!wifi.waitForIp(30000L)) {
                LogUtil.CLog.e("dhcp timeout when connecting to wifi network %s on %s", wifiSsid, this.getSerialNumber());
                return false;
            }
            for (int i = 0; i < 10; ++i) {
                String pingOutput = this.executeShellCommand("ping -c 1 -w 5 www.google.com");
                if (pingOutput.contains("1 packets transmitted, 1 received")) {
                    return true;
                }
                this.getRunUtil().sleep(1000L);
            }
            LogUtil.CLog.e("ping unsuccessful after connecting to wifi network %s on %s", wifiSsid, this.getSerialNumber());
            return false;
        }
        catch (TargetSetupError e) {
            LogUtil.CLog.e(e);
            return false;
        }
    }

    @Override
    public boolean disconnectFromWifi() throws DeviceNotAvailableException {
        try {
            IWifiHelper wifi = this.createWifiHelper();
            wifi.removeAllNetworks();
            wifi.disableWifi();
            return true;
        }
        catch (TargetSetupError e) {
            LogUtil.CLog.e(e);
            return false;
        }
    }

    @Override
    public String getIpAddress() throws DeviceNotAvailableException {
        try {
            IWifiHelper wifi = this.createWifiHelper();
            return wifi.getIpAddress();
        }
        catch (TargetSetupError e) {
            LogUtil.CLog.e(e);
            return null;
        }
    }

    IWifiHelper createWifiHelper() throws TargetSetupError, DeviceNotAvailableException {
        return new WifiHelper(this);
    }

    @Override
    public boolean clearErrorDialogs() throws DeviceNotAvailableException {
        for (int i = 0; i < 5; ++i) {
            int numErrorDialogs = this.getErrorDialogCount();
            if (numErrorDialogs == 0) {
                return true;
            }
            this.doClearDialogs(numErrorDialogs);
        }
        if (this.getErrorDialogCount() > 0) {
            LogUtil.CLog.e("error dialogs still exist on %s.", this.getSerialNumber());
            return false;
        }
        return true;
    }

    private int getErrorDialogCount() throws DeviceNotAvailableException {
        int errorDialogCount = 0;
        Pattern crashPattern = Pattern.compile(".*crashing=true.*AppErrorDialog.*");
        Pattern anrPattern = Pattern.compile(".*notResponding=true.*AppNotRespondingDialog.*");
        String systemStatusOutput = this.executeShellCommand("dumpsys activity processes");
        Matcher crashMatcher = crashPattern.matcher(systemStatusOutput);
        while (crashMatcher.find()) {
            ++errorDialogCount;
        }
        Matcher anrMatcher = anrPattern.matcher(systemStatusOutput);
        while (anrMatcher.find()) {
            ++errorDialogCount;
        }
        return errorDialogCount;
    }

    private void doClearDialogs(int numDialogs) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Attempted to clear %d dialogs on %s", numDialogs, this.getSerialNumber());
        for (int i = 0; i < numDialogs; ++i) {
            this.executeShellCommand(DISMISS_DIALOG_CMD);
        }
    }

    IDeviceStateMonitor getDeviceStateMonitor() {
        return this.mMonitor;
    }

    @Override
    public void postBootSetup() throws DeviceNotAvailableException {
        this.postOnlineSetup();
        if (this.mOptions.isDisableKeyguard()) {
            LogUtil.CLog.i("Attempting to disable keyguard on %s using %s", this.getSerialNumber(), this.getDisableKeyguardCmd());
            this.executeShellCommand(this.getDisableKeyguardCmd());
        }
    }

    private void postOnlineSetup() throws DeviceNotAvailableException {
        if (this.isEnableAdbRoot()) {
            this.enableAdbRoot();
        }
    }

    String getDisableKeyguardCmd() {
        return this.mOptions.getDisableKeyguardCmd();
    }

    @Override
    public void rebootIntoBootloader() throws DeviceNotAvailableException, UnsupportedOperationException {
        if (!this.mFastbootEnabled) {
            throw new UnsupportedOperationException("Fastboot is not available and cannot reboot into bootloader");
        }
        LogUtil.CLog.i("Rebooting device %s in state %s into bootloader", new Object[]{this.getSerialNumber(), this.getDeviceState()});
        if (TestDeviceState.FASTBOOT.equals((Object)this.getDeviceState())) {
            LogUtil.CLog.i("device %s already in fastboot. Rebooting anyway", this.getSerialNumber());
            this.executeFastbootCommand("reboot-bootloader");
        } else {
            LogUtil.CLog.i("Booting device %s into bootloader", this.getSerialNumber());
            this.doAdbRebootBootloader();
        }
        if (!this.mMonitor.waitForDeviceBootloader(this.mOptions.getFastbootTimeout())) {
            this.recoverDeviceFromBootloader();
        }
    }

    private void doAdbRebootBootloader() throws DeviceNotAvailableException {
        try {
            this.getIDevice().reboot("bootloader");
            return;
        }
        catch (IOException e) {
            LogUtil.CLog.w("IOException '%s' when rebooting %s into bootloader", e.getMessage(), this.getSerialNumber());
            this.recoverDeviceFromBootloader();
        }
        catch (TimeoutException e) {
            LogUtil.CLog.w("TimeoutException when rebooting %s into bootloader", this.getSerialNumber());
            this.recoverDeviceFromBootloader();
        }
        catch (AdbCommandRejectedException e) {
            LogUtil.CLog.w("AdbCommandRejectedException '%s' when rebooting %s into bootloader", e.getMessage(), this.getSerialNumber());
            this.recoverDeviceFromBootloader();
        }
    }

    @Override
    public void reboot() throws DeviceNotAvailableException {
        this.rebootUntilOnline();
        ITestDevice.RecoveryMode cachedRecoveryMode = this.getRecoveryMode();
        this.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
        if (this.isEncryptionSupported() && this.isDeviceEncrypted()) {
            this.unlockDevice();
        }
        this.setRecoveryMode(cachedRecoveryMode);
        if (this.mMonitor.waitForDeviceAvailable(this.mOptions.getRebootTimeout()) != null) {
            this.postBootSetup();
            return;
        }
        this.recoverDevice();
    }

    @Override
    public void rebootUntilOnline() throws DeviceNotAvailableException {
        this.doReboot();
        ITestDevice.RecoveryMode cachedRecoveryMode = this.getRecoveryMode();
        this.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
        if (this.mMonitor.waitForDeviceOnline() != null) {
            if (this.isEnableAdbRoot()) {
                this.enableAdbRoot();
            }
        } else {
            this.recoverDevice();
        }
        this.setRecoveryMode(cachedRecoveryMode);
    }

    @Override
    public void rebootIntoRecovery() throws DeviceNotAvailableException {
        if (TestDeviceState.FASTBOOT == this.getDeviceState()) {
            LogUtil.CLog.w("device %s in fastboot when requesting boot to recovery. Rebooting to userspace first.", this.getSerialNumber());
            this.rebootUntilOnline();
        }
        this.doAdbReboot("recovery");
        if (!this.waitForDeviceInRecovery(this.mOptions.getAdbRecoveryTimeout())) {
            this.recoverDeviceInRecovery();
        }
    }

    @Override
    public void nonBlockingReboot() throws DeviceNotAvailableException {
        this.doReboot();
    }

    void doReboot() throws DeviceNotAvailableException, UnsupportedOperationException {
        if (TestDeviceState.FASTBOOT == this.getDeviceState()) {
            LogUtil.CLog.i("device %s in fastboot. Rebooting to userspace.", this.getSerialNumber());
            this.executeFastbootCommand("reboot");
        } else {
            LogUtil.CLog.i("Rebooting device %s", this.getSerialNumber());
            this.doAdbReboot(null);
            this.waitForDeviceNotAvailable("reboot", 20000L);
        }
    }

    private void doAdbReboot(final String into) throws DeviceNotAvailableException {
        DeviceAction rebootAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException {
                TestDevice.this.getIDevice().reboot(into);
                return true;
            }
        };
        this.performDeviceAction("reboot", rebootAction, 2);
    }

    private void waitForDeviceNotAvailable(String operationDesc, long time) {
        if (!this.mMonitor.waitForDeviceNotAvailable(time)) {
            LogUtil.CLog.w("Did not detect device %s becoming unavailable after %s", this.getSerialNumber(), operationDesc);
        }
    }

    @Override
    public boolean enableAdbRoot() throws DeviceNotAvailableException {
        if (this.isAdbRoot()) {
            LogUtil.CLog.i("adb is already running as root on %s", this.getSerialNumber());
            return true;
        }
        LogUtil.CLog.i("adb root on device %s", this.getSerialNumber());
        int attempts = 3;
        for (int i = 1; i <= attempts; ++i) {
            String output = this.executeAdbCommand("root");
            this.waitForDeviceNotAvailable("root", 20000L);
            this.waitForDeviceOnline();
            if (this.isAdbRoot()) {
                return true;
            }
            LogUtil.CLog.w("'adb root' on %s unsuccessful on attempt %d of %d. Output: '%s'", this.getSerialNumber(), i, attempts, output);
        }
        return false;
    }

    @Override
    public boolean isAdbRoot() throws DeviceNotAvailableException {
        String output = this.executeShellCommand("id");
        return output.contains("uid=0(root)");
    }

    @Override
    public boolean encryptDevice(boolean inplace) throws DeviceNotAvailableException, UnsupportedOperationException {
        int timeout;
        String encryptMethod;
        if (!this.isEncryptionSupported()) {
            throw new UnsupportedOperationException(String.format("Can't encrypt device %s: encryption not supported", this.getSerialNumber()));
        }
        if (this.isDeviceEncrypted()) {
            LogUtil.CLog.d("Device %s is already encrypted, skipping", this.getSerialNumber());
            return true;
        }
        this.enableAdbRoot();
        if (inplace) {
            encryptMethod = "inplace";
            timeout = 0x6DDD00;
        } else {
            encryptMethod = "wipe";
            timeout = 300000;
        }
        LogUtil.CLog.i("Encrypting device %s via %s", this.getSerialNumber(), encryptMethod);
        this.executeShellCommand(String.format("vdc cryptfs enablecrypto %s \"%s\"", encryptMethod, ENCRYPTION_PASSWORD), (IShellOutputReceiver)new NullOutputReceiver(), timeout, 1);
        this.waitForDeviceNotAvailable("reboot", this.getCommandTimeout());
        this.waitForDeviceOnline();
        return this.isDeviceEncrypted();
    }

    @Override
    public boolean unencryptDevice() throws DeviceNotAvailableException, UnsupportedOperationException {
        String[] splitOutput;
        if (!this.isEncryptionSupported()) {
            throw new UnsupportedOperationException(String.format("Can't unencrypt device %s: encryption not supported", this.getSerialNumber()));
        }
        if (!this.isDeviceEncrypted()) {
            LogUtil.CLog.d("Device %s is already unencrypted, skipping", this.getSerialNumber());
            return true;
        }
        LogUtil.CLog.i("Unencrypting device %s", this.getSerialNumber());
        if (!this.mOptions.getUseFastbootErase()) {
            this.rebootIntoBootloader();
            this.fastbootWipePartition("userdata");
            this.reboot();
            return true;
        }
        boolean format = false;
        String output = this.executeShellCommand("vdc volume list");
        if (output != null) {
            for (String line : splitOutput = output.split("\r\n")) {
                if (!line.startsWith("110 ") || !line.contains("sdcard /mnt/sdcard") || line.endsWith("0")) continue;
                format = true;
            }
        }
        this.rebootIntoBootloader();
        this.fastbootWipePartition("userdata");
        if (this.mOptions.getUnencryptRebootTimeout() > 0) {
            this.rebootUntilOnline();
            if (this.waitForDeviceNotAvailable(this.mOptions.getUnencryptRebootTimeout())) {
                this.waitForDeviceOnline();
            }
        }
        if (format) {
            LogUtil.CLog.d("Need to format sdcard for device %s", this.getSerialNumber());
            ITestDevice.RecoveryMode cachedRecoveryMode = this.getRecoveryMode();
            this.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
            output = this.executeShellCommand("vdc volume format sdcard");
            if (output == null) {
                LogUtil.CLog.e("Command vdc volume format sdcard failed will no output for device %s:\n%s", this.getSerialNumber());
                this.setRecoveryMode(cachedRecoveryMode);
                return false;
            }
            splitOutput = output.split("\r\n");
            if (!splitOutput[splitOutput.length - 1].startsWith("200 ")) {
                LogUtil.CLog.e("Command vdc volume format sdcard failed for device %s:\n%s", this.getSerialNumber(), output);
                this.setRecoveryMode(cachedRecoveryMode);
                return false;
            }
            this.setRecoveryMode(cachedRecoveryMode);
        }
        this.reboot();
        return true;
    }

    @Override
    public boolean unlockDevice() throws DeviceNotAvailableException, UnsupportedOperationException {
        String output;
        if (!this.isEncryptionSupported()) {
            throw new UnsupportedOperationException(String.format("Can't unlock device %s: encryption not supported", this.getSerialNumber()));
        }
        if (!this.isDeviceEncrypted()) {
            LogUtil.CLog.d("Device %s is not encrypted, skipping", this.getSerialNumber());
            return true;
        }
        LogUtil.CLog.i("Unlocking device %s", this.getSerialNumber());
        this.enableAdbRoot();
        int i = 0;
        do {
            if ((output = this.executeShellCommand(String.format("vdc cryptfs checkpw \"%s\"", ENCRYPTION_PASSWORD)).trim()).startsWith("200 ") && output.endsWith(" -1")) {
                return true;
            }
            if (!(output.isEmpty() || output.startsWith("200 ") && output.endsWith(" 0"))) {
                LogUtil.CLog.e("checkpw gave output '%s' while trying to unlock device %s", output, this.getSerialNumber());
                return false;
            }
            this.getRunUtil().sleep(500L);
        } while (output.isEmpty() && ++i < 3);
        if (output.isEmpty()) {
            LogUtil.CLog.e("checkpw gave no output while trying to unlock device %s");
        }
        if (!(output = this.executeShellCommand("vdc cryptfs restart").trim()).startsWith("200 ") || !output.endsWith(" 0")) {
            LogUtil.CLog.e("restart gave output '%s' while trying to unlock device %s", output, this.getSerialNumber());
            return false;
        }
        this.waitForDeviceAvailable();
        return true;
    }

    @Override
    public boolean isDeviceEncrypted() throws DeviceNotAvailableException {
        String output = this.getPropertySync("ro.crypto.state");
        if (output == null && this.isEncryptionSupported()) {
            LogUtil.CLog.e("Property ro.crypto.state is null on device %s", this.getSerialNumber());
        }
        return "encrypted".equals(output);
    }

    @Override
    public boolean isEncryptionSupported() throws DeviceNotAvailableException {
        if (!this.isEnableAdbRoot()) {
            LogUtil.CLog.i("root is required for encryption");
            this.mIsEncryptionSupported = false;
            return this.mIsEncryptionSupported;
        }
        if (this.mIsEncryptionSupported != null) {
            return this.mIsEncryptionSupported;
        }
        this.enableAdbRoot();
        String output = this.executeShellCommand("vdc cryptfs enablecrypto").trim();
        this.mIsEncryptionSupported = output != null && output.startsWith(ENCRYPTION_SUPPORTED_CODE) && output.contains(ENCRYPTION_SUPPORTED_USAGE);
        return this.mIsEncryptionSupported;
    }

    @Override
    public void waitForDeviceOnline(long waitTime) throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceOnline(waitTime) == null) {
            this.recoverDevice();
        }
    }

    @Override
    public void waitForDeviceOnline() throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceOnline() == null) {
            this.recoverDevice();
        }
    }

    @Override
    public void waitForDeviceAvailable(long waitTime) throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceAvailable(waitTime) == null) {
            this.recoverDevice();
        }
    }

    @Override
    public void waitForDeviceAvailable() throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceAvailable() == null) {
            this.recoverDevice();
        }
    }

    @Override
    public boolean waitForDeviceNotAvailable(long waitTime) {
        return this.mMonitor.waitForDeviceNotAvailable(waitTime);
    }

    @Override
    public boolean waitForDeviceInRecovery(long waitTime) {
        return this.mMonitor.waitForDeviceInRecovery(waitTime);
    }

    private void throwIfNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    IDeviceRecovery getRecovery() {
        return this.mRecovery;
    }

    @Override
    public void setRecovery(IDeviceRecovery recovery) {
        this.throwIfNull(recovery);
        this.mRecovery = recovery;
    }

    @Override
    public void setRecoveryMode(ITestDevice.RecoveryMode mode) {
        this.throwIfNull((Object)this.mRecoveryMode);
        this.mRecoveryMode = mode;
    }

    @Override
    public ITestDevice.RecoveryMode getRecoveryMode() {
        return this.mRecoveryMode;
    }

    @Override
    public void setFastbootEnabled(boolean fastbootEnabled) {
        this.mFastbootEnabled = fastbootEnabled;
    }

    @Override
    public void setDeviceState(TestDeviceState deviceState) {
        if (!deviceState.equals((Object)this.getDeviceState())) {
            if (this.getDeviceState().equals((Object)TestDeviceState.FASTBOOT) && this.mFastbootLock.isLocked()) {
                return;
            }
            this.mState = deviceState;
            LogUtil.CLog.d("Device %s state is now %s", new Object[]{this.getSerialNumber(), deviceState});
            this.mMonitor.setState(deviceState);
        }
    }

    @Override
    public TestDeviceState getDeviceState() {
        return this.mState;
    }

    @Override
    public boolean isAdbTcp() {
        return this.mMonitor.isAdbTcp();
    }

    @Override
    public String switchToAdbTcp() throws DeviceNotAvailableException {
        String ipAddress = this.getIpAddress();
        if (ipAddress == null) {
            LogUtil.CLog.e("connectToTcp failed: Device %s doesn't have an IP", this.getSerialNumber());
            return null;
        }
        String port = "5555";
        this.executeAdbCommand("tcpip", port);
        return String.format("%s:%s", ipAddress, port);
    }

    @Override
    public boolean switchToAdbUsb() throws DeviceNotAvailableException {
        this.executeAdbCommand("usb");
        return true;
    }

    @Override
    public void setEmulatorProcess(Process p) {
        this.mEmulatorProcess = p;
    }

    @Override
    public Process getEmulatorProcess() {
        return this.mEmulatorProcess;
    }

    public boolean isEnableAdbRoot() {
        return this.mOptions.isEnableAdbRoot();
    }

    @Override
    public Set<String> getInstalledPackageNames() throws DeviceNotAvailableException {
        HashSet<String> packages = new HashSet<String>();
        String output = this.executeShellCommand(LIST_PACKAGES_CMD);
        if (output != null) {
            Matcher m = PACKAGE_REGEX.matcher(output);
            while (m.find()) {
                String packageName = m.group(1);
                packages.add(packageName);
            }
        }
        return packages;
    }

    @Override
    public TestDeviceOptions getOptions() {
        return this.mOptions;
    }

    private class ScreenshotAction
    implements DeviceAction {
        RawImage mRawScreenshot;

        private ScreenshotAction() {
        }

        public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException {
            this.mRawScreenshot = TestDevice.this.getIDevice().getScreenshot();
            return this.mRawScreenshot != null;
        }
    }

    private static class NoHiddenFilesFilter
    implements FilenameFilter {
        private NoHiddenFilesFilter() {
        }

        public boolean accept(File dir, String name) {
            return !name.startsWith(".");
        }
    }

    private class FileQueryAction
    implements DeviceAction {
        FileListingService.FileEntry[] mFileContents = null;
        private final FileListingService.FileEntry mRemoteFileEntry;
        private final FileListingService mService;

        FileQueryAction(FileListingService.FileEntry remoteFileEntry, FileListingService service) {
            TestDevice.this.throwIfNull(remoteFileEntry);
            TestDevice.this.throwIfNull(service);
            this.mRemoteFileEntry = remoteFileEntry;
            this.mService = service;
        }

        public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
            this.mFileContents = this.mService.getChildrenSync(this.mRemoteFileEntry);
            return true;
        }
    }

    private static class RunFailureListener
    extends StubTestRunListener {
        private boolean mIsRunFailure = false;

        private RunFailureListener() {
        }

        public void testRunFailed(String message) {
            this.mIsRunFailure = true;
        }

        public boolean isRunFailure() {
            return this.mIsRunFailure;
        }
    }

    private class AdbAction
    implements DeviceAction {
        String mOutput = null;
        private String[] mCmd;

        AdbAction(String[] cmd) {
            this.mCmd = cmd;
        }

        public boolean run() throws TimeoutException, IOException {
            CommandResult result = TestDevice.this.getRunUtil().runTimedCmd(TestDevice.this.getCommandTimeout(), this.mCmd);
            if (result.getStatus() == CommandStatus.EXCEPTION) {
                throw new IOException();
            }
            if (result.getStatus() == CommandStatus.TIMED_OUT) {
                throw new TimeoutException();
            }
            if (result.getStatus() == CommandStatus.FAILED) {
                throw new IOException();
            }
            this.mOutput = result.getStdout();
            return true;
        }
    }

    private static interface DeviceAction {
        public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException;
    }
}

