/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.SimpleStats;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopHelper
extends Thread {
    private static final String TOP_CMD = "top -d %d -m 10 -t";
    private static final Pattern TOP_PERCENT_PATTERN = Pattern.compile("User (\\d+)%, System (\\d+)%, IOW (\\d+)%, IRQ (\\d+)%");
    private ITestDevice mTestDevice;
    private int mDelay;
    private TopReceiver mReceiver = new TopReceiver();

    public TopHelper(ITestDevice testDevice, int delay) {
        this.mTestDevice = testDevice;
        this.mDelay = delay;
    }

    public TopHelper(ITestDevice testDevice) {
        this(testDevice, 1);
    }

    public void logToFile(File logFile) {
        this.mReceiver.logToFile(logFile);
    }

    public synchronized void cancel() {
        this.mReceiver.cancel();
    }

    public synchronized boolean isCancelled() {
        return this.mReceiver.isCancelled();
    }

    @Override
    public void run() {
        try {
            this.mTestDevice.executeShellCommand(String.format(TOP_CMD, this.mDelay), (IShellOutputReceiver)this.mReceiver);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Device %s not available: %s", this.mTestDevice.getSerialNumber(), e.getMessage());
        }
    }

    public List<TopStats> getTopStats() {
        return this.mReceiver.getTopStats();
    }

    public static Double getTotalAverage(List<TopStats> topStats) {
        return TopHelper.getAveragePercentage(topStats, PercentCategory.TOTAL);
    }

    public static Double getUserAverage(List<TopStats> topStats) {
        return TopHelper.getAveragePercentage(topStats, PercentCategory.USER);
    }

    public static Double getSystemAverage(List<TopStats> topStats) {
        return TopHelper.getAveragePercentage(topStats, PercentCategory.SYSTEM);
    }

    public static Double getIowAverage(List<TopStats> topStats) {
        return TopHelper.getAveragePercentage(topStats, PercentCategory.IOW);
    }

    public static Double getIrqAverage(List<TopStats> topStats) {
        return TopHelper.getAveragePercentage(topStats, PercentCategory.IRQ);
    }

    private static Double getAveragePercentage(List<TopStats> topStats, PercentCategory category) throws IndexOutOfBoundsException {
        SimpleStats stats = new SimpleStats();
        for (TopStats s : topStats) {
            switch (category) {
                case TOTAL: {
                    stats.add(s.mTotalPercent);
                    break;
                }
                case USER: {
                    stats.add(s.mUserPercent);
                    break;
                }
                case SYSTEM: {
                    stats.add(s.mSystemPercent);
                    break;
                }
                case IOW: {
                    stats.add(s.mIowPercent);
                    break;
                }
                case IRQ: {
                    stats.add(s.mIrqPercent);
                }
            }
        }
        return stats.mean();
    }

    TopReceiver getReceiver() {
        return this.mReceiver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TopReceiver
    extends MultiLineReceiver {
        private List<TopStats> mTopStats = new LinkedList<TopStats>();
        private boolean mIsCancelled = false;
        private File mLogFile = null;
        private BufferedWriter mLogWriter = null;

        public TopReceiver() {
            this.setTrimLine(false);
        }

        public synchronized void logToFile(File logFile) {
            try {
                this.mLogFile = logFile;
                this.mLogWriter = new BufferedWriter(new FileWriter(this.mLogFile));
            }
            catch (IOException e) {
                LogUtil.CLog.e("Error creating file: %s", e.getMessage());
                this.mLogWriter = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processNewLines(String[] lines) {
            if (this.mIsCancelled) {
                return;
            }
            TopReceiver topReceiver = this;
            synchronized (topReceiver) {
                if (this.mLogWriter != null) {
                    try {
                        for (String line : lines) {
                            this.mLogWriter.write(line + "\n");
                        }
                    }
                    catch (IOException e) {
                        LogUtil.CLog.e("Error writing to file: %s", e.getMessage());
                    }
                }
            }
            for (String line : lines) {
                line = line.trim();
                Matcher m = TOP_PERCENT_PATTERN.matcher(line);
                if (!m.matches()) continue;
                TopStats s = new TopStats();
                s.mUserPercent = Double.parseDouble(m.group(1));
                s.mSystemPercent = Double.parseDouble(m.group(2));
                s.mIowPercent = Double.parseDouble(m.group(3));
                s.mIrqPercent = Double.parseDouble(m.group(4));
                s.mTotalPercent = s.mUserPercent + s.mSystemPercent + s.mIowPercent + s.mIrqPercent;
                TopReceiver topReceiver2 = this;
                synchronized (topReceiver2) {
                    this.mTopStats.add(s);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void cancel() {
            if (this.mIsCancelled) {
                return;
            }
            this.mIsCancelled = true;
            if (this.mLogWriter != null) {
                try {
                    this.mLogWriter.flush();
                    this.mLogWriter.close();
                }
                catch (IOException e) {
                    LogUtil.CLog.e("Error closing writer %s", e.getMessage());
                }
                finally {
                    this.mLogWriter = null;
                }
            }
        }

        public synchronized boolean isCancelled() {
            return this.mIsCancelled;
        }

        public synchronized List<TopStats> getTopStats() {
            return new ArrayList<TopStats>(this.mTopStats);
        }
    }

    public static class TopStats {
        public Double mTotalPercent = null;
        public Double mUserPercent = null;
        public Double mSystemPercent = null;
        public Double mIowPercent = null;
        public Double mIrqPercent = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PercentCategory {
        TOTAL,
        USER,
        SYSTEM,
        IOW,
        IRQ;

    }
}

