/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.IWifiHelper;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WifiHelper
implements IWifiHelper {
    private static final String NULL_IP_ADDR = "0.0.0.0";
    private static final String INTERFACE_KEY = "interface";
    private static final String INSTRUMENTATION_CLASS = ".WifiUtil";
    private static final String INSTRUMENTATION_PKG = "com.android.tradefed.utils.wifi";
    static final String FULL_INSTRUMENTATION_NAME = String.format("%s/%s", "com.android.tradefed.utils.wifi", ".WifiUtil");
    private static final String CHECK_INSTRUMENTATION_CMD = String.format("pm list instrumentation %s", "com.android.tradefed.utils.wifi");
    private static final String WIFIUTIL_APK_NAME = "WifiUtil.apk";
    static final String SUCCESS_MARKER = "tHiS-iS-sUcCeSs-MaRkEr";
    private static final String WPA_STATE = "wpa_state";
    private static final long DEFAULT_WIFI_STATE_TIMEOUT = 30000L;
    private final ITestDevice mDevice;

    public WifiHelper(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        this.mDevice = device;
        this.ensureDeviceSetup();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    void ensureDeviceSetup() throws TargetSetupError, DeviceNotAvailableException {
        String inst = this.mDevice.executeShellCommand(CHECK_INSTRUMENTATION_CMD);
        if (inst != null && inst.contains(FULL_INSTRUMENTATION_NAME)) {
            return;
        }
        File apkTempFile = null;
        try {
            apkTempFile = FileUtil.createTempFile(WIFIUTIL_APK_NAME, ".apk");
            InputStream apkStream = this.getClass().getResourceAsStream(String.format("/apks/wifiutil/%s", WIFIUTIL_APK_NAME));
            FileUtil.writeToFile(apkStream, apkTempFile);
            String result = this.mDevice.installPackage(apkTempFile, false, new String[0]);
            if (result == null) {
                return;
            }
            try {
                throw new TargetSetupError(String.format("Unable to install WifiUtil utility: %s", result));
            }
            catch (IOException e) {
                throw new TargetSetupError(String.format("Failed to unpack WifiUtil utility: %s", e.getMessage()));
            }
        }
        finally {
            FileUtil.deleteFile(apkTempFile);
        }
    }

    @Override
    public void enableWifi() throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand("svc wifi enable");
    }

    @Override
    public void disableWifi() throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand("svc wifi disable");
    }

    @Override
    public boolean waitForWifiState(WifiState ... expectedStates) throws DeviceNotAvailableException {
        return this.waitForWifiState(30000L, expectedStates);
    }

    boolean waitForWifiState(long timeout, WifiState ... expectedStates) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            Map<String, String> statusMap = this.getWifiStatus();
            if (statusMap != null) {
                String state = statusMap.get(WPA_STATE);
                for (WifiState expectedState : expectedStates) {
                    if (!expectedState.name().equals(state)) continue;
                    return true;
                }
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    long getPollTime() {
        return 1000L;
    }

    Map<String, String> getWifiStatus() throws DeviceNotAvailableException {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        WpaCliOutput output = this.callWpaCli("status");
        if (!output.isSuccess()) {
            return null;
        }
        for (String line : output.mOutputLines) {
            String[] pair = line.split("=", 2);
            if (pair.length != 2) continue;
            statusMap.put(pair[0], pair[1]);
        }
        if (!statusMap.containsKey(WPA_STATE)) {
            return null;
        }
        statusMap.put(INTERFACE_KEY, output.mWpaInterface);
        return statusMap;
    }

    void removeNetwork(int networkId) throws DeviceNotAvailableException {
        this.runWifiUtil("removeNetwork", "id", Integer.toString(networkId));
    }

    @Override
    public boolean addOpenNetwork(String ssid) throws DeviceNotAvailableException {
        int id = WifiHelper.asInt(this.runWifiUtil("addOpenNetwork", "ssid", ssid));
        if (id < 0) {
            return false;
        }
        if (!WifiHelper.asBool(this.runWifiUtil("associateNetwork", "id", Integer.toString(id)))) {
            return false;
        }
        return WifiHelper.asBool(this.runWifiUtil("saveConfiguration", new String[0]));
    }

    @Override
    public boolean addWpaPskNetwork(String ssid, String psk) throws DeviceNotAvailableException {
        int id = WifiHelper.asInt(this.runWifiUtil("addWpaPskNetwork", "ssid", ssid, "psk", psk));
        if (id < 0) {
            return false;
        }
        if (!WifiHelper.asBool(this.runWifiUtil("associateNetwork", "id", Integer.toString(id)))) {
            return false;
        }
        return WifiHelper.asBool(this.runWifiUtil("saveConfiguration", new String[0]));
    }

    @Override
    public boolean waitForIp(long timeout) throws DeviceNotAvailableException {
        if (!WifiHelper.asBool(this.runWifiUtil("isWifiEnabled", new String[0]))) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + timeout) {
            String ip = this.getIpAddress();
            if (!ip.isEmpty() && !NULL_IP_ADDR.equals(this.getIpAddress())) {
                return true;
            }
            this.getRunUtil().sleep(this.getPollTime());
        }
        return false;
    }

    @Override
    public String getIpAddress() throws DeviceNotAvailableException {
        return this.runWifiUtil("getIpAddress", new String[0]);
    }

    @Override
    public void removeAllNetworks() throws DeviceNotAvailableException {
        this.runWifiUtil("removeAllNetworks", new String[0]);
    }

    private String runWifiUtil(String method, String ... args) throws DeviceNotAvailableException {
        String cmd = WifiHelper.buildWifiUtilCmd(method, args);
        WifiUtilOutput parser = new WifiUtilOutput();
        this.mDevice.executeShellCommand(cmd, (IShellOutputReceiver)parser);
        return parser.mResult;
    }

    static String buildWifiUtilCmd(String method, String ... args) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        argMap.put("method", method);
        if ((args.length & 1) == 1) {
            throw new IllegalArgumentException("args should have even length, consisting of key and value pairs");
        }
        for (int i = 0; i < args.length; i += 2) {
            argMap.put(args[i], args[i + 1]);
        }
        return WifiHelper.buildWifiUtilCmdFromMap(argMap);
    }

    static String buildWifiUtilCmdFromMap(Map<String, String> args) {
        StringBuilder sb = new StringBuilder("am instrument");
        for (Map.Entry<String, String> arg : args.entrySet()) {
            sb.append(" -e ");
            sb.append(arg.getKey());
            sb.append(" ");
            sb.append(WifiHelper.quote(arg.getValue()));
        }
        sb.append(" -w ");
        sb.append(INSTRUMENTATION_PKG);
        sb.append("/");
        sb.append(INSTRUMENTATION_CLASS);
        return sb.toString();
    }

    private static int asInt(String str) {
        if (str == null) {
            return -1;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean asBool(String str) {
        return "true".equals(str);
    }

    private static String quote(String str) {
        return String.format("\"%s\"", str);
    }

    private WpaCliOutput callWpaCli(String cmd) throws DeviceNotAvailableException {
        String fullCmd = String.format("wpa_cli %s && echo && echo %s", cmd, SUCCESS_MARKER);
        WpaCliOutput output = new WpaCliOutput();
        this.mDevice.executeShellCommand(fullCmd, (IShellOutputReceiver)output);
        return output;
    }

    private static class WifiUtilOutput
    extends MultiLineReceiver {
        private boolean mDidCommandComplete = false;
        private static final String INST_SUCCESS_MARKER = "INSTRUMENTATION_CODE: -1";
        private static final Pattern RESULT_PAT = Pattern.compile("INSTRUMENTATION_RESULT: result=(.*)");
        String mResult = null;
        List<String> mOutputLines = new ArrayList<String>();

        WifiUtilOutput() {
        }

        public void processNewLines(String[] lines) {
            if (!this.mDidCommandComplete) {
                this.mDidCommandComplete = lines[lines.length - 1].equals(INST_SUCCESS_MARKER);
            }
            for (String line : lines) {
                this.mOutputLines.add(line);
                Matcher resultMatcher = RESULT_PAT.matcher(line);
                if (!resultMatcher.matches()) continue;
                this.mResult = resultMatcher.group(1);
            }
        }

        public boolean isCancelled() {
            return false;
        }
    }

    private static class WpaCliOutput
    extends MultiLineReceiver {
        private boolean mDidCommandComplete = false;
        private boolean mIsCommandSuccess = true;
        String mWpaInterface = null;
        List<String> mOutputLines = new ArrayList<String>();

        WpaCliOutput() {
        }

        public void processNewLines(String[] lines) {
            if (!this.mDidCommandComplete) {
                this.mDidCommandComplete = lines[lines.length - 1].equals(WifiHelper.SUCCESS_MARKER);
            }
            Pattern interfacePattern = Pattern.compile("Using interface '(.*)'");
            for (String line : lines) {
                Matcher interfaceMatcher;
                this.mOutputLines.add(line);
                if (line.contains("Failed to connect to wpa_supplicant")) {
                    this.mIsCommandSuccess = false;
                }
                if (!(interfaceMatcher = interfacePattern.matcher(line)).find()) continue;
                this.mWpaInterface = interfaceMatcher.group(1);
            }
        }

        public boolean isSuccess() {
            return this.mDidCommandComplete && this.mIsCommandSuccess;
        }

        public boolean isCancelled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WifiState {
        COMPLETED,
        SCANNING,
        DISCONNECTED;

    }
}

