/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShardListener
extends CollectingTestListener {
    private ITestInvocationListener mMasterListener;

    ShardListener(ITestInvocationListener master) {
        this.mMasterListener = master;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationStarted(IBuildInfo buildInfo) {
        super.invocationStarted(buildInfo);
        ITestInvocationListener iTestInvocationListener = this.mMasterListener;
        synchronized (iTestInvocationListener) {
            this.mMasterListener.invocationStarted(buildInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationFailed(Throwable cause) {
        super.invocationFailed(cause);
        ITestInvocationListener iTestInvocationListener = this.mMasterListener;
        synchronized (iTestInvocationListener) {
            this.mMasterListener.invocationFailed(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        ITestInvocationListener iTestInvocationListener = this.mMasterListener;
        synchronized (iTestInvocationListener) {
            this.mMasterListener.testLog(dataName, dataType, dataStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationEnded(long elapsedTime) {
        super.invocationEnded(elapsedTime);
        ITestInvocationListener iTestInvocationListener = this.mMasterListener;
        synchronized (iTestInvocationListener) {
            for (TestRunResult runResult : this.getRunResults()) {
                this.mMasterListener.testRunStarted(runResult.getName(), runResult.getNumTests());
                this.forwardTestResults(runResult.getTestResults());
                if (runResult.isRunFailure()) {
                    this.mMasterListener.testRunFailed(runResult.getRunFailureMessage());
                }
                this.mMasterListener.testRunEnded(runResult.getElapsedTime(), runResult.getRunMetrics());
            }
            this.mMasterListener.invocationEnded(elapsedTime);
        }
    }

    private void forwardTestResults(Map<TestIdentifier, TestResult> testResults) {
        for (Map.Entry<TestIdentifier, TestResult> testEntry : testResults.entrySet()) {
            this.mMasterListener.testStarted(testEntry.getKey());
            if (testEntry.getValue().getStatus().equals((Object)TestResult.TestStatus.ERROR)) {
                this.mMasterListener.testFailed(ITestRunListener.TestFailure.ERROR, testEntry.getKey(), testEntry.getValue().getStackTrace());
            } else if (testEntry.getValue().getStatus().equals((Object)TestResult.TestStatus.FAILURE)) {
                this.mMasterListener.testFailed(ITestRunListener.TestFailure.FAILURE, testEntry.getKey(), testEntry.getValue().getStackTrace());
            }
            if (testEntry.getValue().getStatus().equals((Object)TestResult.TestStatus.INCOMPLETE)) continue;
            this.mMasterListener.testEnded(testEntry.getKey(), testEntry.getValue().getMetrics());
        }
    }
}

