/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.ExistingBuildProvider;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.invoker.ShardListener;
import com.android.tradefed.invoker.ShardMasterResultForwarder;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.ILogRegistry;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.InvocationSummaryHelper;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IResumableTest;
import com.android.tradefed.testtype.IShardableTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestInvocation
implements ITestInvocation {
    static final String TRADEFED_LOG_NAME = "host_log";
    static final String DEVICE_LOG_NAME = "device_logcat";
    static final String BUILD_ERROR_BUGREPORT_NAME = "build_error_bugreport";
    private String mStatus = "(not invoked)";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invoke(ITestDevice device, IConfiguration config, IRescheduler rescheduler) throws DeviceNotAvailableException {
        try {
            this.mStatus = "fetching build";
            config.getLogOutput().init();
            this.getLogRegistry().registerLogger(config.getLogOutput());
            IBuildInfo info = config.getBuildProvider().getBuild();
            if (info != null) {
                this.injectBuild(info, config.getTests());
                if (!this.shardConfig(config, info, rescheduler)) {
                    device.setRecovery(config.getDeviceRecovery());
                    this.performInvocation(config, device, info, rescheduler);
                    return;
                }
                LogUtil.CLog.i("Invocation for %s has been sharded, rescheduling", device.getSerialNumber());
            } else {
                this.mStatus = "(no build to test)";
                LogUtil.CLog.d("No build to test");
            }
        }
        catch (BuildRetrievalError e) {
            LogUtil.CLog.e(e);
            this.startInvocation(config, device, e.getBuildInfo());
            Iterator<ITestInvocationListener> i$ = config.getTestInvocationListeners().iterator();
            while (true) {
                if (!i$.hasNext()) {
                    this.reportLogs(device, config.getTestInvocationListeners(), config.getLogOutput());
                    InvocationSummaryHelper.reportInvocationEnded(config.getTestInvocationListeners(), 0L);
                    return;
                }
                ITestInvocationListener listener = i$.next();
                listener.invocationFailed(e);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
        this.getLogRegistry().dumpToGlobalLog(config.getLogOutput());
        this.getLogRegistry().unregisterLogger();
        config.getLogOutput().closeLog();
    }

    private void injectBuild(IBuildInfo buildInfo, List<IRemoteTest> tests) {
        for (IRemoteTest test : tests) {
            if (!(test instanceof IBuildReceiver)) continue;
            ((IBuildReceiver)((Object)test)).setBuild(buildInfo);
        }
    }

    private boolean shardConfig(IConfiguration config, IBuildInfo info, IRescheduler rescheduler) {
        this.mStatus = "sharding";
        ArrayList<IRemoteTest> shardableTests = new ArrayList<IRemoteTest>();
        boolean isSharded = false;
        for (IRemoteTest test : config.getTests()) {
            isSharded |= this.shardTest(shardableTests, test);
        }
        if (isSharded) {
            ShardMasterResultForwarder resultCollector = new ShardMasterResultForwarder(config.getTestInvocationListeners(), shardableTests.size());
            ShardListener origConfigListener = new ShardListener(resultCollector);
            config.setTestInvocationListener(origConfigListener);
            resultCollector.invocationStarted(info);
            for (IRemoteTest testShard : shardableTests) {
                LogUtil.CLog.i("Rescheduling sharded config...");
                IConfiguration shardConfig = config.clone();
                shardConfig.setTest(testShard);
                shardConfig.setBuildProvider(new ExistingBuildProvider(info.clone(), config.getBuildProvider()));
                shardConfig.setTestInvocationListener(new ShardListener(resultCollector));
                shardConfig.setLogOutput(config.getLogOutput().clone());
                shardConfig.setCommandOptions(config.getCommandOptions().clone());
                rescheduler.scheduleConfig(shardConfig);
            }
            config.getBuildProvider().cleanUp(info);
            return true;
        }
        return false;
    }

    private boolean shardTest(List<IRemoteTest> shardableTests, IRemoteTest test) {
        IShardableTest shardableTest;
        Collection<IRemoteTest> shards;
        boolean isSharded = false;
        if (test instanceof IShardableTest && (shards = (shardableTest = (IShardableTest)test).split()) != null) {
            shardableTests.addAll(shards);
            isSharded = true;
        }
        if (!isSharded) {
            shardableTests.add(test);
        }
        return isSharded;
    }

    private void logStartInvocation(IBuildInfo info, ITestDevice device) {
        StringBuilder msg = new StringBuilder("Starting invocation for '");
        msg.append(info.getTestTag());
        msg.append("'");
        if (!info.getBuildId().equals("-1")) {
            msg.append(" on build '");
            msg.append(info.getBuildId());
            msg.append("'");
        }
        for (String buildAttr : info.getBuildAttributes().values()) {
            msg.append(" ");
            msg.append(buildAttr);
        }
        msg.append(" on device ");
        msg.append(device.getSerialNumber());
        LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, msg.toString(), new Object[0]);
        this.mStatus = String.format("running %s on build %s", info.getTestTag(), info.getBuildId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInvocation(IConfiguration config, ITestDevice device, IBuildInfo info, IRescheduler rescheduler) throws DeviceNotAvailableException, IOException {
        boolean resumed = false;
        long startTime = System.currentTimeMillis();
        long elapsedTime = -1L;
        info.setDeviceSerial(device.getSerialNumber());
        this.startInvocation(config, device, info);
        try {
            device.setOptions(config.getDeviceOptions());
            for (ITargetPreparer preparer : config.getTargetPreparers()) {
                preparer.setUp(device, info);
            }
            this.runTests(device, info, config, rescheduler);
        }
        catch (BuildError e) {
            LogUtil.CLog.w("Build %s failed on device %s. Reason: %s", info.getBuildId(), device.getSerialNumber(), e.toString());
            this.takeBugreport(device, config.getTestInvocationListeners());
            this.reportFailure(e, config.getTestInvocationListeners(), config.getBuildProvider(), info);
        }
        catch (TargetSetupError e) {
            LogUtil.CLog.e("Caught exception while running invocation");
            LogUtil.CLog.e(e);
            this.reportFailure(e, config.getTestInvocationListeners(), config.getBuildProvider(), info);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.w("Invocation did not complete due to device %s becoming not available. Reason: %s", device.getSerialNumber(), e.getMessage());
            resumed = this.resume(config, info, rescheduler, System.currentTimeMillis() - startTime);
            if (!resumed) {
                this.reportFailure(e, config.getTestInvocationListeners(), config.getBuildProvider(), info);
            } else {
                LogUtil.CLog.i("Rescheduled failed invocation for resume");
            }
            throw e;
        }
        catch (RuntimeException e) {
            LogUtil.CLog.w("Unexpected exception when running invocation: %s", e.toString());
            this.reportFailure(e, config.getTestInvocationListeners(), config.getBuildProvider(), info);
            throw e;
        }
        finally {
            this.mStatus = "done running tests";
            try {
                this.reportLogs(device, config.getTestInvocationListeners(), config.getLogOutput());
                elapsedTime = System.currentTimeMillis() - startTime;
                if (!resumed) {
                    InvocationSummaryHelper.reportInvocationEnded(config.getTestInvocationListeners(), elapsedTime);
                }
            }
            finally {
                config.getBuildProvider().cleanUp(info);
            }
        }
    }

    private void startInvocation(IConfiguration config, ITestDevice device, IBuildInfo info) {
        this.logStartInvocation(info, device);
        for (ITestInvocationListener listener : config.getTestInvocationListeners()) {
            try {
                listener.invocationStarted(info);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Caught runtime exception from ITestInvocationListener");
                LogUtil.CLog.e(e);
            }
        }
    }

    private boolean resume(IConfiguration config, IBuildInfo info, IRescheduler rescheduler, long elapsedTime) {
        for (IRemoteTest test : config.getTests()) {
            IResumableTest resumeTest;
            if (!(test instanceof IResumableTest) || !(resumeTest = (IResumableTest)test).isResumable()) continue;
            IConfiguration resumeConfig = config.clone();
            IBuildInfo clonedBuild = info.clone();
            resumeConfig.setBuildProvider(new ExistingBuildProvider(clonedBuild, config.getBuildProvider()));
            resumeConfig.setTestInvocationListener(new ResumeResultForwarder(config.getTestInvocationListeners(), elapsedTime));
            resumeConfig.setLogOutput(config.getLogOutput().clone());
            resumeConfig.setCommandOptions(config.getCommandOptions().clone());
            boolean canReschedule = rescheduler.scheduleConfig(resumeConfig);
            if (!canReschedule) {
                LogUtil.CLog.i("Cannot reschedule resumed config for build %s. Cleaning up build.", info.getBuildId());
                resumeConfig.getBuildProvider().cleanUp(clonedBuild);
            }
            return canReschedule;
        }
        return false;
    }

    private void reportFailure(Throwable exception, List<ITestInvocationListener> listeners, IBuildProvider buildProvider, IBuildInfo info) {
        for (ITestInvocationListener listener : listeners) {
            listener.invocationFailed(exception);
        }
        if (!(exception instanceof BuildError)) {
            buildProvider.buildNotTested(info);
        }
    }

    private void reportLogs(ITestDevice device, List<ITestInvocationListener> listeners, ILeveledLogOutput logger) {
        InputStreamSource logcatSource = null;
        InputStreamSource globalLogSource = logger.getLog();
        if (device != null) {
            logcatSource = device.getLogcat();
        }
        for (ITestInvocationListener listener : listeners) {
            if (logcatSource != null) {
                listener.testLog(DEVICE_LOG_NAME, LogDataType.TEXT, logcatSource);
            }
            listener.testLog(TRADEFED_LOG_NAME, LogDataType.TEXT, globalLogSource);
        }
        if (logcatSource != null) {
            logcatSource.cancel();
        }
        globalLogSource.cancel();
        this.getLogRegistry().unregisterLogger();
        logger.closeLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeBugreport(ITestDevice device, List<ITestInvocationListener> listeners) {
        if (device == null) {
            return;
        }
        InputStreamSource bugreport = device.getBugreport();
        try {
            for (ITestInvocationListener listener : listeners) {
                listener.testLog(BUILD_ERROR_BUGREPORT_NAME, LogDataType.TEXT, bugreport);
            }
        }
        finally {
            bugreport.cancel();
        }
    }

    ILogRegistry getLogRegistry() {
        return LogRegistry.getLogRegistry();
    }

    private void runTests(ITestDevice device, IBuildInfo buildInfo, IConfiguration config, IRescheduler rescheduler) throws DeviceNotAvailableException {
        List<ITestInvocationListener> listeners = config.getTestInvocationListeners();
        for (IRemoteTest test : config.getTests()) {
            if (test instanceof IDeviceTest) {
                ((IDeviceTest)((Object)test)).setDevice(device);
            }
            test.run(new ResultForwarder(listeners));
        }
    }

    public String toString() {
        return this.mStatus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResumeResultForwarder
    extends ResultForwarder {
        long mCurrentElapsedTime;

        public ResumeResultForwarder(List<ITestInvocationListener> listeners, long currentElapsedTime) {
            super(listeners);
            this.mCurrentElapsedTime = currentElapsedTime;
        }

        @Override
        public void invocationStarted(IBuildInfo buildInfo) {
        }

        @Override
        public void invocationEnded(long newElapsedTime) {
            super.invocationEnded(this.mCurrentElapsedTime + newElapsedTime);
        }
    }
}

