/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import java.io.IOException;
import java.io.OutputStream;
import jline.ConsoleReader;

public class ConsoleReaderOutputStream
extends OutputStream {
    private static final String ANSI_CR = "\u001b[2K\r";
    private static final String CR = "\r";
    private final ConsoleReader mConsoleReader;
    private boolean mInAsyncMode = false;

    public ConsoleReaderOutputStream(ConsoleReader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this.mConsoleReader = reader;
    }

    public void setSyncMode() {
        this.mInAsyncMode = false;
    }

    public void setAsyncMode() {
        this.mInAsyncMode = true;
    }

    public ConsoleReader getConsoleReader() {
        return this.mConsoleReader;
    }

    public synchronized void flush() {
        try {
            this.mConsoleReader.flushConsole();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        boolean shufflePrompt;
        boolean bl = shufflePrompt = this.mInAsyncMode && b[off + len - 1] == 10;
        if (shufflePrompt) {
            if (this.mConsoleReader.getTerminal().isANSISupported()) {
                this.mConsoleReader.printString(ANSI_CR);
            } else {
                this.mConsoleReader.printString(CR);
            }
        }
        this.mConsoleReader.printString(new String(b, off, len));
        if (shufflePrompt) {
            this.mConsoleReader.drawLine();
            this.mConsoleReader.flushConsole();
        }
    }

    public synchronized void write(int b) throws IOException {
        char[] str = new char[]{(char)(b & 0xFF)};
        this.mConsoleReader.printString(new String(str));
    }
}

