/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="file")
public class FileLogger
implements ILeveledLogOutput {
    private static final String TEMP_FILE_PREFIX = "tradefed_log_";
    private static final String TEMP_FILE_SUFFIX = ".txt";
    private File mTempLogFile = null;
    private BufferedWriter mLogWriter = null;
    @Option(name="log-level", description="the minimum log level to log.")
    private Log.LogLevel mLogLevel = Log.LogLevel.DEBUG;
    @Option(name="log-level-display", shortName=108, description="the minimum log level to display on stdout.", importance=Option.Importance.ALWAYS)
    private Log.LogLevel mLogLevelDisplay = Log.LogLevel.ERROR;
    @Option(name="log-tag-display", description="Always display given tags logs on stdout")
    private Collection<String> mLogTagsDisplay = new HashSet<String>();
    private StackTraceElement[] mCloseStackFrames = null;

    void addLogTagsDisplay(Collection<String> tags) {
        this.mLogTagsDisplay.addAll(tags);
    }

    @Override
    public void init() throws IOException {
        try {
            this.mTempLogFile = FileUtil.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.mLogWriter = new BufferedWriter(new FileWriter(this.mTempLogFile));
        }
        catch (IOException e) {
            if (this.mTempLogFile != null) {
                this.mTempLogFile.delete();
            }
            throw e;
        }
    }

    @Override
    public ILeveledLogOutput clone() {
        FileLogger logger = new FileLogger();
        logger.setLogLevelDisplay(this.mLogLevelDisplay);
        logger.setLogLevel(this.mLogLevel);
        logger.addLogTagsDisplay(this.mLogTagsDisplay);
        return logger;
    }

    public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
        this.internalPrintLog(logLevel, tag, message, true);
    }

    public void printLog(Log.LogLevel logLevel, String tag, String message) {
        this.internalPrintLog(logLevel, tag, message, false);
    }

    private void internalPrintLog(Log.LogLevel logLevel, String tag, String message, boolean forceStdout) {
        String outMessage = LogUtil.getLogFormatString(logLevel, tag, message);
        if (forceStdout || logLevel.getPriority() >= this.mLogLevelDisplay.getPriority() || this.mLogTagsDisplay.contains(tag)) {
            System.out.print(outMessage);
        }
        try {
            this.writeToLog(outMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void writeToLog(String outMessage) throws IOException {
        if (this.mLogWriter != null) {
            this.mLogWriter.write(outMessage);
        }
    }

    @Override
    public Log.LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    @Override
    public void setLogLevel(Log.LogLevel logLevel) {
        this.mLogLevel = logLevel;
    }

    void setLogLevelDisplay(Log.LogLevel logLevel) {
        this.mLogLevelDisplay = logLevel;
    }

    Log.LogLevel getLogLevelDisplay() {
        return this.mLogLevelDisplay;
    }

    String getFilename() throws SecurityException {
        if (this.mTempLogFile == null) {
            throw new IllegalStateException("logger has already been closed or has not been initialized");
        }
        return this.mTempLogFile.getAbsolutePath();
    }

    @Override
    public InputStreamSource getLog() {
        if (this.mLogWriter == null) {
            System.err.println(String.format("logger has already been closed or has not been initialized, Thread %s", Thread.currentThread().getName()));
            System.err.println("Current stack:");
            this.printStackTrace(Thread.currentThread().getStackTrace());
            System.err.println("\nLog closed at:");
            this.printStackTrace(this.mCloseStackFrames);
        } else {
            try {
                this.mLogWriter.flush();
                return new SnapshotInputStreamSource(new FileInputStream(this.mTempLogFile));
            }
            catch (IOException e) {
                System.err.println("Failed to get log");
                e.printStackTrace();
            }
        }
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    private void printStackTrace(StackTraceElement[] trace) {
        if (trace == null) {
            System.err.println("no stack");
            return;
        }
        for (StackTraceElement element : trace) {
            System.err.println("\tat " + element);
        }
    }

    @Override
    public void closeLog() {
        try {
            this.doCloseLog();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCloseLog() throws IOException {
        try {
            if (this.mLogWriter != null) {
                this.mCloseStackFrames = Thread.currentThread().getStackTrace();
                BufferedWriter writer = this.mLogWriter;
                this.mLogWriter = null;
                writer.flush();
                writer.close();
            }
        }
        finally {
            if (this.mTempLogFile != null) {
                this.mTempLogFile.delete();
                this.mTempLogFile = null;
            }
        }
    }

    void dumpToLog(InputStream inputStream) throws IOException {
        if (this.mLogWriter != null) {
            StreamUtil.copyStreamToWriter(inputStream, this.mLogWriter);
        }
    }
}

