/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogUtil {
    private LogUtil() {
    }

    public static void printLog(Log.LogLevel logLevel, String tag, String message) {
        System.out.print(LogUtil.getLogFormatString(logLevel, tag, message));
    }

    public static String getLogFormatString(Log.LogLevel logLevel, String tag, String message) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
        return String.format("%s %c/%s: %s\n", formatter.format(new Date()), Character.valueOf(logLevel.getPriorityLetter()), tag, message);
    }

    public static class CLog {
        public static void v(String message) {
            Log.v((String)CLog.getClassName(2), (String)message);
        }

        public static void v(String format, Object ... args) {
            Log.v((String)CLog.getClassName(2), (String)String.format(format, args));
        }

        public static void d(String message) {
            Log.d((String)CLog.getClassName(2), (String)message);
        }

        public static void d(String format, Object ... args) {
            Log.d((String)CLog.getClassName(2), (String)String.format(format, args));
        }

        public static void i(String message) {
            Log.i((String)CLog.getClassName(2), (String)message);
        }

        public static void i(String format, Object ... args) {
            Log.i((String)CLog.getClassName(2), (String)String.format(format, args));
        }

        public static void w(String message) {
            Log.w((String)CLog.getClassName(2), (String)message);
        }

        public static void w(String format, Object ... args) {
            Log.w((String)CLog.getClassName(2), (String)String.format(format, args));
        }

        public static void e(String message) {
            Log.e((String)CLog.getClassName(2), (String)message);
        }

        public static void e(String format, Object ... args) {
            Log.e((String)CLog.getClassName(2), (String)String.format(format, args));
        }

        public static void e(Throwable t) {
            Log.e((String)CLog.getClassName(2), (Throwable)t);
        }

        public static void logAndDisplay(Log.LogLevel logLevel, String format, Object ... args) {
            Log.logAndDisplay((Log.LogLevel)logLevel, (String)CLog.getClassName(2), (String)String.format(format, args));
        }

        public static String getClassName(int frame) {
            StackTraceElement[] frames = new Throwable().getStackTrace();
            String fullName = frames[frame].getClassName();
            Class<?> klass = null;
            try {
                klass = Class.forName(fullName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (klass == null) {
                return fullName;
            }
            return klass.getSimpleName();
        }
    }
}

