/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import java.io.IOException;

@OptionClass(alias="stdout")
public class StdoutLogger
implements ILeveledLogOutput {
    @Option(name="log-level", description="minimum log level to display.", importance=Option.Importance.ALWAYS)
    private Log.LogLevel mLogLevel = Log.LogLevel.INFO;

    public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
        this.printLog(logLevel, tag, message);
    }

    public void printLog(Log.LogLevel logLevel, String tag, String message) {
        LogUtil.printLog(logLevel, tag, message);
    }

    public void setLogLevel(Log.LogLevel logLevel) {
        this.mLogLevel = logLevel;
    }

    public Log.LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    public void closeLog() {
    }

    public InputStreamSource getLog() {
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    public ILeveledLogOutput clone() {
        return new StdoutLogger();
    }

    public void init() throws IOException {
    }
}

