/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TestSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugreportCollector
implements ITestInvocationListener {
    public static final Predicate AFTER_FAILED_TESTCASES = BugreportCollector.p(Relation.AFTER, Freq.EACH, Noun.FAILED_TESTCASE);
    public static final Predicate AT_START = BugreportCollector.p(Relation.AT_START_OF, Freq.EACH, Noun.INVOCATION);
    private CollectingTestListener mCollector = new CollectingTestListener();
    private ITestInvocationListener mListener;
    private ITestDevice mTestDevice;
    private List<Predicate> mPredicates = new LinkedList<Predicate>();
    private boolean mAsynchronous = false;
    private boolean mCapturedBugreport = false;
    private int mDeviceWaitTimeSecs = -1;
    private String mDescriptiveName = null;
    private int mNumFailedRuns = 0;

    public BugreportCollector(ITestInvocationListener listener, ITestDevice testDevice) {
        if (listener == null) {
            throw new NullPointerException("listener must be non-null.");
        }
        if (testDevice == null) {
            throw new NullPointerException("device must be non-null.");
        }
        this.mListener = listener;
        this.mTestDevice = testDevice;
    }

    public void addPredicate(Predicate p) {
        this.mPredicates.add(p);
    }

    public void setDeviceWaitTime(int waitTime) {
        this.mDeviceWaitTimeSecs = waitTime;
    }

    public void blockUntilIdle() {
    }

    public void setAsynchronous(boolean asynchronous) {
        this.mAsynchronous = asynchronous;
    }

    public void setDescriptiveName(String name) {
        this.mDescriptiveName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grabBugreport(String logDesc) {
        LogUtil.CLog.v("About to grab bugreport for %s; custom name is %s.", logDesc, this.mDescriptiveName);
        if (this.mDescriptiveName != null) {
            logDesc = this.mDescriptiveName;
        }
        String logName = String.format("bug-%s.%d", logDesc, System.currentTimeMillis());
        LogUtil.CLog.v("Log name is %s", logName);
        if (this.mDeviceWaitTimeSecs >= 0) {
            try {
                this.mTestDevice.waitForDeviceOnline((long)this.mDeviceWaitTimeSecs * 1000L);
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e("Caught DeviceNotAvailableException while trying to capture bugreport");
                LogUtil.CLog.e(e);
            }
        }
        InputStreamSource bugreport = this.mTestDevice.getBugreport();
        try {
            this.mListener.testLog(logName, LogDataType.TEXT, bugreport);
        }
        finally {
            bugreport.cancel();
        }
    }

    Predicate getPredicate(Predicate predicate) {
        for (Predicate p : this.mPredicates) {
            if (!p.partialMatch(predicate)) continue;
            return p;
        }
        return null;
    }

    Predicate search(Relation relation, Collection<Freq> freqs, Noun noun) {
        for (Predicate pred : this.mPredicates) {
            for (Freq freq : freqs) {
                LogUtil.CLog.v("Search checking predicate %s", BugreportCollector.p(relation, freq, noun));
                if (!pred.partialMatch(BugreportCollector.p(relation, freq, noun))) continue;
                return pred;
            }
        }
        return null;
    }

    boolean check(Relation relation, Noun noun) {
        return this.check(relation, noun, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean check(Relation relation, Noun noun, TestIdentifier test) {
        ArrayList<Freq> applicableFreqs = new ArrayList<Freq>(2);
        applicableFreqs.add(Freq.EACH);
        TestRunResult curResult = this.mCollector.getCurrentRunResults();
        switch (relation) {
            case AFTER: {
                switch (noun) {
                    case TESTCASE: {
                        if (curResult.getNumTests() != 1) break;
                        applicableFreqs.add(Freq.FIRST);
                        break;
                    }
                    case FAILED_TESTCASE: {
                        if (curResult.getNumFailedTests() + curResult.getNumErrorTests() != 1) break;
                        applicableFreqs.add(Freq.FIRST);
                        break;
                    }
                    case TESTRUN: {
                        if (this.mCollector.getRunResults().size() != 1) break;
                        applicableFreqs.add(Freq.FIRST);
                        break;
                    }
                    case FAILED_TESTRUN: {
                        if (this.mNumFailedRuns != 1) break;
                        applicableFreqs.add(Freq.FIRST);
                        break;
                    }
                }
                break;
            }
            case AT_START_OF: {
                switch (noun) {
                    case TESTCASE: {
                        if (curResult.getNumTests() != 1) break;
                        applicableFreqs.add(Freq.FIRST);
                        break;
                    }
                    case TESTRUN: {
                        if (this.mCollector.getRunResults().size() != 1) break;
                        applicableFreqs.add(Freq.FIRST);
                    }
                }
                break;
            }
        }
        Predicate storedP = this.search(relation, applicableFreqs, noun);
        if (storedP == null) {
            return false;
        }
        LogUtil.CLog.v("Found storedP %s for relation %s and noun %s", storedP, relation, noun);
        String desc = storedP.toString();
        if (test != null) {
            String testName = String.format("%s__%s", test.getClassName(), test.getTestName());
            switch (noun) {
                case TESTCASE: {
                    desc = testName;
                    break;
                }
                case FAILED_TESTCASE: {
                    desc = String.format("FAILED-%s", testName);
                    break;
                }
            }
        }
        LogUtil.CLog.v("Grabbing bugreport.");
        this.grabBugreport(desc);
        this.mCapturedBugreport = true;
        return true;
    }

    void reset() {
        this.mCapturedBugreport = false;
    }

    private static Predicate p(Relation rp, Freq fp, Noun n) throws IllegalArgumentException {
        return new Predicate(rp, fp, n);
    }

    private static Predicate p(Relation rp, Freq fp, Noun fpN, Filter filterP, Noun filterPN) throws IllegalArgumentException {
        return new Predicate(rp, fp, fpN, filterP, filterPN);
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        this.mListener.testEnded(test, testMetrics);
        this.mCollector.testEnded(test, testMetrics);
        this.check(Relation.AFTER, Noun.TESTCASE, test);
        this.reset();
    }

    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
        this.mListener.testFailed(status, test, trace);
        this.mCollector.testFailed(status, test, trace);
        this.check(Relation.AFTER, Noun.FAILED_TESTCASE, test);
        this.reset();
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        this.mListener.testRunEnded(elapsedTime, runMetrics);
        this.mCollector.testRunEnded(elapsedTime, runMetrics);
        this.check(Relation.AFTER, Noun.TESTRUN);
    }

    public void testRunFailed(String errorMessage) {
        this.mListener.testRunFailed(errorMessage);
        this.mCollector.testRunFailed(errorMessage);
        this.check(Relation.AFTER, Noun.FAILED_TESTRUN);
    }

    public void testRunStarted(String runName, int testCount) {
        this.mListener.testRunStarted(runName, testCount);
        this.mCollector.testRunStarted(runName, testCount);
        this.check(Relation.AT_START_OF, Noun.TESTRUN);
    }

    public void testRunStopped(long elapsedTime) {
        this.mListener.testRunStopped(elapsedTime);
        this.mCollector.testRunStopped(elapsedTime);
    }

    public void testStarted(TestIdentifier test) {
        this.mListener.testStarted(test);
        this.mCollector.testStarted(test);
        this.check(Relation.AT_START_OF, Noun.TESTCASE, test);
    }

    @Override
    public void invocationStarted(IBuildInfo buildInfo) {
        this.mListener.invocationStarted(buildInfo);
        this.mCollector.invocationStarted(buildInfo);
        this.check(Relation.AT_START_OF, Noun.INVOCATION);
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        this.mListener.testLog(dataName, dataType, dataStream);
        this.mCollector.testLog(dataName, dataType, dataStream);
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        this.mListener.invocationEnded(elapsedTime);
        this.mCollector.invocationEnded(elapsedTime);
        this.check(Relation.AFTER, Noun.INVOCATION);
    }

    @Override
    public void invocationFailed(Throwable cause) {
        this.mListener.invocationFailed(cause);
        this.mCollector.invocationFailed(cause);
        this.check(Relation.AFTER, Noun.FAILED_INVOCATION);
    }

    @Override
    public TestSummary getSummary() {
        return this.mListener.getSummary();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Predicate {
        List<SubPredicate> mSubPredicates = new ArrayList<SubPredicate>(3);
        List<SubPredicate> mFilterSubPredicates = null;

        public Predicate(Relation rp, Freq fp, Noun n) throws IllegalArgumentException {
            Predicate.assertValidPredicate(rp, fp, n);
            this.mSubPredicates.add(rp);
            this.mSubPredicates.add(fp);
            this.mSubPredicates.add(n);
        }

        public Predicate(Relation rp, Freq fp, Noun fpN, Filter filterP, Noun filterPN) throws IllegalArgumentException {
            this.mSubPredicates.add(rp);
            this.mSubPredicates.add(fp);
            this.mSubPredicates.add(fpN);
            this.mFilterSubPredicates = new ArrayList<SubPredicate>(2);
            this.mFilterSubPredicates.add(filterP);
            this.mFilterSubPredicates.add(filterPN);
        }

        public static void assertValidPredicate(Relation rp, Freq fp, Noun n) throws IllegalArgumentException {
            if (rp == Relation.AT_START_OF && (n == Noun.FAILED_TESTCASE || n == Noun.FAILED_TESTRUN || n == Noun.FAILED_INVOCATION)) {
                throw new IllegalArgumentException(String.format("Illegal predicate: %s %s isn't valid since we can only check failure on the AFTER event.", fp, n));
            }
            if ((n == Noun.INVOCATION || n == Noun.FAILED_INVOCATION) && fp == Freq.FIRST) {
                throw new IllegalArgumentException(String.format("Illegal predicate: Since there is only one invocation, please use %s %s rather than %s %s for disambiguation.", Freq.EACH, n, fp, n));
            }
        }

        protected List<SubPredicate> getPredicate() {
            return this.mSubPredicates;
        }

        protected List<SubPredicate> getFilterPredicate() {
            return this.mFilterSubPredicates;
        }

        public boolean partialMatch(Predicate otherP) {
            return ((Object)this.mSubPredicates).equals(otherP.getPredicate());
        }

        public boolean fullMatch(Predicate otherP) {
            if (this.partialMatch(otherP)) {
                if (this.mFilterSubPredicates == null) {
                    return otherP.getFilterPredicate() == null;
                }
                return ((Object)this.mFilterSubPredicates).equals(otherP.getFilterPredicate());
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            ListIterator<SubPredicate> iter = this.mSubPredicates.listIterator();
            while (iter.hasNext()) {
                SubPredicate p = iter.next();
                sb.append(p.toString());
                if (!iter.hasNext()) continue;
                sb.append("_");
            }
            return sb.toString();
        }

        public boolean equals(Object other) {
            if (other instanceof Predicate) {
                Predicate otherP = (Predicate)other;
                return this.fullMatch(otherP);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.mSubPredicates).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Filter implements SubPredicate
    {
        WITH_FAILING,
        WITH_PASSING,
        WITH_ANY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Freq implements SubPredicate
    {
        EACH,
        FIRST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Relation implements SubPredicate
    {
        AFTER,
        AT_START_OF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Noun implements SubPredicate
    {
        TESTCASE,
        FAILED_TESTCASE,
        TESTRUN,
        FAILED_TESTRUN,
        INVOCATION,
        FAILED_INVOCATION;

    }

    public static interface SubPredicate {
    }
}

