/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceFileReporter {
    private final Map<String, LogDataType> mFilePatterns = new LinkedHashMap<String, LogDataType>();
    private final ITestInvocationListener mListener;
    private final ITestDevice mDevice;
    private LogDataType mDefaultFileType = LogDataType.UNKNOWN;

    public DeviceFileReporter(ITestDevice device, ITestInvocationListener listener) {
        if (device == null || listener == null) {
            throw new NullPointerException();
        }
        this.mDevice = device;
        this.mListener = listener;
    }

    public void addPatterns(String ... patterns) {
        this.addPatterns(Arrays.asList(patterns));
    }

    public void addPatterns(List<String> patterns) {
        for (String pat : patterns) {
            this.mFilePatterns.put(pat, this.mDefaultFileType);
        }
    }

    public void addPatterns(Map<String, LogDataType> patterns) {
        this.mFilePatterns.putAll(patterns);
    }

    public void setDefaultLogDataType(LogDataType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.mDefaultFileType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> run() throws DeviceNotAvailableException {
        LinkedList<String> filenames = new LinkedList<String>();
        for (Map.Entry<String, LogDataType> pat : this.mFilePatterns.entrySet()) {
            String searchCmd = String.format("ls '%s'", pat.getKey());
            String fileList = this.mDevice.executeShellCommand(searchCmd);
            for (String filename : fileList.split("\r\n")) {
                File file;
                block7: {
                    if (filename.isEmpty() || filename.endsWith(": No such file or directory")) continue;
                    file = null;
                    InputStreamSource iss = null;
                    try {
                        LogUtil.CLog.v("Trying to pull file %s from device %s", filename, this.mDevice.getSerialNumber());
                        file = this.mDevice.pullFile(filename);
                        LogUtil.CLog.v("Local file %s has size %d", file, file.length());
                        iss = this.createIssForFile(file);
                        this.mListener.testLog(filename, pat.getValue(), iss);
                        filenames.add(filename);
                        if (iss == null) break block7;
                        iss.cancel();
                        iss = null;
                    }
                    catch (IOException e) {
                        block8: {
                            try {
                                LogUtil.CLog.w("Failed to log file %s: %s", filename, e.getMessage());
                                if (iss == null) break block8;
                                iss.cancel();
                                iss = null;
                            }
                            catch (Throwable throwable) {
                                if (iss != null) {
                                    iss.cancel();
                                    iss = null;
                                }
                                FileUtil.deleteFile(file);
                                throw throwable;
                            }
                        }
                        FileUtil.deleteFile(file);
                        continue;
                    }
                }
                FileUtil.deleteFile(file);
            }
        }
        return filenames;
    }

    InputStreamSource createIssForFile(File file) throws IOException {
        BufferedInputStream bufStr = new BufferedInputStream(new FileInputStream(file));
        return new SnapshotInputStreamSource(bufStr);
    }
}

