/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.InvocationStatus;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.util.Email;
import com.android.tradefed.util.IEmail;
import com.android.tradefed.util.StreamUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="email")
public class EmailResultReporter
extends CollectingTestListener
implements ITestSummaryListener {
    private static final String DEFAULT_SUBJECT_TAG = "Tradefed";
    @Option(name="sender", description="The envelope-sender address to use for the messages.", importance=Option.Importance.IF_UNSET)
    private String mSender = null;
    @Option(name="destination", description="One or more destination addresses.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mDestinations = new HashSet<String>();
    @Option(name="subject-tag", description="The tag to be added to the beginning of the email subject.")
    private String mSubjectTag = "Tradefed";
    private List<TestSummary> mSummaries = null;
    private Throwable mInvocationThrowable = null;
    private IEmail mMailer;
    private boolean mHtml;

    public EmailResultReporter() {
        this(new Email());
    }

    protected EmailResultReporter(IEmail mailer) {
        this.mMailer = mailer;
    }

    public void addDestination(String dest) {
        this.mDestinations.add(dest);
    }

    @Override
    public void putSummary(List<TestSummary> summaries) {
        this.mSummaries = summaries;
    }

    protected List<TestSummary> fetchSummaries() {
        return this.mSummaries;
    }

    protected boolean shouldSendMessage() {
        return true;
    }

    protected String generateEmailSubject() {
        return String.format("%s result for %s on build %s: %s", new Object[]{this.mSubjectTag, this.getBuildInfo().getTestTag(), this.getBuildInfo().getBuildId(), this.getInvocationStatus()});
    }

    protected InvocationStatus getInvocationStatus() {
        if (this.mInvocationThrowable == null) {
            return InvocationStatus.SUCCESS;
        }
        if (this.mInvocationThrowable instanceof BuildError) {
            return InvocationStatus.BUILD_ERROR;
        }
        return InvocationStatus.FAILED;
    }

    protected Throwable getInvocationException() {
        return this.mInvocationThrowable;
    }

    protected String generateEmailBody() {
        StringBuilder bodyBuilder = new StringBuilder();
        for (Map.Entry<String, String> buildAttr : this.getBuildInfo().getBuildAttributes().entrySet()) {
            bodyBuilder.append(buildAttr.getKey());
            bodyBuilder.append(": ");
            bodyBuilder.append(buildAttr.getValue());
            bodyBuilder.append("\n");
        }
        bodyBuilder.append("host: ");
        try {
            bodyBuilder.append(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            bodyBuilder.append("unknown");
            LogUtil.CLog.e(e);
        }
        bodyBuilder.append("\n\n");
        if (this.mInvocationThrowable != null) {
            bodyBuilder.append("Invocation failed: ");
            bodyBuilder.append(StreamUtil.getStackTrace(this.mInvocationThrowable));
            bodyBuilder.append("\n");
        }
        bodyBuilder.append(String.format("Test results:  %d passed, %d failed, %d error\n\n", this.getNumPassedTests(), this.getNumFailedTests(), this.getNumErrorTests()));
        for (TestRunResult result : this.getRunResults()) {
            if (result.getRunMetrics().isEmpty()) continue;
            bodyBuilder.append(String.format("'%s' test run metrics: %s\n", result.getName(), result.getRunMetrics()));
        }
        bodyBuilder.append("\n");
        if (this.mSummaries != null) {
            for (TestSummary summary : this.mSummaries) {
                bodyBuilder.append("Invocation summary report: ");
                bodyBuilder.append(summary.getSummary().getString());
                if (summary.getKvEntries().isEmpty()) continue;
                bodyBuilder.append("\".\nSummary key-value dump:\n");
                bodyBuilder.append(summary.getKvEntries().toString());
            }
        }
        return bodyBuilder.toString();
    }

    protected void setHtml(boolean html) {
        this.mHtml = html;
    }

    protected boolean isHtml() {
        return this.mHtml;
    }

    @Override
    public void invocationFailed(Throwable t) {
        this.mInvocationThrowable = t;
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        super.invocationEnded(elapsedTime);
        if (!this.shouldSendMessage()) {
            return;
        }
        if (this.mDestinations.isEmpty()) {
            LogUtil.CLog.e("Failed to send email because no destination addresses were set.");
            return;
        }
        IEmail.Message msg = new IEmail.Message();
        msg.setSender(this.mSender);
        msg.setSubject(this.generateEmailSubject());
        msg.setBody(this.generateEmailBody());
        msg.setHtml(this.isHtml());
        Iterator<String> toAddress = this.mDestinations.iterator();
        while (toAddress.hasNext()) {
            msg.addTo(toAddress.next());
        }
        try {
            this.mMailer.send(msg);
        }
        catch (IllegalArgumentException e) {
            LogUtil.CLog.e("Failed to send email");
            LogUtil.CLog.e(e);
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to send email");
            LogUtil.CLog.e(e);
        }
    }
}

