/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.result.ITestInvocationListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitToInvocationResultForwarder
implements TestListener {
    private final List<ITestInvocationListener> mInvocationListeners;

    public JUnitToInvocationResultForwarder(ITestInvocationListener invocationListener) {
        this.mInvocationListeners = new ArrayList<ITestInvocationListener>(1);
        this.mInvocationListeners.add(invocationListener);
    }

    public JUnitToInvocationResultForwarder(List<ITestInvocationListener> invocationListeners) {
        this.mInvocationListeners = new ArrayList<ITestInvocationListener>(invocationListeners.size());
        this.mInvocationListeners.addAll(invocationListeners);
    }

    @Override
    public void addError(Test test, Throwable t) {
        for (ITestInvocationListener listener : this.mInvocationListeners) {
            listener.testFailed(ITestRunListener.TestFailure.ERROR, this.getTestId(test), this.getStackTrace(t));
        }
    }

    @Override
    public void addFailure(Test test, AssertionFailedError t) {
        for (ITestInvocationListener listener : this.mInvocationListeners) {
            listener.testFailed(ITestRunListener.TestFailure.FAILURE, this.getTestId(test), this.getStackTrace((Throwable)((Object)t)));
        }
    }

    @Override
    public void endTest(Test test) {
        Map emptyMap = Collections.emptyMap();
        for (ITestInvocationListener listener : this.mInvocationListeners) {
            listener.testEnded(this.getTestId(test), emptyMap);
        }
    }

    @Override
    public void startTest(Test test) {
        for (ITestInvocationListener listener : this.mInvocationListeners) {
            listener.testStarted(this.getTestId(test));
        }
    }

    private TestIdentifier getTestId(Test test) {
        String className = test.getClass().getName();
        String testName = "";
        if (test instanceof TestCase) {
            testName = ((TestCase)test).getName();
        }
        return new TestIdentifier(className, testName);
    }

    private String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream bytePrintStream = new PrintStream(outputStream);
        throwable.printStackTrace(bytePrintStream);
        return outputStream.toString();
    }
}

