/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ILogFileSaver;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LogFileSaver
implements ILogFileSaver {
    static final String RETENTION_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss zzz";
    static final String RETENTION_FILE_NAME = ".retention";
    private static final int BUFFER_SIZE = 65536;
    private File mRootDir;

    public LogFileSaver(IBuildInfo buildInfo, File rootDir, Integer logRetentionDays) {
        File buildDir = this.createBuildDir(buildInfo, rootDir);
        try {
            this.mRootDir = FileUtil.createTempDir("inv_", buildDir);
            if (logRetentionDays != null && logRetentionDays > 0) {
                this.writeRetentionFile(this.mRootDir, logRetentionDays);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e("Unable to create unique directory in %s. Attempting to use tmp dir instead", buildDir.getAbsolutePath());
            LogUtil.CLog.e(e);
            this.mRootDir = this.createTempDir();
        }
        LogUtil.CLog.i("Using log file directory %s", this.mRootDir.getAbsolutePath());
    }

    private File createTempDir() {
        try {
            return FileUtil.createTempDir("inv_");
        }
        catch (IOException e) {
            throw new FatalHostError("Cannot create tmp directory.", e);
        }
    }

    public LogFileSaver(IBuildInfo buildInfo, File rootDir) {
        this(buildInfo, rootDir, null);
    }

    public LogFileSaver(File rootDir) {
        this.mRootDir = rootDir;
    }

    public File getFileDir() {
        return this.mRootDir;
    }

    private File createBuildDir(IBuildInfo buildInfo, File rootDir) {
        ArrayList<String> pathSegments = new ArrayList<String>();
        if (buildInfo.getBuildBranch() != null) {
            pathSegments.add(buildInfo.getBuildBranch());
        }
        pathSegments.add(buildInfo.getBuildId());
        pathSegments.add(buildInfo.getTestTag());
        File buildReportDir = FileUtil.getFileForPath(rootDir, pathSegments.toArray(new String[0]));
        if (buildReportDir.exists()) {
            if (buildReportDir.isDirectory()) {
                return buildReportDir;
            }
            LogUtil.CLog.w("Cannot create build-specific output dir %s. File already exists.", buildReportDir.getAbsolutePath());
        } else {
            if (FileUtil.mkdirsRWX(buildReportDir)) {
                return buildReportDir;
            }
            LogUtil.CLog.w("Cannot create build-specific output dir %s. Failed to create directory.", buildReportDir.getAbsolutePath());
        }
        return rootDir;
    }

    private static String sanitizeFilename(String name) {
        return name.replace(File.separatorChar, '_');
    }

    public File saveLogData(String dataName, LogDataType dataType, InputStream dataStream) throws IOException {
        String saneDataName = LogFileSaver.sanitizeFilename(dataName);
        File logFile = FileUtil.createTempFile(saneDataName + "_", "." + dataType.getFileExt(), this.mRootDir);
        FileUtil.writeToFile(dataStream, logFile);
        LogUtil.CLog.i("Saved log file %s", logFile.getAbsolutePath());
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveAndZipLogData(String dataName, LogDataType dataType, InputStream dataStream) throws IOException {
        File file;
        if (dataType.isCompressed()) {
            LogUtil.CLog.d("Log data for %s is already compressed, skipping compression", dataName);
            return this.saveLogData(dataName, dataType, dataStream);
        }
        BufferedInputStream bufInput = null;
        ZipOutputStream outStream = null;
        try {
            String saneDataName = LogFileSaver.sanitizeFilename(dataName);
            File logFile = FileUtil.createTempFile(saneDataName + "_", "." + LogDataType.ZIP.getFileExt(), this.mRootDir);
            bufInput = new BufferedInputStream(dataStream);
            outStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(logFile), 65536));
            outStream.putNextEntry(new ZipEntry(saneDataName + "." + dataType.getFileExt()));
            StreamUtil.copyStreams(bufInput, outStream);
            LogUtil.CLog.i("Saved log file %s", logFile.getAbsolutePath());
            file = logFile;
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(bufInput);
            StreamUtil.closeZipStream(outStream);
            throw throwable;
        }
        StreamUtil.closeStream(bufInput);
        StreamUtil.closeZipStream(outStream);
        return file;
    }

    public File createCompressedLogFile(String dataName, LogDataType origDataType, LogDataType compressedType) throws IOException {
        return FileUtil.createTempFile(dataName + "_", String.format(".%s.%s", origDataType.getFileExt(), LogDataType.GZIP.getFileExt()), this.mRootDir);
    }

    public OutputStream createGZipLogStream(File logFile) throws IOException {
        return new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(logFile)), 65536);
    }

    public InputStream createInputStreamFromFile(File logFile) throws IOException {
        return new BufferedInputStream(new FileInputStream(logFile), 65536);
    }

    private void writeRetentionFile(File dir, Integer logRetentionDays) {
        try {
            long deleteTimeEpoch = System.currentTimeMillis() + (long)(logRetentionDays * 24 * 60 * 60 * 1000);
            Date date = new Date(deleteTimeEpoch);
            SimpleDateFormat formatter = new SimpleDateFormat(RETENTION_DATE_FORMAT);
            File retentionFile = new File(dir, RETENTION_FILE_NAME);
            FileUtil.writeToFile(formatter.format(date), retentionFile);
        }
        catch (IOException e) {
            LogUtil.CLog.e("Unable to create retention file in directory in %s", dir.getAbsolutePath());
            LogUtil.CLog.e(e);
        }
    }
}

