/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestSummary;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NameMangleListener
implements ITestInvocationListener {
    private final ITestInvocationListener mListener;

    public NameMangleListener(ITestInvocationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.mListener = listener;
    }

    protected TestIdentifier mangleTestId(TestIdentifier test) {
        return test;
    }

    protected String mangleTestRunName(String name) {
        return name;
    }

    protected IBuildInfo mangleBuildInfo(IBuildInfo buildInfo) {
        return buildInfo;
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        TestIdentifier mangledTestId = this.mangleTestId(test);
        this.mListener.testEnded(mangledTestId, testMetrics);
    }

    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
        TestIdentifier mangledTestId = this.mangleTestId(test);
        this.mListener.testFailed(status, mangledTestId, trace);
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        this.mListener.testRunEnded(elapsedTime, runMetrics);
    }

    public void testRunFailed(String errorMessage) {
        this.mListener.testRunFailed(errorMessage);
    }

    public void testRunStarted(String runName, int testCount) {
        String mangledName = this.mangleTestRunName(runName);
        this.mListener.testRunStarted(mangledName, testCount);
    }

    public void testRunStopped(long elapsedTime) {
        this.mListener.testRunStopped(elapsedTime);
    }

    public void testStarted(TestIdentifier test) {
        TestIdentifier mangledTestId = this.mangleTestId(test);
        this.mListener.testStarted(mangledTestId);
    }

    @Override
    public void invocationStarted(IBuildInfo buildInfo) {
        IBuildInfo mangledBuildInfo = this.mangleBuildInfo(buildInfo);
        this.mListener.invocationStarted(mangledBuildInfo);
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        this.mListener.testLog(dataName, dataType, dataStream);
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        this.mListener.invocationEnded(elapsedTime);
    }

    @Override
    public void invocationFailed(Throwable cause) {
        this.mListener.invocationFailed(cause);
    }

    @Override
    public TestSummary getSummary() {
        return this.mListener.getSummary();
    }
}

