/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ILogFileSaver;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.InvocationToJUnitResultForwarder;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFileSaver;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.textui.ResultPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionClass(alias="stdout")
public class TextResultReporter
extends InvocationToJUnitResultForwarder
implements ITestInvocationListener {
    private ILogFileSaver mLogFileSaver;
    private static final String REPORT_DIR_NAME = "output-file-path";
    @Option(name="output-file-path", description="root file system path to directory to store logs. Ignored if --save-logs is set.")
    private File mReportDir = new File(System.getProperty("java.io.tmpdir"));
    @Option(name="save-logs", description="save any logs to local disk.")
    private boolean mSaveLogs = true;

    public TextResultReporter() {
        super(new ResultPrinter(System.out));
    }

    @Override
    public void invocationStarted(IBuildInfo buildInfo) {
        super.invocationStarted(buildInfo);
        this.mLogFileSaver = new LogFileSaver(buildInfo, this.mReportDir);
    }

    @Override
    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier testId, String trace) {
        ResultPrinter printer = (ResultPrinter)this.getJUnitListener();
        printer.getWriter().format("\nTest %s: %s \n stack: %s ", status, testId, trace);
    }

    @Override
    public void testEnded(TestIdentifier testId, Map<String, String> metrics) {
        super.testEnded(testId, metrics);
        if (!metrics.isEmpty()) {
            ResultPrinter printer = (ResultPrinter)this.getJUnitListener();
            printer.getWriter().format("\n%s metrics: %s\n", testId, metrics);
        }
    }

    @Override
    public void testRunEnded(long elapsedTime, Map<String, String> metrics) {
        super.testRunEnded(elapsedTime, metrics);
        if (!metrics.isEmpty()) {
            ResultPrinter printer = (ResultPrinter)this.getJUnitListener();
            printer.getWriter().format("\nMetrics: %s\n", metrics);
        }
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        if (this.mSaveLogs) {
            try {
                File logFile = this.mLogFileSaver.saveLogData(dataName, dataType, dataStream.createInputStream());
                LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Saved %s log to %s", dataName, logFile.getAbsolutePath());
            }
            catch (IOException e) {
                LogUtil.CLog.e("Failed to save log data");
                LogUtil.CLog.e(e);
            }
        }
    }
}

