/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IAppBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.ArrayList;
import java.util.Collection;

public class AppSetup
implements ITargetPreparer {
    private static final String LOG_TAG = "AppSetup";
    @Option(name="app-package-name", description="the package name(s) of app and tests. Used for device cleanup of old packages before starting tests.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mAppPackageNames = new ArrayList<String>();
    @Option(name="reboot", description="reboot device during setup.")
    private boolean mReboot = true;

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (!(buildInfo instanceof IAppBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a AppBuildInfo");
        }
        IAppBuildInfo appBuild = (IAppBuildInfo)buildInfo;
        Log.i((String)LOG_TAG, (String)String.format("Performing setup on %s", device.getSerialNumber()));
        for (String packageName : this.mAppPackageNames) {
            device.uninstallPackage(packageName);
        }
        if (this.mReboot) {
            device.reboot();
        }
        for (VersionedFile apkFile : appBuild.getAppPackageFiles()) {
            device.installPackage(apkFile.getFile(), true, new String[0]);
        }
    }
}

