/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DeviceFailedToBootError;
import com.android.tradefed.targetprep.IDeviceFlasher;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;

public abstract class DeviceFlashPreparer
implements ITargetPreparer {
    private static final String LOG_TAG = "DeviceFlashPreparer";
    private static final int BOOT_POLL_TIME_MS = 5000;
    @Option(name="device-boot-time", description="max time in ms to wait for device to boot.")
    private long mDeviceBootTime = 300000L;
    @Option(name="userdata-flash", description="specify handling of userdata partition.")
    private IDeviceFlasher.UserDataFlashOption mUserDataFlashOption = IDeviceFlasher.UserDataFlashOption.FLASH;
    @Option(name="encrypt-userdata", description="specify if userdata partition should be encrypted")
    private boolean mEncryptUserData = false;
    @Option(name="force-system-flash", description="specify if system should always be flashed even if already running desired build.")
    private boolean mForceSystemFlash = false;

    void setDeviceBootTime(long bootTime) {
        this.mDeviceBootTime = bootTime;
    }

    int getDeviceBootPollTimeMs() {
        return 5000;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public void setUserDataFlashOption(IDeviceFlasher.UserDataFlashOption flashOption) {
        this.mUserDataFlashOption = flashOption;
    }

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException, BuildError {
        Log.i((String)LOG_TAG, (String)String.format("Performing setup on %s", device.getSerialNumber()));
        if (!(buildInfo instanceof IDeviceBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a IDeviceBuildInfo");
        }
        IDeviceBuildInfo deviceBuild = (IDeviceBuildInfo)buildInfo;
        device.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
        IDeviceFlasher flasher = this.createFlasher(device);
        flasher.overrideDeviceOptions(device);
        flasher.setUserDataFlashOption(this.mUserDataFlashOption);
        flasher.setForceSystemFlash(this.mForceSystemFlash);
        this.preEncryptDevice(device, flasher);
        flasher.flash(device, deviceBuild);
        device.waitForDeviceOnline();
        this.postEncryptDevice(device, flasher);
        device.clearLogcat();
        try {
            device.setRecoveryMode(ITestDevice.RecoveryMode.AVAILABLE);
            device.waitForDeviceAvailable(this.mDeviceBootTime);
        }
        catch (DeviceUnresponsiveException e) {
            throw new DeviceFailedToBootError(String.format("Device %s did not become available after flashing %s", device.getSerialNumber(), deviceBuild.getDeviceBuildId()));
        }
        device.postBootSetup();
    }

    protected abstract IDeviceFlasher createFlasher(ITestDevice var1) throws DeviceNotAvailableException;

    private void preEncryptDevice(ITestDevice device, IDeviceFlasher flasher) throws DeviceNotAvailableException, TargetSetupError {
        if (!device.isEncryptionSupported()) {
            if (this.mEncryptUserData) {
                throw new TargetSetupError("Encryption is not supported");
            }
            return;
        }
        if (!this.mEncryptUserData && device.isDeviceEncrypted()) {
            if (flasher.getUserDataFlashOption() == IDeviceFlasher.UserDataFlashOption.RETAIN) {
                throw new TargetSetupError(String.format("not possible to go from encrypted userdata partition to unencrypted with %s", new Object[]{flasher.getUserDataFlashOption()}));
            }
            if (!device.unencryptDevice()) {
                throw new TargetSetupError("Failed to unencrypt device");
            }
        }
        if (this.mEncryptUserData && !device.isDeviceEncrypted()) {
            switch (flasher.getUserDataFlashOption()) {
                case TESTS_ZIP: 
                case WIPE_RM: {
                    if (!device.encryptDevice(false)) {
                        throw new TargetSetupError("Failed to encrypt device");
                    }
                    if (device.unlockDevice()) break;
                    throw new TargetSetupError("Failed to unlock device");
                }
                case RETAIN: {
                    if (!device.encryptDevice(true)) {
                        throw new TargetSetupError("Failed to encrypt device");
                    }
                    if (device.unlockDevice()) break;
                    throw new TargetSetupError("Failed to unlock device");
                }
            }
        }
    }

    private void postEncryptDevice(ITestDevice device, IDeviceFlasher flasher) throws DeviceNotAvailableException, TargetSetupError {
        if (!device.isEncryptionSupported()) {
            if (this.mEncryptUserData) {
                throw new TargetSetupError("Encryption is not supported");
            }
            return;
        }
        if (this.mEncryptUserData) {
            switch (flasher.getUserDataFlashOption()) {
                case FLASH: {
                    if (device.encryptDevice(true)) break;
                    throw new TargetSetupError("Failed to encrypt device");
                }
                case WIPE: 
                case FORCE_WIPE: {
                    if (device.encryptDevice(false)) break;
                    throw new TargetSetupError("Failed to encrypt device");
                }
            }
            if (!device.unlockDevice()) {
                throw new TargetSetupError("Failed to unlock device");
            }
        }
    }
}

