/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

@OptionClass(alias="device-setup")
public class DeviceSetup
implements ITargetPreparer {
    private static final String LOG_TAG = "DeviceSetup";
    private static final Pattern RELEASE_BUILD_NAME_PATTERN = Pattern.compile("[A-Z]{3}\\d{2}[A-Z]?");
    @Option(name="wifi-network", description="the name of wifi network to connect to.")
    private String mWifiNetwork = null;
    @Option(name="wifi-psk", description="WPA-PSK passphrase of wifi network to connect to.")
    private String mWifiPsk = null;
    @Option(name="wifi-attempts", description="maximum number of attempts to connect to wifi network.")
    private int mWifiAttempts = 2;
    @Option(name="min-external-store-space", description="the minimum amount of free space in KB that must be present on device's external storage.")
    private long mMinExternalStoreSpace = 500L;
    @Option(name="local-data-path", description="optional local file path of test data to sync to device's external storage. Use --remote-data-path to set remote location.")
    private File mLocalDataFile = null;
    @Option(name="remote-data-path", description="optional file path on device's external storage to sync test data. Must be used with --local-data-path.")
    private String mRemoteDataPath = null;
    @Option(name="force-skip-system-props", description="force setup to not modify any device system properties. All other system property options will be ignored.")
    private boolean mForceNoSystemProps = false;
    @Option(name="disable-dialing", description="set disable dialing property on boot.")
    private boolean mDisableDialing = true;
    @Option(name="set-test-harness", description="set the read-only test harness flag on boot. Requires adb root.")
    private boolean mSetTestHarness = true;
    @Option(name="audio-silent", description="set ro.audio.silent on boot.")
    private boolean mSetAudioSilent = true;
    @Option(name="disable-dalvik-verifier", description="disable the dalvik verifier on device. Allows package-private framework tests to run.")
    private boolean mDisableDalvikVerifier = false;
    @Option(name="setprop", description="set the specified property on boot.  Format: --setprop key=value.  May be repeated.")
    private Collection<String> mSetProps = new ArrayList<String>();

    void setLocalDataPath(File localPath) {
        this.mLocalDataFile = localPath;
    }

    void setRemoteDataPath(String remotePath) {
        this.mRemoteDataPath = remotePath;
    }

    void setWifiNetwork(String network) {
        this.mWifiNetwork = network;
    }

    void setMinExternalStoreSpace(int minKBytes) {
        this.mMinExternalStoreSpace = minKBytes;
    }

    void addSetProperty(String prop) {
        this.mSetProps.add(prop);
    }

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException, BuildError {
        Log.i((String)LOG_TAG, (String)String.format("Performing setup on %s", device.getSerialNumber()));
        if (!device.enableAdbRoot()) {
            throw new TargetSetupError(String.format("failed to enable adb root on %s", device.getSerialNumber()));
        }
        this.configureSystemProperties(device);
        this.keepScreenOn(device);
        this.connectToWifi(device);
        this.syncTestData(device);
        this.checkExternalStoreSpace(device);
        device.clearErrorDialogs();
    }

    private void configureSystemProperties(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        if (this.mForceNoSystemProps) {
            return;
        }
        StringBuilder propertyBuilder = new StringBuilder();
        if (this.mDisableDialing) {
            propertyBuilder.append("ro.telephony.disable-call=true\n");
        }
        if (this.mSetTestHarness) {
            propertyBuilder.append("ro.monkey=1\n");
            propertyBuilder.append("ro.test_harness=1\n");
        }
        if (this.mSetAudioSilent) {
            propertyBuilder.append("ro.audio.silent=1\n");
        }
        if (this.mDisableDalvikVerifier) {
            propertyBuilder.append("dalvik.vm.dexopt-flags = v=n\n");
        }
        for (String prop : this.mSetProps) {
            propertyBuilder.append(prop);
            propertyBuilder.append("\n");
        }
        if (propertyBuilder.length() > 0) {
            boolean result = device.pushString(propertyBuilder.toString(), "/data/local.prop");
            if (!result) {
                throw new TargetSetupError(String.format("Failed to push file to %s", device.getSerialNumber()));
            }
            device.executeShellCommand("chmod 644 /data/local.prop");
            Log.i((String)LOG_TAG, (String)String.format("Setup requires system property change. Reboot of %s required", device.getSerialNumber()));
            device.reboot();
        }
    }

    private void keepScreenOn(ITestDevice device) throws DeviceNotAvailableException {
        device.executeShellCommand("svc power stayon true");
    }

    private void checkExternalStoreSpace(ITestDevice device) throws DeviceNotAvailableException {
        long freeSpace;
        if (this.mMinExternalStoreSpace > 0L && (freeSpace = device.getExternalStoreFreeSpace()) < this.mMinExternalStoreSpace) {
            throw new DeviceNotAvailableException(String.format("External store free space %dK is less than required %dK for device %s", freeSpace, this.mMinExternalStoreSpace, device.getSerialNumber()));
        }
    }

    private void connectToWifi(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        if (this.mWifiNetwork != null) {
            for (int i = 0; i < this.mWifiAttempts; ++i) {
                if (!device.connectToWifiNetwork(this.mWifiNetwork, this.mWifiPsk)) continue;
                LogUtil.CLog.i("Connected to wifi network %s", this.mWifiNetwork);
                return;
            }
            throw new TargetSetupError(String.format("Failed to connect to wifi network %s on %s", this.mWifiNetwork, device.getSerialNumber()));
        }
    }

    void syncTestData(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        if (this.mLocalDataFile != null) {
            boolean result;
            if (!this.mLocalDataFile.exists() || !this.mLocalDataFile.isDirectory()) {
                throw new TargetSetupError(String.format("local-data-path %s is not a directory", this.mLocalDataFile.getAbsolutePath()));
            }
            String fullRemotePath = device.getIDevice().getMountPoint("EXTERNAL_STORAGE");
            if (this.mRemoteDataPath != null) {
                fullRemotePath = String.format("%s/%s", fullRemotePath, this.mRemoteDataPath);
            }
            if (!(result = device.syncFiles(this.mLocalDataFile, fullRemotePath))) {
                throw new TargetSetupError(String.format("failed to sync test data from local-data-path %s to %s on device %s", this.mLocalDataFile.getAbsolutePath(), fullRemotePath, device.getSerialNumber()));
            }
        }
    }

    protected boolean isReleaseBuildName(String name) {
        return RELEASE_BUILD_NAME_PATTERN.matcher(name).matches();
    }
}

