/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.DefaultTestsZipInstaller;
import com.android.tradefed.targetprep.FlashingResourcesParser;
import com.android.tradefed.targetprep.IDeviceFlasher;
import com.android.tradefed.targetprep.IFlashingResourcesParser;
import com.android.tradefed.targetprep.IFlashingResourcesRetriever;
import com.android.tradefed.targetprep.ITestsZipInstaller;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastbootDeviceFlasher
implements IDeviceFlasher {
    public static final String BASEBAND_IMAGE_NAME = "radio";
    private IDeviceFlasher.UserDataFlashOption mUserDataFlashOption = IDeviceFlasher.UserDataFlashOption.FLASH;
    private IFlashingResourcesRetriever mResourceRetriever;
    private ITestsZipInstaller mTestsZipInstaller = new DefaultTestsZipInstaller("media");
    private boolean mForceSystemFlash;

    public void setFlashingResourcesRetriever(IFlashingResourcesRetriever retriever) {
        this.mResourceRetriever = retriever;
    }

    protected IFlashingResourcesRetriever getFlashingResourcesRetriever() {
        return this.mResourceRetriever;
    }

    public void setUserDataFlashOption(IDeviceFlasher.UserDataFlashOption flashOption) {
        this.mUserDataFlashOption = flashOption;
    }

    public IDeviceFlasher.UserDataFlashOption getUserDataFlashOption() {
        return this.mUserDataFlashOption;
    }

    void setTestsZipInstaller(ITestsZipInstaller testsZipInstaller) {
        this.mTestsZipInstaller = testsZipInstaller;
    }

    ITestsZipInstaller getTestsZipInstaller() {
        return this.mTestsZipInstaller;
    }

    public void flash(ITestDevice device, IDeviceBuildInfo deviceBuild) throws TargetSetupError, DeviceNotAvailableException {
        LogUtil.CLog.i("Flashing device %s with build %s", device.getSerialNumber(), deviceBuild.getDeviceBuildId());
        String systemBuildId = device.getBuildId();
        device.rebootIntoBootloader();
        this.downloadFlashingResources(device, deviceBuild);
        this.checkAndFlashBootloader(device, deviceBuild);
        this.checkAndFlashBaseband(device, deviceBuild);
        this.flashUserData(device, deviceBuild);
        this.wipeCache(device);
        this.checkAndFlashSystem(device, systemBuildId, deviceBuild);
    }

    protected void flashPartition(ITestDevice device, File imgFile, String partition) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.d("fastboot flash %s %s", partition, imgFile.getAbsolutePath());
        this.executeLongFastbootCmd(device, "flash", partition, imgFile.getAbsolutePath());
    }

    protected void wipePartition(ITestDevice device, String partition) throws DeviceNotAvailableException, TargetSetupError {
        String wipeMethod = device.getUseFastbootErase() ? "erase" : "format";
        LogUtil.CLog.d("fastboot %s %s", wipeMethod, partition);
        CommandResult result = device.fastbootWipePartition(partition);
        this.handleFastbootResult(device, result, wipeMethod, partition);
    }

    protected void downloadFlashingResources(ITestDevice device, IDeviceBuildInfo localBuild) throws TargetSetupError, DeviceNotAvailableException {
        String basebandVersion;
        IFlashingResourcesParser resourceParser = this.createFlashingResourcesParser(localBuild);
        if (resourceParser.getRequiredBoards() == null) {
            throw new TargetSetupError(String.format("Build %s is missing required board info.", localBuild.getDeviceBuildId()));
        }
        String deviceProductType = device.getProductType();
        if (deviceProductType == null) {
            throw new DeviceNotAvailableException(String.format("Could not determine product type for device %s", device.getSerialNumber()));
        }
        this.verifyRequiredBoards(device, resourceParser, deviceProductType);
        String bootloaderVersion = resourceParser.getRequiredBootloaderVersion();
        if (bootloaderVersion != null && localBuild.getBootloaderImageFile() == null) {
            localBuild.setBootloaderImageFile(this.getFlashingResourcesRetriever().retrieveFile(this.getBootloaderFilePrefix(device), bootloaderVersion), bootloaderVersion);
        }
        if ((basebandVersion = resourceParser.getRequiredBasebandVersion()) != null && localBuild.getBasebandImageFile() == null) {
            localBuild.setBasebandImage(this.getFlashingResourcesRetriever().retrieveFile(BASEBAND_IMAGE_NAME, basebandVersion), basebandVersion);
        }
        this.downloadExtraImageFiles(resourceParser, this.getFlashingResourcesRetriever(), localBuild);
    }

    protected void verifyRequiredBoards(ITestDevice device, IFlashingResourcesParser resourceParser, String deviceProductType) throws TargetSetupError {
        if (!resourceParser.getRequiredBoards().contains(deviceProductType)) {
            throw new TargetSetupError(String.format("Device %s is %s. Expected %s", device.getSerialNumber(), deviceProductType, resourceParser.getRequiredBoards()));
        }
    }

    protected void downloadExtraImageFiles(IFlashingResourcesParser resourceParser, IFlashingResourcesRetriever retriever, IDeviceBuildInfo localBuild) throws TargetSetupError {
    }

    protected IFlashingResourcesParser createFlashingResourcesParser(IDeviceBuildInfo localBuild) throws TargetSetupError {
        return new FlashingResourcesParser(localBuild.getDeviceImageFile());
    }

    protected boolean checkAndFlashBootloader(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        String currentBootloaderVersion = this.getImageVersion(device, "bootloader");
        if (deviceBuild.getBootloaderVersion() != null && !deviceBuild.getBootloaderVersion().equals(currentBootloaderVersion)) {
            LogUtil.CLog.i("Flashing bootloader %s", deviceBuild.getBootloaderVersion());
            this.flashBootloader(device, deviceBuild.getBootloaderImageFile());
            return true;
        }
        LogUtil.CLog.i("Bootloader is already version %s, skipping flashing", currentBootloaderVersion);
        return false;
    }

    protected void flashBootloader(ITestDevice device, File bootloaderImageFile) throws DeviceNotAvailableException, TargetSetupError {
        this.executeFastbootCmd(device, "flash", this.getBootPartitionName(), bootloaderImageFile.getAbsolutePath());
        device.rebootIntoBootloader();
    }

    protected String getBootPartitionName() {
        return "hboot";
    }

    protected String getBootloaderFilePrefix(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        return this.getBootPartitionName();
    }

    protected void checkAndFlashBaseband(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        String currentBasebandVersion = this.getImageVersion(device, "baseband");
        if (this.checkShouldFlashBaseband(device, deviceBuild)) {
            LogUtil.CLog.i("Flashing baseband %s", deviceBuild.getBasebandVersion());
            this.flashBaseband(device, deviceBuild.getBasebandImageFile());
        } else {
            LogUtil.CLog.i("Baseband is already version %s, skipping flashing", currentBasebandVersion);
        }
    }

    protected boolean checkShouldFlashBaseband(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        String currentBasebandVersion = this.getImageVersion(device, "baseband");
        return deviceBuild.getBasebandVersion() != null && !deviceBuild.getBasebandVersion().equals(currentBasebandVersion);
    }

    protected void flashBaseband(ITestDevice device, File basebandImageFile) throws DeviceNotAvailableException, TargetSetupError {
        this.flashPartition(device, basebandImageFile, BASEBAND_IMAGE_NAME);
        device.rebootIntoBootloader();
    }

    protected void wipeCache(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        if (!this.mUserDataFlashOption.equals((Object)IDeviceFlasher.UserDataFlashOption.RETAIN)) {
            LogUtil.CLog.i("Wiping cache on %s", device.getSerialNumber());
            this.wipePartition(device, "cache");
        } else {
            LogUtil.CLog.d("Skipping cache wipe on %s", device.getSerialNumber());
        }
    }

    protected void flashUserData(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        switch (this.mUserDataFlashOption) {
            case FLASH: {
                LogUtil.CLog.i("Flashing %s with userdata %s", device.getSerialNumber(), deviceBuild.getUserDataImageFile().getAbsolutePath());
                this.flashPartition(device, deviceBuild.getUserDataImageFile(), "userdata");
                break;
            }
            case FORCE_WIPE: 
            case WIPE: {
                LogUtil.CLog.i("Wiping userdata %s", device.getSerialNumber());
                this.wipePartition(device, "userdata");
                break;
            }
            case TESTS_ZIP: {
                device.rebootUntilOnline();
                if (device.isEncryptionSupported() && device.isDeviceEncrypted()) {
                    device.unlockDevice();
                }
                this.getTestsZipInstaller().pushTestsZipOntoData(device, deviceBuild);
                device.rebootIntoBootloader();
                break;
            }
            case WIPE_RM: {
                device.rebootUntilOnline();
                if (device.isEncryptionSupported() && device.isDeviceEncrypted()) {
                    device.unlockDevice();
                }
                this.getTestsZipInstaller().deleteData(device);
                device.rebootIntoBootloader();
                break;
            }
            default: {
                LogUtil.CLog.d("Skipping userdata flash for %s", device.getSerialNumber());
            }
        }
    }

    protected boolean checkAndFlashSystem(ITestDevice device, String systemBuildId, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        if (this.mForceSystemFlash || systemBuildId != null && !systemBuildId.equals(deviceBuild.getDeviceBuildId())) {
            LogUtil.CLog.i("Flashing system %s", deviceBuild.getDeviceBuildId());
            this.flashSystem(device, deviceBuild);
            return true;
        }
        LogUtil.CLog.i("System is already version %s, skipping flashing", systemBuildId);
        device.rebootUntilOnline();
        return false;
    }

    protected void flashSystem(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.i("Flashing %s with update %s", device.getSerialNumber(), deviceBuild.getDeviceImageFile().getAbsolutePath());
        this.executeLongFastbootCmd(device, "update", deviceBuild.getDeviceImageFile().getAbsolutePath());
    }

    protected String getImageVersion(ITestDevice device, String imageName) throws DeviceNotAvailableException, TargetSetupError {
        String versionQuery = String.format("version-%s", imageName);
        String queryOutput = this.executeFastbootCmd(device, "getvar", versionQuery);
        String patternString = String.format("%s:\\s(.*)\\s", versionQuery);
        Pattern versionOutputPattern = Pattern.compile(patternString);
        Matcher matcher = versionOutputPattern.matcher(queryOutput);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new TargetSetupError(String.format("Could not find version for '%s'. Output '%s'", imageName, queryOutput));
    }

    protected String executeFastbootCmd(ITestDevice device, String ... cmdArgs) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.v("Executing short fastboot command %s", Arrays.toString(cmdArgs));
        CommandResult result = device.executeFastbootCommand(cmdArgs);
        return this.handleFastbootResult(device, result, cmdArgs);
    }

    protected String executeLongFastbootCmd(ITestDevice device, String ... cmdArgs) throws DeviceNotAvailableException, TargetSetupError {
        CommandResult result = device.executeLongFastbootCommand(cmdArgs);
        return this.handleFastbootResult(device, result, cmdArgs);
    }

    private String handleFastbootResult(ITestDevice device, CommandResult result, String ... cmdArgs) throws TargetSetupError {
        if (result.getStatus() != CommandStatus.SUCCESS || result.getStderr().contains("FAILED")) {
            throw new TargetSetupError(String.format("fastboot command %s failed in device %s. stdout: %s, stderr: %s", cmdArgs[0], device.getSerialNumber(), result.getStdout(), result.getStderr()));
        }
        if (result.getStderr().length() > 0) {
            return result.getStderr();
        }
        return result.getStdout();
    }

    public void overrideDeviceOptions(ITestDevice device) {
    }

    public void setForceSystemFlash(boolean forceSystemFlash) {
        this.mForceSystemFlash = forceSystemFlash;
    }
}

