/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.targetprep.IFlashingResourcesParser;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.MultiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashingResourcesParser
implements IFlashingResourcesParser {
    private static final String ANDROID_INFO_FILE_NAME = "android-info.txt";
    private static final Pattern REQUIRE_PATTERN = Pattern.compile("(?:require\\s)?(.*?)=(.*)");
    private static final Pattern PRODUCT_REQUIRE_PATTERN = Pattern.compile("require-for-product:(\\S+) +(.*?)=(.*)");
    public static final String PRODUCT_KEY = "product";
    public static final String BOARD_KEY = "board";
    public static final String BOOTLOADER_VERSION_KEY = "version-bootloader";
    public static final String BASEBAND_VERSION_KEY = "version-baseband";
    private AndroidInfo mReqs;

    public FlashingResourcesParser(File deviceImgZipFile, Map<String, Constraint> c) throws TargetSetupError {
        this.mReqs = FlashingResourcesParser.getBuildRequirements(deviceImgZipFile, c);
    }

    public FlashingResourcesParser(File deviceImgZipFile) throws TargetSetupError {
        this(deviceImgZipFile, null);
    }

    public FlashingResourcesParser(BufferedReader infoReader, Map<String, Constraint> c) throws TargetSetupError, IOException {
        this.mReqs = FlashingResourcesParser.parseAndroidInfo(infoReader, c);
    }

    public FlashingResourcesParser(BufferedReader infoReader) throws TargetSetupError, IOException {
        this(infoReader, null);
    }

    @Override
    public String getRequiredBootloaderVersion() {
        return this.getRequiredImageVersion(BOOTLOADER_VERSION_KEY);
    }

    @Override
    public String getRequiredBasebandVersion() {
        return this.getRequiredImageVersion(BASEBAND_VERSION_KEY);
    }

    @Override
    public String getRequiredImageVersion(String imageVersionKey) {
        return this.getRequiredImageVersion(imageVersionKey, null);
    }

    @Override
    public String getRequiredImageVersion(String imageVersionKey, String productName) {
        MultiMap productReqs = (MultiMap)this.mReqs.get(productName);
        if (productReqs == null && productName != null) {
            return this.getRequiredImageVersion(imageVersionKey, null);
        }
        String result = FlashingResourcesParser.getNewest(productReqs.get(imageVersionKey));
        if (result != null) {
            return result;
        }
        if (result == null && productName != null) {
            return this.getRequiredImageVersion(imageVersionKey, null);
        }
        return null;
    }

    @Override
    public Collection<String> getRequiredBoards() {
        ArrayList<String> all = new ArrayList<String>();
        MultiMap boardReqs = (MultiMap)this.mReqs.get(null);
        if (boardReqs == null) {
            return null;
        }
        List board = boardReqs.get(BOARD_KEY);
        List product = boardReqs.get(PRODUCT_KEY);
        if (board != null) {
            all.addAll(board);
        } else if (product != null) {
            all.addAll(product);
        } else {
            return null;
        }
        return all;
    }

    private static String getNewest(Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        String newest = null;
        for (String element : values) {
            if (newest != null && element.compareTo(newest) <= 0) continue;
            newest = element;
        }
        return newest;
    }

    static AndroidInfo getBuildRequirements(File deviceImgZipFile, Map<String, Constraint> constraints) throws TargetSetupError {
        ZipFile deviceZip = null;
        BufferedReader infoReader = null;
        try {
            deviceZip = new ZipFile(deviceImgZipFile);
            ZipEntry androidInfoEntry = deviceZip.getEntry(ANDROID_INFO_FILE_NAME);
            if (androidInfoEntry == null) {
                throw new TargetSetupError(String.format("Could not find %s in device image zip %s", ANDROID_INFO_FILE_NAME, deviceImgZipFile.getName()));
            }
            infoReader = new BufferedReader(new InputStreamReader(deviceZip.getInputStream(androidInfoEntry)));
            AndroidInfo androidInfo = FlashingResourcesParser.parseAndroidInfo(infoReader, constraints);
            return androidInfo;
        }
        catch (ZipException e) {
            throw new TargetSetupError(String.format("Could not read device image zip %s", deviceImgZipFile.getName()), e);
        }
        catch (IOException e) {
            throw new TargetSetupError(String.format("Could not read device image zip %s", deviceImgZipFile.getName()), e);
        }
        finally {
            if (deviceZip != null) {
                try {
                    deviceZip.close();
                }
                catch (IOException e) {}
            }
            if (infoReader != null) {
                try {
                    infoReader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static MultiMap<String, String> getOrCreateEntry(AndroidInfo map, String key) {
        if (map.containsKey(key)) {
            return (MultiMap)map.get(key);
        }
        MultiMap<String, String> value = new MultiMap<String, String>();
        map.put(key, value);
        return value;
    }

    static AndroidInfo parseAndroidInfo(BufferedReader infoReader, Map<String, Constraint> constraints) throws IOException {
        AndroidInfo requiredImageMap = new AndroidInfo();
        boolean eof = false;
        while (!eof) {
            String line = infoReader.readLine();
            if (line != null) {
                MultiMap<String, String> reqs;
                Matcher matcher = PRODUCT_REQUIRE_PATTERN.matcher(line);
                if (matcher.matches()) {
                    String product = matcher.group(1);
                    String key = matcher.group(2);
                    String values = matcher.group(3);
                    reqs = FlashingResourcesParser.getOrCreateEntry(requiredImageMap, product);
                    for (String value : values.split("\\|")) {
                        reqs.put(key, value);
                    }
                    continue;
                }
                matcher = REQUIRE_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                String key = matcher.group(1);
                String values = matcher.group(2);
                Constraint c = null;
                if (constraints != null) {
                    c = constraints.get(key);
                }
                reqs = FlashingResourcesParser.getOrCreateEntry(requiredImageMap, null);
                for (String value : values.split("\\|")) {
                    if (c != null && !c.shouldAccept(value)) continue;
                    reqs.put(key, value);
                }
                continue;
            }
            eof = true;
        }
        return requiredImageMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AndroidInfo
    extends HashMap<String, MultiMap<String, String>> {
    }

    public static interface Constraint {
        public boolean shouldAccept(String var1);
    }
}

