/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

@OptionClass(alias="install-apk")
public class InstallApkSetup
implements ITargetPreparer {
    private static final String LOG_TAG = InstallApkSetup.class.getSimpleName();
    @Option(name="apk-path", description="the filesystem path of the apk to install. Can be repeated.", importance=Option.Importance.IF_UNSET)
    private Collection<File> mApkPaths = new ArrayList<File>();

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        for (File apk : this.mApkPaths) {
            Log.i((String)LOG_TAG, (String)String.format("Installing %s on %s", apk.getName(), device.getSerialNumber()));
            String result = device.installPackage(apk, true, new String[0]);
            if (result == null) continue;
            Log.e((String)LOG_TAG, (String)String.format("Failed to install %s on device %s. Reason: %s", apk.getAbsolutePath(), device.getSerialNumber(), result));
        }
    }
}

