/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.HashMap;
import java.util.Map;

public class KeyValueConfigPreparer
implements ITargetPreparer {
    @Option(name="path", description="The path of the config file on the device", mandatory=true)
    private String mPath = null;
    @Option(name="config", description="The key/value pairs of the config")
    private Map<String, String> mKeys = new HashMap<String, String>();
    @Option(name="separator", description="The separator used between key and value")
    private String mSep = "=";

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws DeviceNotAvailableException, TargetSetupError {
        if (this.mPath == null) {
            throw new TargetSetupError("Option path must be specified");
        }
        StringBuilder config = new StringBuilder();
        for (Map.Entry<String, String> entry : this.mKeys.entrySet()) {
            config.append(String.format("%s%s%s\n", entry.getKey(), this.mSep, entry.getValue()));
        }
        device.pushString(config.toString(), this.mPath);
    }
}

