/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.ITargetPreparer;
import java.util.ArrayList;
import java.util.Collection;

public class StopServicesSetup
implements ITargetPreparer {
    @Option(name="stop-framework", description="stop the framework. Default true.")
    private boolean mStopFramework = true;
    @Option(name="service", description="the service to stop on the device. Can be repeated.")
    private Collection<String> mServices = new ArrayList<String>();

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws DeviceNotAvailableException {
        if (this.mStopFramework) {
            device.executeShellCommand("stop");
        }
        for (String service : this.mServices) {
            device.executeShellCommand(String.format("stop %s", service));
        }
    }

    void setStopFramework(boolean stopFramework) {
        this.mStopFramework = stopFramework;
    }

    void addService(String service) {
        this.mServices.add(service);
    }
}

