/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

@OptionClass(alias="tests-zip-app")
public class TestAppInstallSetup
implements ITargetPreparer {
    private static final String LOG_TAG = "TestAppInstallSetup";
    @Option(name="test-file-name", description="the name of a test zip file to install on device. Can be repeated.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mTestFileNames = new ArrayList<String>();

    public void addTestFileName(String fileName) {
        this.mTestFileNames.add(fileName);
    }

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (!(buildInfo instanceof IDeviceBuildInfo)) {
            throw new IllegalArgumentException(String.format("Provided buildInfo is not a %s", IDeviceBuildInfo.class.getCanonicalName()));
        }
        if (this.mTestFileNames.size() == 0) {
            Log.i((String)LOG_TAG, (String)"No test apps to install, skipping");
            return;
        }
        File testsDir = ((IDeviceBuildInfo)buildInfo).getTestsDir();
        if (testsDir == null || !testsDir.exists()) {
            throw new TargetSetupError("Provided buildInfo does not contain a valid tests directory");
        }
        for (String testAppName : this.mTestFileNames) {
            File testAppFile = FileUtil.getFileForPath(testsDir, "DATA", "app", testAppName);
            if (!testAppFile.exists()) {
                throw new TargetSetupError(String.format("Could not find test app %s directory in extracted tests.zip", testAppFile));
            }
            String result = device.installPackage(testAppFile, true, new String[0]);
            if (result == null) continue;
            throw new TargetSetupError(String.format("Failed to install %s on %s. Reason: '%s'", testAppName, device.getSerialNumber(), result));
        }
    }
}

