/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

@OptionClass(alias="tests-zip-file")
public class TestFilePushSetup
implements ITargetPreparer {
    @Option(name="test-file-name", description="the relative path of a test zip file/directory to install on device. Can be repeated.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mTestPaths = new ArrayList<String>();

    void addTestFileName(String fileName) {
        this.mTestPaths.add(fileName);
    }

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (!(buildInfo instanceof IDeviceBuildInfo)) {
            throw new IllegalArgumentException(String.format("Provided buildInfo is not a %s", IDeviceBuildInfo.class.getCanonicalName()));
        }
        if (this.mTestPaths.size() == 0) {
            LogUtil.CLog.d("No test files to push, skipping");
            return;
        }
        File testsDir = ((IDeviceBuildInfo)buildInfo).getTestsDir();
        if (testsDir == null || !testsDir.exists()) {
            throw new TargetSetupError("Provided buildInfo does not contain a valid tests directory");
        }
        for (String fileName : this.mTestPaths) {
            File localFile = FileUtil.getFileForPath(testsDir, "DATA", fileName);
            if (!localFile.exists()) {
                throw new TargetSetupError(String.format("Could not find test file %s directory in extracted tests.zip", localFile));
            }
            fileName = TestFilePushSetup.getDevicePathFromUserData(fileName);
            LogUtil.CLog.d("Pushing file: %s -> %s", localFile.getAbsoluteFile(), fileName);
            if (localFile.isDirectory()) {
                device.pushDir(localFile, fileName);
            } else if (localFile.isFile()) {
                device.pushFile(localFile, fileName);
            }
            device.executeShellCommand(String.format("chown system.system %s", fileName));
        }
    }

    static String getDevicePathFromUserData(String path) {
        return ArrayUtil.join("/", "", "data", path);
    }
}

