/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.JUnitRunUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTestCase
extends TestCase
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "DeviceTestCase";
    private ITestDevice mDevice;
    @Option(name="method", description="run a specific test method.")
    private String mMethodName = null;
    private Vector<String> mMethodNames = null;

    public DeviceTestCase() {
    }

    public DeviceTestCase(String name) {
        super(name);
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.getName() == null && this.mMethodName != null) {
            this.setName(this.mMethodName);
        }
        JUnitRunUtil.runTest(listener, this);
    }

    @Override
    public int countTestCases() {
        if (this.getName() != null || this.mMethodName != null) {
            return 1;
        }
        return this.getTestMethodNames().size();
    }

    @Override
    public void run(TestResult result) {
        if (this.getName() == null) {
            Collection<String> testMethodNames = this.getTestMethodNames();
            for (String methodName : testMethodNames) {
                this.setName(methodName);
                LogUtil.CLog.d("Running %s#%s()", this.getClass().getName(), methodName);
                super.run(result);
            }
        } else {
            LogUtil.CLog.d("Running %s#%s()", this.getClass().getName(), this.getName());
            super.run(result);
        }
    }

    private Collection<String> getTestMethodNames() {
        if (this.mMethodNames == null) {
            Class<?> theClass;
            this.mMethodNames = new Vector();
            Class<?> superClass = theClass = this.getClass();
            while (Test.class.isAssignableFrom(superClass)) {
                Method[] methods = superClass.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    this.addTestMethod(methods[i], this.mMethodNames, theClass);
                }
                superClass = superClass.getSuperclass();
            }
            if (this.mMethodNames.size() == 0) {
                Log.w((String)LOG_TAG, (String)String.format("No tests found in %s", theClass.getName()));
            }
        }
        return this.mMethodNames;
    }

    private void addTestMethod(Method m, Vector<String> names, Class<?> theClass) {
        String name = m.getName();
        if (names.contains(name)) {
            return;
        }
        if (!this.isPublicTestMethod(m)) {
            if (this.isTestMethod(m)) {
                Log.w((String)LOG_TAG, (String)String.format("Test method isn't public: %s", m.getName()));
            }
            return;
        }
        names.addElement(name);
    }

    private boolean isPublicTestMethod(Method m) {
        return this.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private boolean isTestMethod(Method m) {
        String name = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }
}

